/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.AutoValue_PackagesParser_InstalledPackageInfo;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PackagesParser {
    private static final Pattern PACKAGE_AND_VERSION = Pattern.compile("package:(?<package>.+?) versionCode:(?<version>\\d+)");
    private final boolean isApex;

    public PackagesParser(boolean isApex) {
        this.isApex = isApex;
    }

    public ImmutableSet<InstalledPackageInfo> parse(ImmutableList<String> listPackagesOutput) {
        return (ImmutableSet)listPackagesOutput.stream().map(PACKAGE_AND_VERSION::matcher).filter(Matcher::matches).map(this::processMatch).collect(ImmutableSet.toImmutableSet());
    }

    private InstalledPackageInfo processMatch(Matcher matcher) {
        return InstalledPackageInfo.create(matcher.group("package"), Long.parseLong(matcher.group("version")), this.isApex);
    }

    @AutoValue
    public static abstract class InstalledPackageInfo {
        static InstalledPackageInfo create(String packageName, long versionCode, boolean isApex) {
            return new AutoValue_PackagesParser_InstalledPackageInfo(packageName, versionCode, isApex);
        }

        public abstract String getPackageName();

        public abstract long getVersionCode();

        public abstract boolean isApex();
    }
}

