/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.version;

import com.android.tools.build.bundletool.model.version.Version;
import java.util.Optional;

public enum VersionGuardedFeature {
    NAMESPACE_ON_INCLUDE_ATTRIBUTE_REQUIRED("0.3.4"),
    RESOURCES_WITH_NO_ALTERNATIVES_IN_MASTER_SPLIT("0.4.0"),
    MODULE_TITLE_VALIDATION_ENFORCED("0.4.3"),
    NO_DEFAULT_UNCOMPRESS_EXTENSIONS("0.7.3"),
    RESOURCES_REFERENCED_IN_MANIFEST_TO_MASTER_SPLIT("0.8.1", "1.7.0"),
    PREFER_EXPLICIT_DPI_OVER_DEFAULT_CONFIG("0.9.1"),
    NEW_DELIVERY_TYPE_MANIFEST_TAG("0.10.2"),
    NO_V1_SIGNING_WHEN_POSSIBLE("0.11.0"),
    FUSE_APPLICATION_ELEMENTS_FROM_FEATURE_MANIFESTS("1.8.0"),
    FUSE_ACTIVITIES_FROM_FEATURE_MANIFESTS("0.13.4"),
    PIN_LOWEST_DENSITY_OF_EACH_STYLE_TO_MASTER("0.14.0"),
    MERGE_INSTALL_TIME_MODULES_INTO_BASE("1.0.0"),
    FIX_SKIP_GENERATING_EMPTY_DENSITY_SPLITS("1.15.1");

    private final Version enabledSinceVersion;
    private final Optional<Version> disabledSinceVersion;

    private VersionGuardedFeature(String enabledSinceVersion) {
        this.enabledSinceVersion = Version.of(enabledSinceVersion);
        this.disabledSinceVersion = Optional.empty();
    }

    private VersionGuardedFeature(String enabledSinceVersion, String disabledSinceVersion) {
        this.enabledSinceVersion = Version.of(enabledSinceVersion);
        this.disabledSinceVersion = Optional.of(Version.of(disabledSinceVersion));
    }

    public boolean enabledForVersion(Version bundletoolVersion) {
        if (bundletoolVersion.isOlderThan(this.enabledSinceVersion)) {
            return false;
        }
        return this.disabledSinceVersion.map(bundletoolVersion::isOlderThan).orElse(true);
    }

    public Version getEnabledSinceVersion() {
        return this.enabledSinceVersion;
    }
}

