/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.android.bundle.Config;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BundleModuleParser {
    public static BundleModule parseAppBundleModule(ZipFile moduleZipFile, Config.BundleConfig bundleConfig) {
        BundleModule.Builder bundleModuleBuilder = BundleModuleParser.parseBundleModuleInternal(moduleZipFile, bundleConfig.getBundletool(), bundleConfig.getType());
        if (bundleConfig.hasApexConfig()) {
            bundleModuleBuilder.setBundleApexConfig(bundleConfig.getApexConfig());
        }
        return bundleModuleBuilder.build();
    }

    public static BundleModule parseSdkBundleModule(ZipFile moduleZipFile, SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig) {
        return BundleModuleParser.parseBundleModuleInternal(moduleZipFile, sdkModulesConfig.getBundletool(), Config.BundleConfig.BundleType.REGULAR).build();
    }

    private static BundleModule.Builder parseBundleModuleInternal(ZipFile moduleZipFile, Config.Bundletool bundletool, Config.BundleConfig.BundleType bundleType) {
        BundleModule.Builder bundleModuleBuilder = BundleModule.builder().setName(BundleModuleName.create("TEMPORARY_MODULE_NAME")).setBundleType(bundleType).setBundletoolVersion(Version.of(bundletool.getVersion())).addEntries((Collection)moduleZipFile.stream().filter((Predicate<? extends ZipEntry>)Predicates.not(ZipEntry::isDirectory)).map(zipEntry -> ModuleEntry.builder().setFileLocation(ModuleEntry.ModuleEntryLocationInZipSource.create(Paths.get(moduleZipFile.getName(), new String[0]), ZipPath.create(zipEntry.getName()))).setPath(ZipPath.create(zipEntry.getName())).setContent(ZipUtils.asByteSource(moduleZipFile, zipEntry)).build()).collect(ImmutableList.toImmutableList()));
        BundleModuleName actualModuleName = bundleModuleBuilder.build().getAndroidManifest().getSplitId().map(BundleModuleName::create).orElse(BundleModuleName.BASE_MODULE_NAME);
        return bundleModuleBuilder.setName(actualModuleName);
    }

    private BundleModuleParser() {
    }
}

