/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.io.ByteSource;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import shadow.bundletool.com.android.zipflinger.BytesSource;
import shadow.bundletool.com.android.zipflinger.Source;
import shadow.bundletool.com.android.zipflinger.Sources;
import shadow.bundletool.com.android.zipflinger.ZipArchive;
import shadow.bundletool.com.android.zipflinger.ZipSource;

public final class ZipFlingerBundleSerializer {
    private static final int DEFAULT_COMPRESSION_LEVEL = 6;

    public void serializeAppBundle(AppBundle bundle, Path destBundlePath) throws IOException {
        try (ZipArchive zipArchive = new ZipArchive(destBundlePath);){
            zipArchive.add(ZipFlingerBundleSerializer.protoToSource(ZipPath.create("BundleConfig.pb"), (MessageLite)bundle.getBundleConfig(), 6));
            if (bundle.getFeatureModules().isEmpty() || !bundle.isApex()) {
                for (Map.Entry metadataEntry : bundle.getBundleMetadata().getFileContentMap().entrySet()) {
                    zipArchive.add(new BytesSource(((ByteSource)metadataEntry.getValue()).read(), AppBundle.METADATA_DIRECTORY.resolve((ZipPath)metadataEntry.getKey()).toString(), 6));
                }
            }
            ZipFlingerBundleSerializer.addEntriesFromSourceBundles(zipArchive, ZipFlingerBundleSerializer.getUnmodifiedModuleEntries(bundle), false);
            ZipFlingerBundleSerializer.addNewEntries(zipArchive, ZipFlingerBundleSerializer.getNewOrModifiedModuleEntries(bundle));
            for (BundleModule module : bundle.getModules().values()) {
                ZipPath moduleDir = ZipPath.create(module.getName().toString());
                zipArchive.add(ZipFlingerBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()), (MessageLite)module.getAndroidManifest().getManifestRoot().getProto(), 6));
                if (module.getAssetsConfig().isPresent()) {
                    zipArchive.add(ZipFlingerBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.ASSETS_TABLE.getPath()), (MessageLite)module.getAssetsConfig().get(), 6));
                }
                if (module.getNativeConfig().isPresent()) {
                    zipArchive.add(ZipFlingerBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.NATIVE_LIBS_TABLE.getPath()), (MessageLite)module.getNativeConfig().get(), 6));
                }
                if (module.getResourceTable().isPresent()) {
                    zipArchive.add(ZipFlingerBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()), (MessageLite)module.getResourceTable().get(), 6));
                }
                if (!module.getApexConfig().isPresent()) continue;
                zipArchive.add(ZipFlingerBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.APEX_TABLE.getPath()), (MessageLite)module.getApexConfig().get(), 6));
            }
        }
    }

    public void serializeSdkBundle(SdkBundle sdkBundle, Path pathOnDisk) throws IOException {
        try (TempDirectory tempDir = new TempDirectory(this.getClass().getSimpleName());
             ZipArchive zipArchive = new ZipArchive(pathOnDisk);){
            zipArchive.add(ZipFlingerBundleSerializer.protoToSource(ZipPath.create("SdkBundleConfig.pb"), (MessageLite)sdkBundle.getSdkBundleConfig(), 6));
            if (sdkBundle.getSdkInterfaceDescriptors().isPresent()) {
                zipArchive.add(new BytesSource(sdkBundle.getSdkInterfaceDescriptors().get().openStream(), "sdk-interface-descriptors.jar", 6));
            }
            for (Map.Entry metadataEntry : sdkBundle.getBundleMetadata().getFileContentMap().entrySet()) {
                zipArchive.add(new BytesSource(((ByteSource)metadataEntry.getValue()).read(), AppBundle.METADATA_DIRECTORY.resolve((ZipPath)metadataEntry.getKey()).toString(), 6));
            }
            Path modulesPath = tempDir.getPath().resolve("extracted-modules.resm");
            this.writeTempModulesFile(sdkBundle, modulesPath);
            zipArchive.add(Sources.from(modulesPath, "modules.resm", 6));
        }
    }

    private void writeTempModulesFile(SdkBundle sdkBundle, Path modulesPath) throws IOException {
        try (ZipArchive modulesArchive = new ZipArchive(modulesPath);){
            modulesArchive.add(ZipFlingerBundleSerializer.protoToSource(ZipPath.create("SdkModulesConfig.pb"), (MessageLite)sdkBundle.getSdkModulesConfig(), 6));
            BundleModule module = sdkBundle.getModule();
            ZipPath moduleDir = ZipPath.create(module.getName().toString());
            ZipFlingerBundleSerializer.addEntriesFromSourceBundles(modulesArchive, ZipFlingerBundleSerializer.getUnmodifiedModuleEntries(sdkBundle), true);
            ZipFlingerBundleSerializer.addNewEntries(modulesArchive, ZipFlingerBundleSerializer.getNewOrModifiedModuleEntries(sdkBundle));
            modulesArchive.add(ZipFlingerBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()), (MessageLite)module.getAndroidManifest().getManifestRoot().getProto(), 6));
            if (module.getAssetsConfig().isPresent()) {
                modulesArchive.add(ZipFlingerBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.ASSETS_TABLE.getPath()), (MessageLite)module.getAssetsConfig().get(), 6));
            }
            if (module.getNativeConfig().isPresent()) {
                modulesArchive.add(ZipFlingerBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.NATIVE_LIBS_TABLE.getPath()), (MessageLite)module.getNativeConfig().get(), 6));
            }
            if (module.getResourceTable().isPresent()) {
                modulesArchive.add(ZipFlingerBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()), (MessageLite)module.getResourceTable().get(), 6));
            }
        }
    }

    @VisibleForTesting
    static ImmutableListMultimap<BundleModule, ModuleEntry> getUnmodifiedModuleEntries(AppBundle bundle) {
        return ZipFlingerBundleSerializer.getUnmodifiedModuleEntries((ImmutableCollection<BundleModule>)bundle.getModules().values());
    }

    @VisibleForTesting
    static ImmutableListMultimap<BundleModule, ModuleEntry> getUnmodifiedModuleEntries(SdkBundle bundle) {
        return ZipFlingerBundleSerializer.getUnmodifiedModuleEntries((ImmutableCollection<BundleModule>)ImmutableList.of((Object)bundle.getModule()));
    }

    static ImmutableListMultimap<BundleModule, ModuleEntry> getUnmodifiedModuleEntries(ImmutableCollection<BundleModule> bundleModules) {
        return (ImmutableListMultimap)bundleModules.stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(module -> module, module -> module.getEntries().stream().filter(entry -> entry.getFileLocation().isPresent())));
    }

    private static ImmutableListMultimap<BundleModule, ModuleEntry> getNewOrModifiedModuleEntries(AppBundle bundle) {
        return ZipFlingerBundleSerializer.getNewOrModifiedModuleEntries((ImmutableCollection<BundleModule>)bundle.getModules().values());
    }

    @VisibleForTesting
    static ImmutableListMultimap<BundleModule, ModuleEntry> getNewOrModifiedModuleEntries(SdkBundle bundle) {
        return ZipFlingerBundleSerializer.getNewOrModifiedModuleEntries((ImmutableCollection<BundleModule>)ImmutableList.of((Object)bundle.getModule()));
    }

    static ImmutableListMultimap<BundleModule, ModuleEntry> getNewOrModifiedModuleEntries(ImmutableCollection<BundleModule> bundleModules) {
        return (ImmutableListMultimap)bundleModules.stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(module -> module, module -> module.getEntries().stream().filter(entry -> !entry.getFileLocation().isPresent())));
    }

    private static void addEntriesFromSourceBundles(ZipArchive archive, ImmutableListMultimap<BundleModule, ModuleEntry> entries, boolean compress) throws IOException {
        HashMap<Path, ZipSource> bundleSources = new HashMap<Path, ZipSource>();
        for (Map.Entry moduleAndEntry : entries.entries()) {
            BundleModule module = (BundleModule)moduleAndEntry.getKey();
            ModuleEntry moduleEntry = (ModuleEntry)moduleAndEntry.getValue();
            ModuleEntry.ModuleEntryLocationInZipSource location = moduleEntry.getFileLocation().orElseThrow(IllegalStateException::new);
            ZipPath entryFullPathInSourceBundle = location.entryPathInFile();
            ZipPath moduleDir = ZipPath.create(module.getName().toString());
            ZipPath entryFullPathInDestBundle = moduleDir.resolve(moduleEntry.getPath());
            Path pathToBundle = location.pathToFile();
            ZipSource entrySource = bundleSources.containsKey(pathToBundle) ? (ZipSource)bundleSources.get(pathToBundle) : new ZipSource(pathToBundle);
            bundleSources.putIfAbsent(pathToBundle, entrySource);
            String entryPath = entryFullPathInSourceBundle.toString();
            entrySource.select(entryPath, entryFullPathInDestBundle.toString(), ZipFlingerBundleSerializer.getCompressionLevel(entrySource, entryPath, compress), 0L);
        }
        for (ZipSource source : bundleSources.values()) {
            archive.add(source);
        }
    }

    private static void addNewEntries(ZipArchive archive, ImmutableListMultimap<BundleModule, ModuleEntry> entries) throws IOException {
        for (Map.Entry moduleAndEntry : entries.entries()) {
            BundleModule module = (BundleModule)moduleAndEntry.getKey();
            ModuleEntry moduleEntry = (ModuleEntry)moduleAndEntry.getValue();
            Preconditions.checkState((!moduleEntry.getFileLocation().isPresent() ? 1 : 0) != 0);
            ZipPath moduleDir = ZipPath.create(module.getName().toString());
            ZipPath destPath = moduleDir.resolve(moduleEntry.getPath());
            archive.add(new BytesSource(moduleEntry.getContent().read(), destPath.toString(), 6));
        }
    }

    private static Source protoToSource(ZipPath path, MessageLite proto, int compression) throws IOException {
        return new BytesSource(proto.toByteArray(), path.toString(), compression);
    }

    private static int getCompressionLevel(ZipSource entrySource, String entryPath, boolean compress) {
        if (!compress) {
            return -2;
        }
        if (entrySource.entries().get(entryPath).isCompressed()) {
            return -2;
        }
        return 6;
    }
}

