/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.commands.BuildSdkApksForAppCommand;
import com.android.tools.build.bundletool.io.ApkSerializerManager;
import com.android.tools.build.bundletool.io.ApkSetWriter;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.GeneratedAssetSlices;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.shards.ModuleSplitterForShards;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import javax.inject.Inject;

public class BuildSdkApksForAppManager {
    private final BuildSdkApksForAppCommand command;
    private final BundleModule module;
    private final ModuleSplitterForShards moduleSplitterForShards;
    private final TempDirectory tempDirectory;
    private final ApkSerializerManager apkSerializerManager;

    @Inject
    BuildSdkApksForAppManager(BuildSdkApksForAppCommand command, BundleModule module, ModuleSplitterForShards moduleSplitterForShards, TempDirectory tempDirectory, ApkSerializerManager apkSerializerManager) {
        this.command = command;
        this.module = module;
        this.moduleSplitterForShards = moduleSplitterForShards;
        this.tempDirectory = tempDirectory;
        this.apkSerializerManager = apkSerializerManager;
    }

    void execute() {
        ImmutableList<ModuleSplit> splits = this.moduleSplitterForShards.generateSplits(this.module, (ImmutableSet<OptimizationDimension>)ImmutableSet.of());
        GeneratedApks generatedApks = GeneratedApks.fromModuleSplits(splits);
        ApkSetWriter apkSetWriter = ApkSetWriter.zip(this.tempDirectory.getPath(), this.command.getOutputFile());
        this.apkSerializerManager.serializeApkSetWithoutToc(apkSetWriter, generatedApks, GeneratedAssetSlices.builder().build(), Optional.empty(), Commands.LocalTestingInfo.getDefaultInstance(), (ImmutableSet<BundleModuleName>)ImmutableSet.of());
    }
}

