/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.manifestelements.Activity;
import com.android.tools.build.bundletool.model.manifestelements.Provider;
import com.android.tools.build.bundletool.model.manifestelements.Receiver;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttributeBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNodeBuilder;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Optional;
import java.util.stream.Collectors;

public class ManifestEditor {
    private static final ImmutableList<String> SPLIT_NAME_ELEMENT_NAMES = ImmutableList.of((Object)"activity", (Object)"service", (Object)"provider");
    private final XmlProtoNodeBuilder rootNode;
    private final XmlProtoElementBuilder manifestElement;
    private final Version bundleToolVersion;

    public ManifestEditor(XmlProtoNode rootNode, Version bundleToolVersion) {
        this.rootNode = rootNode.toBuilder();
        this.manifestElement = (XmlProtoElementBuilder)this.rootNode.getElement();
        this.bundleToolVersion = bundleToolVersion;
    }

    public XmlProtoElementBuilder getRawProto() {
        return this.manifestElement;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setMinSdkVersion(int minSdkVersion) {
        return this.setUsesSdkAttribute("minSdkVersion", 16843276, minSdkVersion);
    }

    @CanIgnoreReturnValue
    public ManifestEditor setSplitIdForFeatureSplit(String splitId) {
        if (ManifestEditor.isBaseSplit(splitId)) {
            this.manifestElement.removeAttribute("", "split");
            this.manifestElement.removeAttribute("http://schemas.android.com/apk/res/android", "isFeatureSplit");
        } else {
            this.manifestElement.getOrCreateAttribute("split").setValueAsString(splitId);
            this.manifestElement.getOrCreateAndroidAttribute("isFeatureSplit", 16844123).setValueAsBoolean(true);
        }
        this.manifestElement.removeAttribute("", "configForSplit");
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setHasCode(boolean value) {
        return this.setApplcationAttributeBoolean("hasCode", 0x101000C, value);
    }

    @CanIgnoreReturnValue
    public ManifestEditor setPackage(String packageName) {
        this.manifestElement.getOrCreateAttribute("package").setValueAsString(packageName);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setVersionCode(int versionCode) {
        this.manifestElement.getOrCreateAndroidAttribute("versionCode", 16843291).setValueAsDecimalInteger(versionCode);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setVersionName(String versionName) {
        this.manifestElement.getOrCreateAndroidAttribute("versionName", 16843292).setValueAsString(versionName);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setConfigForSplit(String featureSplitId) {
        this.manifestElement.getOrCreateAttribute("configForSplit").setValueAsString(featureSplitId);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setSplitId(String splitId) {
        this.manifestElement.getOrCreateAttribute("split").setValueAsString(splitId);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setTargetSandboxVersion(int version) {
        this.manifestElement.getOrCreateAndroidAttribute("targetSandboxVersion", 16844108).setValueAsDecimalInteger(version);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setLocaleConfig(int resourceId) {
        return this.setApplcationAttributeRefId("localeConfig", 31391758, resourceId);
    }

    @CanIgnoreReturnValue
    public ManifestEditor addMetaDataString(String key, String value) {
        return this.addMetaDataValue(key, XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsString(value));
    }

    @CanIgnoreReturnValue
    public ManifestEditor addMetaDataInteger(String key, int value) {
        return this.addMetaDataValue(key, XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsDecimalInteger(value));
    }

    @CanIgnoreReturnValue
    public ManifestEditor addMetaDataBoolean(String key, boolean value) {
        return this.addMetaDataValue(key, XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsBoolean(value));
    }

    @CanIgnoreReturnValue
    public ManifestEditor addMetaDataResourceId(String key, int resourceId) {
        return this.addMetaDataValue(key, XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842789).setValueAsRefId(resourceId));
    }

    @CanIgnoreReturnValue
    private ManifestEditor addMetaDataValue(String key, XmlProtoAttributeBuilder valueAttribute) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("meta-data").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(key)).addAttribute(valueAttribute));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor addApplicationChildElement(XmlProtoElement element) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(element.toBuilder());
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setExtractNativeLibsValue(boolean value) {
        this.setApplcationAttributeBoolean("extractNativeLibs", 16844010, value);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setFusedModuleNames(ImmutableList<String> moduleNames) {
        String moduleNamesString = moduleNames.stream().sorted().distinct().collect(Collectors.joining(","));
        this.setMetadataValue("com.android.dynamic.apk.fused.modules", XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsString(moduleNamesString));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setSplitsRequired(boolean value) {
        this.setMetadataValue("com.android.vending.splits.required", XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsBoolean(value));
        return this.setApplcationAttributeBoolean("isSplitRequired", 16844177, value);
    }

    @CanIgnoreReturnValue
    public ManifestEditor addApplicationElementIfMissing() {
        this.manifestElement.getOrCreateChildElement("application");
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setAllowBackup(Boolean value) {
        return this.setApplcationAttributeBoolean("allowBackup", 16843392, value);
    }

    @CanIgnoreReturnValue
    private ManifestEditor setApplcationAttributeBoolean(String attributeName, int resourceId, boolean value) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateAndroidAttribute(attributeName, resourceId).setValueAsBoolean(value);
        return this;
    }

    @CanIgnoreReturnValue
    private ManifestEditor setApplcationAttributeRefId(String attributeName, int resourceId, int value) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateAndroidAttribute(attributeName, resourceId).setValueAsRefId(value);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setIcon(int resourceId) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateAndroidAttribute("icon", 0x1010002).setValueAsRefId(resourceId);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setRoundIcon(int resourceId) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateAndroidAttribute("roundIcon", 16844076).setValueAsRefId(resourceId);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor removeSplitName() {
        this.manifestElement.getOrCreateChildElement("application").getChildrenElements(el2 -> SPLIT_NAME_ELEMENT_NAMES.contains((Object)el2.getName())).forEach(element -> element.removeAndroidAttribute(16844105));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor removeUnknownSplitComponents(ImmutableSet<String> allModuleNames) {
        Optional applicationElement = this.manifestElement.getOptionalChildElement("application");
        if (!applicationElement.isPresent()) {
            return this;
        }
        ((XmlProtoElementBuilder)applicationElement.get()).removeChildrenElementsIf(el2 -> el2.isElement() && ((XmlProtoElementBuilder)el2.getElement()).getAndroidAttribute(16844105).filter(attr -> !allModuleNames.contains((Object)attr.getValueAsString())).isPresent());
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor addActivity(Activity activity) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(activity.asXmlProtoElement().toBuilder());
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor addReceiver(Receiver receiver) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(receiver.asXmlProtoElement().toBuilder());
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor addProvider(Provider provider) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(provider.asXmlProtoElement().toBuilder());
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor addUsesSdkLibraryElement(String name, long versionMajor, String certDigest) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("uses-sdk-library").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(name)).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("versionMajor", 16844151).setValueAsString(String.valueOf(versionMajor))).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("certDigest", 16844104).setValueAsString(certDigest)));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setSdkLibraryElement(String sdkPackageName, int versionMajor) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateChildElement("sdk-library").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(sdkPackageName)).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("versionMajor", 16844151).setValueAsDecimalInteger(versionMajor));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setSdkPatchVersionProperty(int patchVersion) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("property").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString("shadow.bundletool.com.android.vending.sdk.version.patch")).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsDecimalInteger(patchVersion)));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setSdkProviderClassName(String sdkProviderClassName) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("property").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString("android.sdksandbox.PROPERTY_SDK_PROVIDER_CLASS_NAME")).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsString(sdkProviderClassName)));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setCompatSdkProviderClassName(String compatSdkProviderClassName) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("property").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString("android.sdksandbox.PROPERTY_COMPAT_SDK_PROVIDER_CLASS_NAME")).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsString(compatSdkProviderClassName)));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setDeliveryOptionsForRuntimeEnabledSdkModule() {
        this.manifestElement.getOrCreateChildElement("http://schemas.android.com/apk/distribution", "module").addChildElement(XmlProtoElementBuilder.create("http://schemas.android.com/apk/distribution", "delivery").addChildElement(XmlProtoElementBuilder.create("http://schemas.android.com/apk/distribution", "install-time").addChildElement(XmlProtoElementBuilder.create("http://schemas.android.com/apk/distribution", "removable").addAttribute(XmlProtoAttributeBuilder.create("http://schemas.android.com/apk/distribution", "value").setResourceId(16842788).setValueAsBoolean(true))))).addChildElement(XmlProtoElementBuilder.create("http://schemas.android.com/apk/distribution", "fusing").addAttribute(XmlProtoAttributeBuilder.create("http://schemas.android.com/apk/distribution", "include").setValueAsBoolean(true)));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor setDistributionModuleForRecoveryModule() {
        this.manifestElement.getOrCreateChildElement("http://schemas.android.com/apk/distribution", "module").addChildElement(XmlProtoElementBuilder.create("http://schemas.android.com/apk/distribution", "delivery").addChildElement(XmlProtoElementBuilder.create("http://schemas.android.com/apk/distribution", "on-demand"))).addChildElement(XmlProtoElementBuilder.create("http://schemas.android.com/apk/distribution", "fusing").addAttribute(XmlProtoAttributeBuilder.create("http://schemas.android.com/apk/distribution", "include").setValueAsBoolean(false)));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor removeUsesSdkElement() {
        this.manifestElement.removeChildrenElementsIf(childElement -> childElement.isElement() && ((XmlProtoElementBuilder)childElement.getElement()).getName().equals("uses-sdk"));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor addUsesFeatureElement(String featureName, boolean isRequired) {
        this.manifestElement.addChildElement(XmlProtoElementBuilder.create("uses-feature").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(featureName)).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("required", 16843406).setValueAsBoolean(isRequired)));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor copyManifestElementAndroidAttribute(AndroidManifest from, int attrResourceId) {
        Optional attribute = from.getManifestElement().getAndroidAttribute(attrResourceId);
        if (attribute.isPresent()) {
            this.manifestElement.addAttribute(((XmlProtoAttribute)attribute.get()).toBuilder());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor copyApplicationElementAndroidAttribute(AndroidManifest from, int attrResourceId) {
        Optional attribute = from.getManifestElement().getOptionalChildElement("application").flatMap(applicationElement -> applicationElement.getAndroidAttribute(attrResourceId));
        if (attribute.isPresent()) {
            this.manifestElement.getOrCreateChildElement("application").addAttribute(((XmlProtoAttribute)attribute.get()).toBuilder());
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor copyChildrenElements(AndroidManifest from, String elementsName) {
        from.getManifestElement().getChildrenElements(elementsName).forEach(element -> this.manifestElement.addChildElement(element.toBuilder()));
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor removeElementsRequiredByPrivacySandboxSdk() {
        this.removeElementsRequiredByPrivacySandboxSdkRecursively(this.manifestElement);
        return this;
    }

    @CanIgnoreReturnValue
    public ManifestEditor removeRequiredByPrivacySandboxSdkAttributes() {
        this.removeRequiredByPrivacySandboxSdkAttributesRecursively(this.manifestElement);
        return this;
    }

    private void removeElementsRequiredByPrivacySandboxSdkRecursively(XmlProtoElementBuilder element) {
        element.removeChildrenElementsIf(childElement -> childElement.isElement() && this.isRequiredByPrivacySandboxSdk((XmlProtoNodeBuilder)childElement));
        element.getChildrenElements().forEach(this::removeElementsRequiredByPrivacySandboxSdkRecursively);
    }

    private void removeRequiredByPrivacySandboxSdkAttributesRecursively(XmlProtoElementBuilder element) {
        element.getChildrenElements().forEach(childElement -> {
            if (this.hasRequiredByPrivacySandboxSdkAttr((XmlProtoElementBuilder)childElement)) {
                childElement.removeAttribute("http://schemas.android.com/tools", "requiredByPrivacySandboxSdk");
            }
            this.removeRequiredByPrivacySandboxSdkAttributesRecursively((XmlProtoElementBuilder)childElement);
        });
    }

    private boolean isRequiredByPrivacySandboxSdk(XmlProtoNodeBuilder element) {
        return this.hasRequiredByPrivacySandboxSdkAttr(element) && ((XmlProtoAttributeBuilder)((XmlProtoElementBuilder)element.getElement()).getAttribute("http://schemas.android.com/tools", "requiredByPrivacySandboxSdk").get()).getValueAsBoolean();
    }

    private boolean hasRequiredByPrivacySandboxSdkAttr(XmlProtoNodeBuilder element) {
        return this.hasRequiredByPrivacySandboxSdkAttr((XmlProtoElementBuilder)element.getElement());
    }

    private boolean hasRequiredByPrivacySandboxSdkAttr(XmlProtoElementBuilder element) {
        return element.getAttribute("http://schemas.android.com/tools", "requiredByPrivacySandboxSdk").isPresent();
    }

    @CheckReturnValue
    public AndroidManifest save() {
        return AndroidManifest.create(this.rootNode.build(), this.bundleToolVersion);
    }

    @CanIgnoreReturnValue
    private ManifestEditor setMetadataValue(String name, XmlProtoAttributeBuilder valueAttr) {
        XmlProtoElementBuilder applicationEl = this.manifestElement.getOrCreateChildElement("application");
        Optional existingMetadataEl = (Optional)applicationEl.getChildrenElements("meta-data").filter(metadataEl -> metadataEl.getAndroidAttribute(0x1010003).map(nameAttr -> name.equals(nameAttr.getValueAsString())).orElse(false)).collect(MoreCollectors.toOptional());
        if (existingMetadataEl.isPresent()) {
            ((XmlProtoElementBuilder)existingMetadataEl.get()).removeAndroidAttribute(16842788).addAttribute(valueAttr);
        } else {
            applicationEl.addChildElement(XmlProtoElementBuilder.create("meta-data").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(name)).addAttribute(valueAttr));
        }
        return this;
    }

    @CanIgnoreReturnValue
    private ManifestEditor setUsesSdkAttribute(String attributeName, int attributeResId, int value) {
        this.manifestElement.getOrCreateChildElement("uses-sdk").getOrCreateAndroidAttribute(attributeName, attributeResId).setValueAsDecimalInteger(value);
        return this;
    }

    private static boolean isBaseSplit(String splitId) {
        return splitId.isEmpty();
    }
}

