/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.AutoValue_ZipBuilder_Entry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.ZipUtils;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.MessageLite;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.concurrent.GuardedBy;

public final class ZipBuilder {
    private static final long PRELOAD_INTO_MEMORY_THRESHOLD = 0x9600000L;
    private static final long EPOCH = 0L;
    @GuardedBy(value="this")
    private final Map<ZipPath, Entry> entries = new LinkedHashMap<ZipPath, Entry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Path writeTo(Path target) throws IOException {
        Path tempFile = Files.createTempFile("ZipBuilder-", ".zip.tmp", new FileAttribute[0]);
        try {
            try (OutputStream out = BufferedIo.outputStream(tempFile);
                 ZipOutputStream outZip = new ZipOutputStream(out);){
                for (ZipPath path : this.entries.keySet()) {
                    ZipEntry zipEntry;
                    Entry entry = this.entries.get(path);
                    if (entry.getIsDirectory()) {
                        zipEntry = new ZipEntry(path + "/");
                        zipEntry.setTime(0L);
                        outZip.putNextEntry(zipEntry);
                    } else {
                        zipEntry = new ZipEntry(path.toString());
                        zipEntry.setTime(0L);
                        if (entry.hasOption(EntryOption.UNCOMPRESSED)) {
                            zipEntry.setMethod(0);
                            ByteSource originalData = entry.getContent().get();
                            ByteSource entryData = originalData.size() < 0x9600000L ? ZipBuilder.preloadEntryData(originalData) : originalData;
                            zipEntry.setSize(entryData.size());
                            zipEntry.setCompressedSize(entryData.size());
                            zipEntry.setCrc(entryData.hash(Hashing.crc32()).padToLong());
                            outZip.putNextEntry(zipEntry);
                            entry.getContent().get().copyTo((OutputStream)outZip);
                        } else {
                            outZip.putNextEntry(zipEntry);
                            entry.getContent().get().copyTo((OutputStream)outZip);
                        }
                    }
                    outZip.closeEntry();
                }
            }
            Files.move(tempFile, target, new CopyOption[0]);
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
        return target;
    }

    public ZipBuilder addFileWithContent(ZipPath toPath, byte[] content, EntryOption ... options) {
        return this.addFile(toPath, ByteSource.wrap((byte[])content), options);
    }

    public ZipBuilder addFileFromDisk(ZipPath toPath, File file, EntryOption ... options) {
        Preconditions.checkArgument((boolean)file.isFile(), (String)"Path '%s' does not denote a file.", (Object)file);
        return this.addFile(toPath, com.google.common.io.Files.asByteSource((File)file), options);
    }

    public ZipBuilder addFileWithProtoContent(ZipPath toPath, MessageLite protoMsg, EntryOption ... options) {
        return this.addFileWithContent(toPath, protoMsg.toByteArray(), options);
    }

    public ZipBuilder addFileFromZip(ZipPath toPath, ZipFile fromZipFile, ZipEntry zipEntry, EntryOption ... options) {
        return this.addFile(toPath, ZipUtils.asByteSource(fromZipFile, zipEntry), options);
    }

    public ZipBuilder addFileFromZipPreservingCompression(ZipPath toPath, ZipFile fromZipFile, ZipEntry zipEntry) {
        EntryOption[] entryOptionArray;
        if (zipEntry.getMethod() == 0) {
            EntryOption[] entryOptionArray2 = new EntryOption[1];
            entryOptionArray = entryOptionArray2;
            entryOptionArray2[0] = EntryOption.UNCOMPRESSED;
        } else {
            entryOptionArray = new EntryOption[]{};
        }
        EntryOption[] entryOption = entryOptionArray;
        return this.addFileFromZip(toPath, fromZipFile, zipEntry, entryOption);
    }

    public ZipBuilder addFile(ZipPath toPath, ByteSource content, EntryOption ... options) {
        return this.addEntryInternal(toPath, Entry.builder().setIsDirectory(false).setContent(content).setOptions((ImmutableSet<EntryOption>)ImmutableSet.copyOf((Object[])options)).build());
    }

    public ZipBuilder addDirectory(ZipPath dir) {
        return this.addEntryInternal(dir, Entry.builder().setIsDirectory(true).setOptions((ImmutableSet<EntryOption>)ImmutableSet.of()).build());
    }

    private synchronized ZipBuilder addEntryInternal(ZipPath path, Entry entry) {
        Preconditions.checkArgument((this.entries.put(path, entry) == null ? 1 : 0) != 0, (String)"Path '%s' is already taken.", (Object)path);
        return this;
    }

    public ZipBuilder copyAllContentsFromZip(ZipPath toDirectory, ZipFile srcZipFile, EntryOption ... entryOptions) {
        Enumeration<? extends ZipEntry> zipEntries = srcZipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory()) continue;
            this.addFileFromZip(toDirectory.resolve(zipEntry.getName()), srcZipFile, zipEntry, entryOptions);
        }
        return this;
    }

    private static ByteSource preloadEntryData(ByteSource byteSource) throws IOException {
        return ByteSource.wrap((byte[])byteSource.read());
    }

    public static enum EntryOption {
        UNCOMPRESSED;

    }

    @Immutable
    @AutoValue
    @AutoValue.CopyAnnotations
    protected static abstract class Entry {
        protected Entry() {
        }

        public abstract Optional<ByteSource> getContent();

        public abstract boolean getIsDirectory();

        public abstract ImmutableSet<EntryOption> getOptions();

        public static Builder builder() {
            return new AutoValue_ZipBuilder_Entry.Builder();
        }

        public boolean hasOption(EntryOption option) {
            return this.getOptions().contains((Object)option);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            public abstract Builder setContent(ByteSource var1);

            public abstract Builder setIsDirectory(boolean var1);

            public abstract Builder setOptions(ImmutableSet<EntryOption> var1);

            public abstract Entry autoBuild();

            public Entry build() {
                Entry result = this.autoBuild();
                Preconditions.checkState((boolean)(result.getContent().isPresent() ^ result.getIsDirectory()), (Object)"Content must be absent iff the entry is a directory.");
                return result;
            }
        }
    }
}

