/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

final class XmlPackageIdRemapper {
    private final int newPackageId;

    XmlPackageIdRemapper(int newPackageId) {
        this.newPackageId = newPackageId;
    }

    BundleModule remap(BundleModule module) {
        if (!module.getResourceTable().isPresent()) {
            return module;
        }
        ImmutableSet<ZipPath> xmlResourcePaths = ResourcesUtils.getAllProtoXmlFileReferences(module.getResourceTable().get());
        Map partitionedEntries = module.getEntries().stream().collect(Collectors.partitioningBy(entry -> xmlResourcePaths.contains((Object)entry.getPath()), ImmutableSet.toImmutableSet()));
        ImmutableList newEntries = ImmutableList.builder().addAll((Iterable)((ImmutableSet)partitionedEntries.get(true)).stream().map(this::remapInModuleEntry).collect(ImmutableSet.toImmutableSet())).addAll((Iterable)partitionedEntries.get(false)).build();
        Resources.XmlNode newAndroidManifest = this.remapInXmlNode(module.getAndroidManifestProto());
        return module.toBuilder().setAndroidManifestProto(newAndroidManifest).setRawEntries((Collection<ModuleEntry>)newEntries).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ModuleEntry remapInModuleEntry(ModuleEntry moduleEntry) {
        try (InputStream inputStream = moduleEntry.getContent().openStream();){
            Resources.XmlNode remappedXmlNode = this.remapInXmlNode(Resources.XmlNode.parseFrom((InputStream)inputStream));
            ModuleEntry moduleEntry2 = moduleEntry.toBuilder().setContent(ByteSource.wrap((byte[])remappedXmlNode.toByteArray())).build();
            return moduleEntry2;
        }
        catch (InvalidProtocolBufferException e11) {
            throw CommandExecutionException.builder().withInternalMessage("Error parsing XML file '%s'.", moduleEntry.getPath()).withCause(e11).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("An error occurred when parsing an XML file.", e12);
        }
    }

    private Resources.XmlNode remapInXmlNode(Resources.XmlNode xmlNode) {
        Resources.XmlNode.Builder remappedXmlNodeBuilder = xmlNode.toBuilder();
        this.remapInXmlNode(remappedXmlNodeBuilder);
        return remappedXmlNodeBuilder.build();
    }

    private void remapInXmlNode(Resources.XmlNode.Builder xmlNode) {
        if (xmlNode.hasElement()) {
            this.remapInElement(xmlNode.getElementBuilder());
        }
    }

    private void remapInElement(Resources.XmlElement.Builder xmlElement) {
        xmlElement.getAttributeBuilderList().forEach(this::remapInAttribute);
        xmlElement.getChildBuilderList().forEach(this::remapInXmlNode);
    }

    private void remapInAttribute(Resources.XmlAttribute.Builder xmlAttribute) {
        if (xmlAttribute.getResourceId() > 0) {
            xmlAttribute.setResourceId(ResourcesUtils.remapPackageIdInResourceId(xmlAttribute.getResourceId(), this.newPackageId));
        }
        if (xmlAttribute.hasCompiledItem()) {
            this.remapInCompiledItem(xmlAttribute.getCompiledItemBuilder());
        }
    }

    private void remapInCompiledItem(Resources.Item.Builder compiledItem) {
        if (compiledItem.getRef().getId() > 0) {
            compiledItem.getRefBuilder().setId(ResourcesUtils.remapPackageIdInResourceId(compiledItem.getRef().getId(), this.newPackageId));
        }
    }
}

