/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.preprocessors;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.preprocessors.AppBundlePreprocessor;
import com.android.tools.build.bundletool.shards.BundleModule64BitNativeLibrariesRemover;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;

public class AppBundle64BitNativeLibrariesPreprocessor
implements AppBundlePreprocessor {
    private final BundleModule64BitNativeLibrariesRemover bundleModule64BitNativeLibrariesRemover;
    private final Optional<PrintStream> logPrintStream;

    @Inject
    AppBundle64BitNativeLibrariesPreprocessor(BundleModule64BitNativeLibrariesRemover bundleModule64BitNativeLibrariesRemover, Optional<PrintStream> logPrintStream) {
        this.bundleModule64BitNativeLibrariesRemover = bundleModule64BitNativeLibrariesRemover;
        this.logPrintStream = logPrintStream;
    }

    @Override
    public AppBundle preprocess(AppBundle originalBundle) {
        boolean filter64BitLibraries = AppBundle64BitNativeLibrariesPreprocessor.has32BitRenderscriptCode(originalBundle);
        if (!filter64BitLibraries) {
            return originalBundle;
        }
        this.printWarning("App Bundle contains 32-bit RenderScript bitcode file (.bc) which disables 64-bit support in Android. 64-bit native libraries won't be included in generated APKs.");
        return originalBundle.toBuilder().setRawModules((Collection<BundleModule>)this.processModules((ImmutableCollection<BundleModule>)originalBundle.getModules().values())).build();
    }

    public ImmutableCollection<BundleModule> processModules(ImmutableCollection<BundleModule> modules) {
        return (ImmutableCollection)modules.stream().map(this.bundleModule64BitNativeLibrariesRemover::strip64BitLibraries).collect(ImmutableList.toImmutableList());
    }

    private static boolean has32BitRenderscriptCode(AppBundle bundle) {
        return bundle.getFeatureModules().values().stream().anyMatch(BundleModule::hasRenderscript32Bitcode);
    }

    private void printWarning(String message2) {
        this.logPrintStream.ifPresent(out -> out.println("WARNING: " + message2));
    }
}

