/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import shadow.bundletool.com.android.apksig.ApkSigner;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;

class ApkSigner {
    private static final String SIGNER_CONFIG_NAME = "BNDLTOOL";

    @Inject
    ApkSigner() {
    }

    void signEmbeddedApk(ModuleEntry apkEntry, SigningConfiguration signingConfig, Path outputApkPath, boolean signWithV3) {
        ZipPath targetPath = apkEntry.getPath();
        try (TempDirectory unsignedDir = new TempDirectory();){
            Path unsignedApk = unsignedDir.getPath().resolve("unsigned.apk");
            try (InputStream entryContent = apkEntry.getContent().openStream();){
                Files.copy(entryContent, unsignedApk, new CopyOption[0]);
            }
            ApkSigner.Builder apkSigner = new ApkSigner.Builder((List<ApkSigner.SignerConfig>)ApkSigner.extractSignerConfigs(signingConfig, signWithV3)).setInputApk(unsignedApk.toFile()).setOutputApk(outputApkPath.toFile()).setV3SigningEnabled(signWithV3);
            apkSigner.build().sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | ApkFormatException e4) {
            throw CommandExecutionException.builder().withCause(e4).withInternalMessage("Unable to sign the embedded APK '%s'.", targetPath).build();
        }
        catch (IOException e5) {
            throw new UncheckedIOException(String.format("Unable to sign the embedded APK '%s'.", targetPath), e5);
        }
    }

    void signApk(Path inputApkPath, Path outputApkPath, SigningConfiguration signingConfiguration, Optional<SigningConfiguration> stampSigningConfiguration, boolean signWithV1, boolean signWithV3, int minSdkVersion) {
        try {
            ApkSigner.Builder apkSigner = new ApkSigner.Builder((List<ApkSigner.SignerConfig>)ApkSigner.extractSignerConfigs(signingConfiguration, signWithV3)).setInputApk(inputApkPath.toFile()).setV1SigningEnabled(signWithV1).setV2SigningEnabled(true).setV3SigningEnabled(signWithV3).setOtherSignersSignaturesPreserved(false).setMinSdkVersion(minSdkVersion).setOutputApk(outputApkPath.toFile());
            apkSigner.build().sign();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | ApkFormatException e4) {
            throw CommandExecutionException.builder().withCause(e4).withInternalMessage("Unable to sign APK.").build();
        }
    }

    private static ImmutableList<ApkSigner.SignerConfig> extractSignerConfigs(SigningConfiguration signingConfiguration, boolean signWithV3) {
        if (!signWithV3) {
            return ImmutableList.of((Object)ApkSigner.convertToApksigSignerConfig(signingConfiguration.getSignerConfigForV1AndV2()));
        }
        ImmutableList.Builder signerConfigs = ImmutableList.builder();
        signerConfigs.add((Object)ApkSigner.convertToApksigSignerConfig(signingConfiguration.getSignerConfig()));
        return signerConfigs.build();
    }

    private static ApkSigner.SignerConfig convertToApksigSignerConfig(SignerConfig signerConfig) {
        return new ApkSigner.SignerConfig.Builder(SIGNER_CONFIG_NAME, signerConfig.getPrivateKey(), (List<X509Certificate>)signerConfig.getCertificates()).build();
    }
}

