/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.ClassNamingForMapApplier;
import shadow.bundletool.com.android.tools.r8.naming.ProguardMap;
import shadow.bundletool.com.android.tools.r8.naming.ProguardMapReader;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class SeedMapper
implements ProguardMap {
    private final ImmutableMap<String, ClassNamingForMapApplier> mappings;

    static Builder builder() {
        return new Builder();
    }

    private static SeedMapper seedMapperFromInputStream(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        try (ProguardMapReader proguardReader = new ProguardMapReader(reader);){
            Builder builder = SeedMapper.builder();
            proguardReader.parse(builder);
            SeedMapper seedMapper = builder.build();
            return seedMapper;
        }
    }

    public static SeedMapper seedMapperFromFile(Path path) throws IOException {
        return SeedMapper.seedMapperFromInputStream(Files.newInputStream(path, new OpenOption[0]));
    }

    private SeedMapper(Map<String, ClassNamingForMapApplier.Builder> mappings) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, ClassNamingForMapApplier.Builder> entry : mappings.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().build());
        }
        this.mappings = builder.build();
    }

    @Override
    public boolean hasMapping(DexType type) {
        return this.mappings.containsKey((Object)type.descriptor.toString());
    }

    @Override
    public ClassNamingForMapApplier getClassNaming(DexType type) {
        return (ClassNamingForMapApplier)this.mappings.get((Object)type.descriptor.toString());
    }

    static class Builder
    extends ProguardMap.Builder {
        final ImmutableMap.Builder<String, ClassNamingForMapApplier.Builder> mapBuilder = ImmutableMap.builder();

        private Builder() {
        }

        @Override
        ClassNamingForMapApplier.Builder classNamingBuilder(String renamedName, String originalName) {
            String originalDescriptor = DescriptorUtils.javaTypeToDescriptor(originalName);
            ClassNamingForMapApplier.Builder classNamingBuilder = ClassNamingForMapApplier.builder(DescriptorUtils.javaTypeToDescriptor(renamedName), originalDescriptor);
            this.mapBuilder.put((Object)originalDescriptor, (Object)classNamingBuilder);
            return classNamingBuilder;
        }

        @Override
        SeedMapper build() {
            return new SeedMapper((Map)this.mapBuilder.build());
        }
    }
}

