/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import com.google.common.collect.ImmutableMap;
import java.util.TreeSet;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class DexDebugEntry {
    public final int address;
    public final int line;
    public final DexString sourceFile;
    public final boolean prologueEnd;
    public final boolean epilogueBegin;
    public final ImmutableMap<Integer, DebugLocalInfo> locals;
    public final DexMethod method;
    public final Position callerPosition;

    public DexDebugEntry(int address, int line, DexString sourceFile, boolean prologueEnd, boolean epilogueBegin, ImmutableMap<Integer, DebugLocalInfo> locals, DexMethod method, Position callerPosition) {
        this.address = address;
        this.line = line;
        this.sourceFile = sourceFile;
        this.prologueEnd = prologueEnd;
        this.epilogueBegin = epilogueBegin;
        this.locals = locals;
        this.method = method;
        assert (method != null);
        this.callerPosition = callerPosition;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withPcPrefix) {
        StringBuilder builder = new StringBuilder();
        if (withPcPrefix) {
            builder.append("pc ");
        }
        builder.append(StringUtils.hexString(this.address, 2));
        builder.append(", line ").append(this.line);
        if (this.sourceFile != null) {
            builder.append(", file ").append(this.sourceFile);
        }
        if (this.callerPosition != null) {
            builder.append(", method ").append(this.method);
            builder.append(" <-(").append(this.callerPosition).append(")");
        }
        if (this.prologueEnd) {
            builder.append(", prologue_end = true");
        }
        if (this.epilogueBegin) {
            builder.append(", epilogue_begin = true");
        }
        if (!this.locals.isEmpty()) {
            builder.append(", locals: [");
            TreeSet keys = new TreeSet(this.locals.keySet());
            boolean first = true;
            for (Integer register : keys) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(register).append(" -> ").append(this.locals.get((Object)register));
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

