/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.graph.CachedHashValueDexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexType;

public class DexAnnotationSet
extends CachedHashValueDexItem {
    private static final int UNSORTED = 0;
    private static final DexAnnotationSet THE_EMPTY_ANNOTATIONS_SET = new DexAnnotationSet(new DexAnnotation[0]);
    public final DexAnnotation[] annotations;
    private int sorted = 0;

    public DexAnnotationSet(DexAnnotation[] annotations) {
        this.annotations = annotations;
    }

    public static DexAnnotationSet empty() {
        return THE_EMPTY_ANNOTATIONS_SET;
    }

    @Override
    public int computeHashCode() {
        return Arrays.hashCode(this.annotations);
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexAnnotationSet) {
            DexAnnotationSet o = (DexAnnotationSet)other;
            return Arrays.equals(this.annotations, o.annotations);
        }
        return false;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        DexAnnotationSet.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.annotations);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        mixedItems.add(this);
        DexAnnotationSet.collectAll((MixedSectionCollection)mixedItems, (DexItem[])this.annotations);
    }

    public boolean isEmpty() {
        return this.annotations.length == 0;
    }

    public void sort() {
        if (this.sorted != 0) {
            assert (this.sorted == this.sortedHashCode());
            return;
        }
        Arrays.sort(this.annotations, (a, b) -> a.annotation.type.compareTo(b.annotation.type));
        for (DexAnnotation annotation : this.annotations) {
            annotation.annotation.sort();
        }
        this.sorted = this.hashCode();
    }

    public DexAnnotation getFirstMatching(DexType type) {
        for (DexAnnotation annotation : this.annotations) {
            if (annotation.annotation.type != type) continue;
            return annotation;
        }
        return null;
    }

    public DexAnnotationSet getWithout(DexType annotationType) {
        int index = 0;
        for (DexAnnotation annotation : this.annotations) {
            if (annotation.annotation.type == annotationType) {
                DexAnnotation[] reducedArray = new DexAnnotation[this.annotations.length - 1];
                System.arraycopy(this.annotations, 0, reducedArray, 0, index);
                if (index < reducedArray.length) {
                    System.arraycopy(this.annotations, index + 1, reducedArray, index, reducedArray.length - index);
                }
                return new DexAnnotationSet(reducedArray);
            }
            ++index;
        }
        return this;
    }

    private int sortedHashCode() {
        int hashCode = this.hashCode();
        return hashCode == 0 ? 1 : hashCode;
    }

    public DexAnnotationSet getWithAddedOrReplaced(DexAnnotation newAnnotation) {
        int index = 0;
        for (DexAnnotation annotation : this.annotations) {
            if (annotation.annotation.type == newAnnotation.annotation.type) {
                DexAnnotation[] modifiedArray = (DexAnnotation[])this.annotations.clone();
                modifiedArray[index] = newAnnotation;
                return new DexAnnotationSet(modifiedArray);
            }
            ++index;
        }
        DexAnnotation[] extendedArray = new DexAnnotation[this.annotations.length + 1];
        System.arraycopy(this.annotations, 0, extendedArray, 0, this.annotations.length);
        extendedArray[this.annotations.length] = newAnnotation;
        return new DexAnnotationSet(extendedArray);
    }
}

