/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexType;

public class CfConstClass
extends CfInstruction {
    private final DexType type;

    public CfConstClass(DexType type) {
        this.type = type;
    }

    public DexType getType() {
        return this.type;
    }

    @Override
    public void write(MethodVisitor visitor) {
        visitor.visitLdcInsn((Object)Type.getObjectType((String)this.getInternalName()));
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    private String getInternalName() {
        switch (this.type.toShorty()) {
            case 'L': 
            case '[': {
                return this.type.getInternalName();
            }
            case 'Z': {
                return "java/lang/Boolean/TYPE";
            }
            case 'B': {
                return "java/lang/Byte/TYPE";
            }
            case 'S': {
                return "java/lang/Short/TYPE";
            }
            case 'C': {
                return "java/lang/Character/TYPE";
            }
            case 'I': {
                return "java/lang/Integer/TYPE";
            }
            case 'F': {
                return "java/lang/Float/TYPE";
            }
            case 'J': {
                return "java/lang/Long/TYPE";
            }
            case 'D': {
                return "java/lang/Double/TYPE";
            }
        }
        throw new Unreachable("Unexpected type in const-class: " + this.type);
    }
}

