/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.exceptions.manifest.ManifestFusingException;
import com.android.tools.build.bundletool.exceptions.manifest.ManifestSdkTargetingException;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.version.BundleToolVersion;
import com.android.tools.build.bundletool.version.Version;
import java.util.Optional;

public class AndroidManifestValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        this.validateInstant(module);
        this.validateOnDemand(module);
        this.validateFusingConfig(module);
        this.validateMinMaxSdk(module);
        this.validateOnDemandIsInstantMutualExclusion(module);
    }

    private void validateInstant(BundleModule module) {
        Optional<Integer> maxSdk;
        AndroidManifest manifest = module.getAndroidManifest();
        Optional<Boolean> isInstantModule = manifest.isInstantModule();
        if (isInstantModule.orElse(false).booleanValue() && (maxSdk = manifest.getMaxSdkVersion()).isPresent() && maxSdk.get() < 21) {
            throw new ManifestSdkTargetingException.MaxSdkLessThanMinInstantSdk(maxSdk.get());
        }
    }

    private void validateOnDemand(BundleModule module) {
        boolean hasConditions;
        Version bundleToolVersion = BundleToolVersion.getVersionFromBundleConfig(module.getBundleConfig());
        Optional<Boolean> isOnDemandModule = module.getAndroidManifest().isOnDemandModule(bundleToolVersion);
        boolean bl = hasConditions = !module.getAndroidManifest().getModuleConditions().isEmpty();
        if (module.isBaseModule()) {
            if (isOnDemandModule.isPresent() && isOnDemandModule.get().booleanValue()) {
                throw new ValidationException("The base module cannot be marked as onDemand='true' since it will always be served.");
            }
            if (hasConditions) {
                throw new ValidationException("The base module cannot have conditions since it will always be served.");
            }
        } else if (hasConditions) {
            if (isOnDemandModule.isPresent()) {
                throw ValidationException.builder().withMessage("The element <dist:module> in the AndroidManifest.xml must not have the attribute 'onDemand' set if the module is conditional (module: '%s').", module.getName()).build();
            }
        } else if (!isOnDemandModule.isPresent()) {
            throw ValidationException.builder().withMessage("The element <dist:module> in the AndroidManifest.xml must have the attribute 'onDemand' explicitly set (module: '%s').", module.getName()).build();
        }
    }

    private void validateOnDemandIsInstantMutualExclusion(BundleModule module) {
        boolean hasConditions;
        boolean isInstant = module.getAndroidManifest().isInstantModule().orElse(false);
        boolean bl = hasConditions = !module.getAndroidManifest().getModuleConditions().isEmpty();
        if (module.isOnDemandModule() && isInstant) {
            throw ValidationException.builder().withMessage("The attribute 'onDemand' and 'instant' cannot both be true at the same time (module '%s').", module.getName()).build();
        }
        if (hasConditions && isInstant) {
            throw ValidationException.builder().withMessage("The attribute 'instant' cannot be true for conditional module (module '%s').", module.getName()).build();
        }
    }

    private void validateFusingConfig(BundleModule module) {
        Optional<Boolean> isInstant = module.getAndroidManifest().isInstantModule();
        if (isInstant.isPresent() && isInstant.get().booleanValue()) {
            return;
        }
        Optional<Boolean> includedInFusingByManifest = module.getAndroidManifest().getIsModuleIncludedInFusing(BundleToolVersion.getVersionFromBundleConfig(module.getBundleConfig()));
        if (module.isBaseModule()) {
            if (includedInFusingByManifest.isPresent() && !includedInFusingByManifest.get().booleanValue()) {
                throw new ManifestFusingException.BaseModuleExcludedFromFusingException();
            }
        } else if (!includedInFusingByManifest.isPresent()) {
            throw new ManifestFusingException.ModuleFusingConfigurationMissingException(module.getName().getName());
        }
    }

    private void validateMinMaxSdk(BundleModule module) {
        AndroidManifest manifest = module.getAndroidManifest();
        Optional<Integer> maxSdk = manifest.getMaxSdkVersion();
        Optional<Integer> minSdk = manifest.getMinSdkVersion();
        maxSdk.filter(sdk -> sdk < 0).ifPresent(sdk -> {
            throw new ManifestSdkTargetingException.MaxSdkInvalidException((int)sdk);
        });
        minSdk.filter(sdk -> sdk < 0).ifPresent(sdk -> {
            throw new ManifestSdkTargetingException.MinSdkInvalidException((int)sdk);
        });
        if (maxSdk.isPresent() && minSdk.isPresent() && maxSdk.get() < minSdk.get()) {
            throw new ManifestSdkTargetingException.MinSdkGreaterThanMaxSdkException(minSdk.get(), maxSdk.get());
        }
    }
}

