/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.targeting;

import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;

public final class ScreenDensitySelector {
    public ImmutableList<Resources.ConfigValue> selectAllMatchingConfigValues(ImmutableList<Resources.ConfigValue> values, Targeting.ScreenDensity.DensityAlias forDensityAlias, Set<Targeting.ScreenDensity.DensityAlias> alternatives) {
        Integer targetDpi = (Integer)ResourcesUtils.DENSITY_ALIAS_TO_DPI_MAP.get((Object)forDensityAlias);
        ImmutableSet alternativeDpis = (ImmutableSet)alternatives.stream().map(arg_0 -> ResourcesUtils.DENSITY_ALIAS_TO_DPI_MAP.get(arg_0)).collect(ImmutableSet.toImmutableSet());
        return this.getReachableConfigValues(this.getDpiRange(targetDpi, (ImmutableSet<Integer>)alternativeDpis), values);
    }

    @CheckReturnValue
    private ImmutableList<Resources.ConfigValue> getReachableConfigValues(Range<Integer> deviceDpiRange, ImmutableList<Resources.ConfigValue> values) {
        Optional<Object> lowestResourceDpi = Optional.empty();
        Optional<Object> highestResourceDpi = Optional.empty();
        if (deviceDpiRange.hasLowerBound()) {
            lowestResourceDpi = Optional.of(this.selectBestConfigValue((Iterable<Resources.ConfigValue>)values, (Integer)deviceDpiRange.lowerEndpoint()).getConfig().getDensity());
        }
        if (deviceDpiRange.hasUpperBound()) {
            highestResourceDpi = Optional.of(this.selectBestConfigValue((Iterable<Resources.ConfigValue>)values, (Integer)deviceDpiRange.upperEndpoint()).getConfig().getDensity());
        }
        Range effectiveDpiRange = deviceDpiRange.equals((Object)Range.all()) ? Range.all() : (!lowestResourceDpi.isPresent() ? Range.atMost((Comparable)((Comparable)highestResourceDpi.get())) : (!highestResourceDpi.isPresent() ? Range.atLeast((Comparable)((Comparable)lowestResourceDpi.get())) : Range.closed((Comparable)((Comparable)lowestResourceDpi.get()), (Comparable)((Comparable)highestResourceDpi.get()))));
        return (ImmutableList)values.stream().filter(configValue -> effectiveDpiRange.contains((Comparable)Integer.valueOf(configValue.getConfig().getDensity()))).collect(ImmutableList.toImmutableList());
    }

    private Range<Integer> getDpiRange(int targetDpi, ImmutableSet<Integer> alternatives) {
        if (alternatives.isEmpty()) {
            return Range.all();
        }
        Optional<Integer> lowMidPoint = ScreenDensitySelector.getNearestLowerDpi(targetDpi, alternatives).map(lowerDpi -> ScreenDensitySelector.getMidPoint(lowerDpi, targetDpi)).map(val -> (int)Math.ceil(val));
        Optional<Integer> highMidPoint = ScreenDensitySelector.getNearestHigherDpi(targetDpi, alternatives).map(higherDpi -> ScreenDensitySelector.getMidPoint(targetDpi, higherDpi)).map(val -> (int)Math.floor(val));
        if (!lowMidPoint.isPresent()) {
            return Range.atMost((Comparable)highMidPoint.get());
        }
        if (!highMidPoint.isPresent()) {
            return Range.atLeast((Comparable)lowMidPoint.get());
        }
        return Range.closed((Comparable)lowMidPoint.get(), (Comparable)highMidPoint.get());
    }

    private static double getMidPoint(int lowerDpi, int higherDpi) {
        Preconditions.checkArgument((lowerDpi < higherDpi ? 1 : 0) != 0);
        return ((double)(-higherDpi) + Math.sqrt(higherDpi * higherDpi + 8 * lowerDpi * higherDpi)) / 2.0;
    }

    private static Optional<Integer> getNearestHigherDpi(int targetDpi, ImmutableSet<Integer> alternatives) {
        return alternatives.stream().filter(alt -> alt > targetDpi).min(Comparator.naturalOrder());
    }

    private static Optional<Integer> getNearestLowerDpi(int targetDpi, ImmutableSet<Integer> alternatives) {
        return alternatives.stream().filter(alt -> alt < targetDpi).max(Comparator.naturalOrder());
    }

    public Resources.ConfigValue selectBestConfigValue(Iterable<Resources.ConfigValue> values, Targeting.ScreenDensity.DensityAlias desiredDensityAlias) {
        Preconditions.checkArgument((boolean)ResourcesUtils.DENSITY_ALIAS_TO_DPI_MAP.containsKey((Object)desiredDensityAlias));
        return this.selectBestConfigValue(values, (Integer)ResourcesUtils.DENSITY_ALIAS_TO_DPI_MAP.get((Object)desiredDensityAlias));
    }

    public Resources.ConfigValue selectBestConfigValue(Iterable<Resources.ConfigValue> values, int desiredDpi) {
        return (Resources.ConfigValue)Ordering.from(ScreenDensitySelector.comparatorForConfigValues(desiredDpi)).max(values);
    }

    public int selectBestDensity(Iterable<Integer> densities, int desiredDpi) {
        return (Integer)Ordering.from((Comparator)new ScreenDensityComparator(desiredDpi)).max(densities);
    }

    private static Comparator<Resources.ConfigValue> comparatorForConfigValues(int desiredDpi) {
        return Comparator.comparing(ScreenDensitySelector::getDpiValue, new ScreenDensityComparator(desiredDpi));
    }

    private static int getDpiValue(Resources.ConfigValue configValue) {
        if (configValue.getConfig().getDensity() == 0) {
            return 160;
        }
        return configValue.getConfig().getDensity();
    }

    private static class ScreenDensityComparator
    implements Comparator<Integer> {
        private final int desiredDpi;

        public ScreenDensityComparator(int desiredDpi) {
            Preconditions.checkArgument((desiredDpi != 65535 ? 1 : 0) != 0);
            this.desiredDpi = desiredDpi == 0 || desiredDpi == 65534 ? 160 : desiredDpi;
        }

        @Override
        public int compare(Integer dpiA, Integer dpiB) {
            Preconditions.checkNotNull((Object)dpiA);
            Preconditions.checkNotNull((Object)dpiB);
            if (dpiA.equals(dpiB)) {
                return 0;
            }
            if (dpiA.equals(65534)) {
                return 1;
            }
            if (dpiB.equals(65534)) {
                return -1;
            }
            if (dpiA > dpiB) {
                return -1 * this.compareOrdered(dpiB, dpiA);
            }
            return this.compareOrdered(dpiA, dpiB);
        }

        private int compareOrdered(int lowerDpi, int higherDpi) {
            if (this.desiredDpi >= higherDpi) {
                return -1;
            }
            if (this.desiredDpi <= lowerDpi) {
                return 1;
            }
            if ((2 * lowerDpi - this.desiredDpi) * higherDpi > this.desiredDpi * this.desiredDpi) {
                return 1;
            }
            return -1;
        }
    }
}

