/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ManifestMutator;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.utils.TargetingProtoUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;

public class NativeLibrariesCompressionSplitter
implements ModuleSplitSplitter {
    @Override
    public ImmutableCollection<ModuleSplit> split(ModuleSplit moduleSplit) {
        Preconditions.checkState((!moduleSplit.getApkTargeting().hasSdkVersionTargeting() ? 1 : 0) != 0, (Object)"Split already targets SDK version.");
        if (!moduleSplit.getNativeConfig().isPresent()) {
            return ImmutableList.of((Object)moduleSplit);
        }
        ImmutableList.Builder splits = new ImmutableList.Builder();
        List<Files.TargetedNativeDirectory> allTargetedDirectories = moduleSplit.getNativeConfig().get().getDirectoryList();
        ImmutableSet libraryEntries = (ImmutableSet)allTargetedDirectories.stream().flatMap(directory -> moduleSplit.findEntriesUnderPath(directory.getPath())).collect(ImmutableSet.toImmutableSet());
        splits.add((Object)this.createModuleSplit(moduleSplit, TargetingProtoUtils.sdkVersionTargeting(TargetingProtoUtils.sdkVersionFrom(23), (ImmutableSet<Targeting.SdkVersion>)(NativeLibrariesCompressionSplitter.targetsPreM(moduleSplit) ? ImmutableSet.of((Object)TargetingProtoUtils.sdkVersionFrom(21)) : ImmutableSet.of())), this.mergeAndSetCompression((ImmutableSet<ModuleEntry>)libraryEntries, moduleSplit, false), false));
        if (NativeLibrariesCompressionSplitter.targetsPreM(moduleSplit)) {
            splits.add((Object)this.createModuleSplit(moduleSplit, TargetingProtoUtils.sdkVersionTargeting(TargetingProtoUtils.sdkVersionFrom(21), (ImmutableSet<Targeting.SdkVersion>)ImmutableSet.of((Object)TargetingProtoUtils.sdkVersionFrom(23))), this.mergeAndSetCompression((ImmutableSet<ModuleEntry>)libraryEntries, moduleSplit, true), true));
        }
        return splits.build();
    }

    private static boolean targetsPreM(ModuleSplit moduleSplit) {
        int baseMinSdkVersion = moduleSplit.getAndroidManifest().getEffectiveMinSdkVersion();
        return baseMinSdkVersion < 23;
    }

    private ImmutableList<ModuleEntry> mergeAndSetCompression(ImmutableSet<ModuleEntry> libraryEntries, ModuleSplit moduleSplit, boolean shouldCompress) {
        ImmutableSet nonLibraryEntries = (ImmutableSet)moduleSplit.getEntries().stream().filter(entry -> !libraryEntries.contains(entry)).collect(ImmutableSet.toImmutableSet());
        return ImmutableList.builder().addAll((Iterable)libraryEntries.stream().map(moduleEntry -> moduleEntry.setCompression(shouldCompress)).collect(ImmutableList.toImmutableList())).addAll((Iterable)nonLibraryEntries).build();
    }

    private ModuleSplit createModuleSplit(ModuleSplit moduleSplit, Targeting.SdkVersionTargeting variantSdkVersionTargeting, ImmutableList<ModuleEntry> moduleEntries, boolean extractNativeLibs) {
        return moduleSplit.toBuilder().setMasterManifestMutators((ImmutableList<ManifestMutator>)ImmutableList.of((Object)ManifestMutator.withExtractNativeLibs(extractNativeLibs))).setVariantTargeting(moduleSplit.getVariantTargeting().toBuilder().setSdkVersionTargeting(variantSdkVersionTargeting).build()).setEntries((List<ModuleEntry>)moduleEntries).build();
    }
}

