/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.utils.TargetingProtoUtils;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;

public class DexCompressionSplitter
implements ModuleSplitSplitter {
    @Override
    public ImmutableCollection<ModuleSplit> split(ModuleSplit moduleSplit) {
        ImmutableSet dexEntries = (ImmutableSet)moduleSplit.getEntries().stream().filter(entry -> entry.getPath().startsWith(BundleModule.DEX_DIRECTORY)).collect(ImmutableSet.toImmutableSet());
        if (dexEntries.isEmpty()) {
            return ImmutableList.of((Object)moduleSplit);
        }
        ImmutableList.Builder splits = new ImmutableList.Builder();
        splits.add((Object)DexCompressionSplitter.createModuleSplit(moduleSplit, TargetingProtoUtils.sdkVersionTargeting(TargetingProtoUtils.sdkVersionFrom(28), (ImmutableSet<Targeting.SdkVersion>)(DexCompressionSplitter.targetsPreP(moduleSplit) ? ImmutableSet.of((Object)TargetingProtoUtils.sdkVersionFrom(21)) : ImmutableSet.of())), DexCompressionSplitter.mergeAndSetCompression((ImmutableSet<ModuleEntry>)dexEntries, moduleSplit, false)));
        if (DexCompressionSplitter.targetsPreP(moduleSplit)) {
            splits.add((Object)DexCompressionSplitter.createModuleSplit(moduleSplit, TargetingProtoUtils.sdkVersionTargeting(TargetingProtoUtils.sdkVersionFrom(21), (ImmutableSet<Targeting.SdkVersion>)ImmutableSet.of((Object)TargetingProtoUtils.sdkVersionFrom(28))), DexCompressionSplitter.mergeAndSetCompression((ImmutableSet<ModuleEntry>)dexEntries, moduleSplit, true)));
        }
        return splits.build();
    }

    private static ImmutableList<ModuleEntry> mergeAndSetCompression(ImmutableSet<ModuleEntry> dexEntries, ModuleSplit moduleSplit, boolean shouldCompress) {
        ImmutableSet nonDexEntries = (ImmutableSet)moduleSplit.getEntries().stream().filter(entry -> !dexEntries.contains(entry)).collect(ImmutableSet.toImmutableSet());
        return ImmutableList.builder().addAll((Iterable)dexEntries.stream().map(moduleEntry -> moduleEntry.setCompression(shouldCompress)).collect(ImmutableList.toImmutableList())).addAll((Iterable)nonDexEntries).build();
    }

    private static boolean targetsPreP(ModuleSplit moduleSplit) {
        int minSdkVersion = moduleSplit.getAndroidManifest().getEffectiveMinSdkVersion();
        return minSdkVersion < 28;
    }

    private static ModuleSplit createModuleSplit(ModuleSplit moduleSplit, Targeting.SdkVersionTargeting variantSdkVersionTargeting, ImmutableList<ModuleEntry> moduleEntries) {
        return moduleSplit.toBuilder().setVariantTargeting(moduleSplit.getVariantTargeting().toBuilder().setSdkVersionTargeting(variantSdkVersionTargeting).build()).setEntries((List<ModuleEntry>)moduleEntries).build();
    }
}

