/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ManifestMutator;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.targeting.ScreenDensitySelector;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.android.tools.build.bundletool.splitters.SplitterForOneTargetingDimension;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScreenDensityResourcesSplitter
extends SplitterForOneTargetingDimension {
    static final ImmutableSet<Targeting.ScreenDensity.DensityAlias> DEFAULT_DENSITY_BUCKETS = ImmutableSet.of((Object)((Object)Targeting.ScreenDensity.DensityAlias.LDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.MDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.HDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XHDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XXHDPI), (Object)((Object)Targeting.ScreenDensity.DensityAlias.XXXHDPI), (Object[])new Targeting.ScreenDensity.DensityAlias[]{Targeting.ScreenDensity.DensityAlias.TVDPI});
    private static final String STYLE_TYPE_NAME = "style";
    private final ImmutableSet<Targeting.ScreenDensity.DensityAlias> densityBuckets;
    private final Version bundleVersion;
    private final Predicate<ResourceId> pinWholeResourceToMaster;
    private final Predicate<ResourceId> pinLowestBucketOfResourceToMaster;
    private final boolean pinLowestBucketOfStylesToMaster;

    public ScreenDensityResourcesSplitter(Version bundleVersion, Predicate<ResourceId> pinWholeResourceToMaster, Predicate<ResourceId> pinLowestBucketOfResourceToMaster, boolean pinLowestBucketOfStylesToMaster) {
        this(DEFAULT_DENSITY_BUCKETS, bundleVersion, pinWholeResourceToMaster, pinLowestBucketOfResourceToMaster, pinLowestBucketOfStylesToMaster);
    }

    public ScreenDensityResourcesSplitter(ImmutableSet<Targeting.ScreenDensity.DensityAlias> densityBuckets, Version bundleVersion, Predicate<ResourceId> pinWholeResourceToMaster, Predicate<ResourceId> pinLowestBucketOfResourceToMaster, boolean pinLowestBucketOfStylesToMaster) {
        this.densityBuckets = densityBuckets;
        this.bundleVersion = bundleVersion;
        this.pinWholeResourceToMaster = pinWholeResourceToMaster;
        this.pinLowestBucketOfResourceToMaster = pinLowestBucketOfResourceToMaster;
        this.pinLowestBucketOfStylesToMaster = pinLowestBucketOfStylesToMaster;
    }

    @Override
    public ImmutableCollection<ModuleSplit> splitInternal(ModuleSplit split) {
        Optional<Resources.ResourceTable> resourceTable = split.getResourceTable();
        if (!resourceTable.isPresent() || resourceTable.get().equals((Object)Resources.ResourceTable.getDefaultInstance())) {
            return ImmutableList.of((Object)split);
        }
        ImmutableList.Builder splitsBuilder = new ImmutableList.Builder();
        for (Targeting.ScreenDensity.DensityAlias density : this.densityBuckets) {
            Resources.ResourceTable optimizedTable = this.filterResourceTableForDensity(resourceTable.get(), density);
            if (optimizedTable.equals((Object)Resources.ResourceTable.getDefaultInstance())) continue;
            ModuleSplit.Builder moduleSplitBuilder = split.toBuilder().setApkTargeting(split.getApkTargeting().toBuilder().setScreenDensityTargeting(Targeting.ScreenDensityTargeting.newBuilder().addValue(ScreenDensityResourcesSplitter.toScreenDensity(density)).addAllAlternatives((Iterable)ScreenDensityResourcesSplitter.allBut(this.densityBuckets, density).stream().map(ScreenDensityResourcesSplitter::toScreenDensity).collect(ImmutableList.toImmutableList()))).build()).setMasterSplit(false).addMasterManifestMutator(ManifestMutator.withSplitsRequired(true)).setEntries((List<ModuleEntry>)ModuleSplit.filterResourceEntries(split.getEntries(), optimizedTable)).setResourceTable(optimizedTable);
            splitsBuilder.add((Object)moduleSplitBuilder.build());
        }
        ModuleSplit defaultResourcesSplit = this.getDefaultResourcesSplit(split, (ImmutableCollection<ModuleSplit>)splitsBuilder.build());
        return splitsBuilder.add((Object)defaultResourcesSplit).build();
    }

    private static Targeting.ScreenDensity toScreenDensity(Targeting.ScreenDensity.DensityAlias alias) {
        return Targeting.ScreenDensity.newBuilder().setDensityAlias(alias).build();
    }

    private ModuleSplit getDefaultResourcesSplit(ModuleSplit inputSplit, ImmutableCollection<ModuleSplit> densitySplits) {
        Resources.ResourceTable defaultSplitTable = this.getResourceTableForDefaultSplit(inputSplit, this.getClaimedConfigs((Iterable<ModuleSplit>)densitySplits));
        return inputSplit.toBuilder().setEntries((List<ModuleEntry>)ModuleSplit.filterResourceEntries(inputSplit.getEntries(), defaultSplitTable)).setResourceTable(defaultSplitTable).build();
    }

    private ImmutableMultimap<ResourceId, Resources.ConfigValue> getClaimedConfigs(Iterable<ModuleSplit> moduleSplits) {
        ImmutableMultimap.Builder result = new ImmutableMultimap.Builder();
        for (ModuleSplit moduleSplit : moduleSplits) {
            Preconditions.checkState((boolean)moduleSplit.getResourceTable().isPresent(), (Object)"Resource table not found in the density split.");
            for (Resources.Package pkg : moduleSplit.getResourceTable().get().getPackageList()) {
                for (Resources.Type type : pkg.getTypeList()) {
                    for (Resources.Entry entry : type.getEntryList()) {
                        for (Resources.ConfigValue configValue : entry.getConfigValueList()) {
                            result.put((Object)ResourceId.create((Resources.PackageOrBuilder)pkg, (Resources.TypeOrBuilder)type, (Resources.EntryOrBuilder)entry), (Object)configValue);
                        }
                    }
                }
            }
        }
        return result.build();
    }

    private Resources.ResourceTable getResourceTableForDefaultSplit(ModuleSplit split, ImmutableMultimap<ResourceId, Resources.ConfigValue> claimedConfigs) {
        Preconditions.checkArgument((boolean)split.getResourceTable().isPresent(), (Object)"Expected the split to contain Resource Table.");
        Resources.ResourceTable.Builder prunedTable = split.getResourceTable().get().toBuilder();
        for (Resources.Package.Builder packageBuilder : prunedTable.getPackageBuilderList()) {
            for (Resources.Type.Builder typeBuilder : packageBuilder.getTypeBuilderList()) {
                ArrayList<Resources.Entry> newEntries = new ArrayList<Resources.Entry>();
                for (Resources.Entry entry : typeBuilder.getEntryList()) {
                    ResourceId resourceId = ResourceId.create((Resources.PackageOrBuilder)packageBuilder, (Resources.TypeOrBuilder)typeBuilder, (Resources.EntryOrBuilder)entry);
                    ImmutableList allConfigsExceptClaimed = (ImmutableList)entry.getConfigValueList().stream().filter(configValue -> !claimedConfigs.containsEntry((Object)resourceId, configValue)).collect(ImmutableList.toImmutableList());
                    Resources.Entry.Builder newEntry = entry.toBuilder().clearConfigValue().addAllConfigValue((Iterable)allConfigsExceptClaimed);
                    if (newEntry.getConfigValueCount() <= 0) continue;
                    newEntries.add(newEntry.build());
                }
                typeBuilder.clearEntry().addAllEntry(newEntries);
            }
        }
        return prunedTable.build();
    }

    private Resources.ResourceTable filterResourceTableForDensity(Resources.ResourceTable input, Targeting.ScreenDensity.DensityAlias density) {
        return ResourcesUtils.filterResourceTable(input, entry -> entry.getType().getName().equals("mipmap"), entry -> this.filterEntryForDensity((ResourceTableEntry)entry, density));
    }

    private Resources.Entry filterEntryForDensity(ResourceTableEntry tableEntry, Targeting.ScreenDensity.DensityAlias targetDensity) {
        Predicate<Resources.ConfigValue> pinConfigToMaster;
        Resources.Entry initialEntry = tableEntry.getEntry();
        Map configValuesByConfiguration = initialEntry.getConfigValueList().stream().filter(configValue -> VersionGuardedFeature.RESOURCES_WITH_NO_ALTERNATIVES_IN_MASTER_SPLIT.enabledForVersion(this.bundleVersion) || configValue.getConfig().getDensity() != 0).collect(Collectors.groupingBy(configValue -> ScreenDensityResourcesSplitter.clearDensity(configValue.getConfig())));
        if (VersionGuardedFeature.RESOURCES_WITH_NO_ALTERNATIVES_IN_MASTER_SPLIT.enabledForVersion(this.bundleVersion)) {
            configValuesByConfiguration = Maps.filterValues(configValuesByConfiguration, configValues -> configValues.size() > 1);
        }
        ImmutableList densityGroups = ImmutableList.copyOf(configValuesByConfiguration.values());
        if (this.pinWholeResourceToMaster.test(tableEntry.getResourceId())) {
            pinConfigToMaster = anyConfig -> true;
        } else if (this.pinLowestBucketToMaster(tableEntry)) {
            ImmutableSet lowDensityConfigsPinnedToMaster = (ImmutableSet)this.pickBestDensityForEachGroup((ImmutableList<List<Resources.ConfigValue>>)densityGroups, ResourcesUtils.getLowestDensity(this.densityBuckets)).collect(ImmutableSet.toImmutableSet());
            pinConfigToMaster = arg_0 -> ((ImmutableSet)lowDensityConfigsPinnedToMaster).contains(arg_0);
        } else {
            pinConfigToMaster = anyConfig -> false;
        }
        ImmutableList valuesToKeep = (ImmutableList)this.pickBestDensityForEachGroup((ImmutableList<List<Resources.ConfigValue>>)densityGroups, targetDensity).filter(config -> !pinConfigToMaster.test((Resources.ConfigValue)config)).collect(ImmutableList.toImmutableList());
        return initialEntry.toBuilder().clearConfigValue().addAllConfigValue((Iterable)valuesToKeep).build();
    }

    private boolean pinLowestBucketToMaster(ResourceTableEntry entry) {
        return this.pinLowestBucketOfResourceToMaster.test(entry.getResourceId()) || this.pinLowestBucketOfStylesToMaster && STYLE_TYPE_NAME.equals(entry.getType().getName());
    }

    private Stream<Resources.ConfigValue> pickBestDensityForEachGroup(ImmutableList<List<Resources.ConfigValue>> densityGroups, Targeting.ScreenDensity.DensityAlias densityAlias) {
        return densityGroups.stream().flatMap(group -> new ScreenDensitySelector().selectAllMatchingConfigValues((ImmutableList<Resources.ConfigValue>)ImmutableList.copyOf((Collection)group), densityAlias, ScreenDensityResourcesSplitter.allBut(this.densityBuckets, densityAlias), this.bundleVersion).stream());
    }

    private static Set<Targeting.ScreenDensity.DensityAlias> allBut(ImmutableSet<Targeting.ScreenDensity.DensityAlias> splitByDensities, Targeting.ScreenDensity.DensityAlias densityAlias) {
        return Sets.difference(splitByDensities, (Set)ImmutableSet.of((Object)((Object)densityAlias)));
    }

    private static ConfigurationOuterClass.Configuration clearDensity(ConfigurationOuterClass.Configuration source) {
        return source.toBuilder().clearDensity().build();
    }
}

