/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import shadow.bundletool.com.android.utils.CharSequenceReader;
import shadow.bundletool.com.android.utils.XmlUtils;

public class CharSequences {
    public static int indexOf(CharSequence sequence, char c3) {
        return CharSequences.indexOf(sequence, c3, 0);
    }

    public static int indexOf(CharSequence sequence, char c3, int start) {
        for (int i3 = start; i3 < sequence.length(); ++i3) {
            if (sequence.charAt(i3) != c3) continue;
            return i3;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle, int start) {
        int length = haystack.length();
        int needleLength = needle.length();
        if (needleLength <= length && start >= 0) {
            if (needleLength > 0) {
                if (start > length - needleLength) {
                    start = length - needleLength;
                }
                char firstChar = needle.charAt(0);
                while (true) {
                    int i3;
                    if ((i3 = CharSequences.lastIndexOf(haystack, firstChar, start)) == -1) {
                        return -1;
                    }
                    int o12 = i3;
                    int o22 = 0;
                    while (++o22 < needleLength && haystack.charAt(++o12) == needle.charAt(o22)) {
                    }
                    if (o22 == needleLength) {
                        return i3;
                    }
                    start = i3 - 1;
                }
            }
            return start < length ? start : length;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence sequence, char c3) {
        return CharSequences.lastIndexOf(sequence, c3, sequence.length());
    }

    public static int lastIndexOf(CharSequence sequence, int c3, int start) {
        int length = sequence.length();
        if (start >= 0) {
            if (start >= length) {
                start = length - 1;
            }
            for (int i3 = start; i3 >= 0; --i3) {
                if (sequence.charAt(i3) != c3) continue;
                return i3;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle) {
        return CharSequences.lastIndexOf(haystack, needle, haystack.length());
    }

    public static boolean regionMatches(CharSequence sequence, int thisStart, CharSequence string, int start, int length) {
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        if (thisStart < 0 || sequence.length() - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        for (int i3 = 0; i3 < length; ++i3) {
            if (sequence.charAt(thisStart + i3) == string.charAt(start + i3)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence sequence, boolean ignoreCase, int thisStart, CharSequence string, int start, int length) {
        if (!ignoreCase) {
            return CharSequences.regionMatches(sequence, thisStart, string, start, length);
        }
        if (thisStart < 0 || length > sequence.length() - thisStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int end = thisStart + length;
        while (thisStart < end) {
            char c22;
            char c12;
            if ((c12 = sequence.charAt(thisStart++)) == (c22 = string.charAt(start++)) || CharSequences.foldCase(c12) == CharSequences.foldCase(c22)) continue;
            return false;
        }
        return true;
    }

    private static char foldCase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        return Character.toLowerCase(Character.toUpperCase(ch));
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix) {
        return CharSequences.startsWith(sequence, prefix, 0);
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix, int start) {
        int prefixLength;
        int sequenceLength = sequence.length();
        if (sequenceLength + start < (prefixLength = prefix.length())) {
            return false;
        }
        int i3 = start;
        for (int j3 = 0; j3 < prefixLength; ++j3) {
            if (sequence.charAt(i3) != prefix.charAt(j3)) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix, boolean caseSensitive) {
        if (suffix.length() > sequence.length()) {
            return false;
        }
        int suffixLength = suffix.length();
        int sequenceLength = sequence.length();
        int i3 = sequenceLength - suffixLength;
        int j3 = 0;
        while (i3 < sequenceLength) {
            char c22;
            char c12 = sequence.charAt(i3);
            if (c12 != (c22 = suffix.charAt(j3))) {
                if (caseSensitive) {
                    return false;
                }
                if (Character.toLowerCase(c12) != Character.toLowerCase(c22)) {
                    return false;
                }
            }
            ++i3;
            ++j3;
        }
        return true;
    }

    public static boolean containsUpperCase(CharSequence s3) {
        if (s3 != null) {
            int n3 = s3.length();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!Character.isUpperCase(s3.charAt(i3))) continue;
                return true;
            }
        }
        return false;
    }

    public static int indexOf(CharSequence haystack, CharSequence needle) {
        return CharSequences.indexOf(haystack, needle, 0);
    }

    public static int indexOf(CharSequence haystack, CharSequence needle, int start) {
        int needleLength = needle.length();
        if (needleLength == 0) {
            return start;
        }
        char first = needle.charAt(0);
        if (needleLength == 1) {
            return CharSequences.indexOf(haystack, first, start);
        }
        int max = haystack.length() - needleLength;
        block0: for (int i3 = start; i3 <= max; ++i3) {
            if (haystack.charAt(i3) != first) continue;
            int h3 = i3 + 1;
            for (int n3 = 1; n3 < needleLength; ++n3) {
                if (haystack.charAt(h3) != needle.charAt(n3)) continue block0;
                ++h3;
            }
            return i3;
        }
        return -1;
    }

    public static CharSequence createSequence(char[] data) {
        return new ArrayBackedCharSequence(data);
    }

    public static CharSequence createSequence(char[] data, int offset, int length) {
        return new ArrayBackedCharSequence(data, offset, length);
    }

    public static char[] getCharArray(CharSequence sequence) {
        if (sequence instanceof ArrayBackedCharSequence) {
            return ((ArrayBackedCharSequence)sequence).getCharArray();
        }
        return sequence.toString().toCharArray();
    }

    public static CharSequenceReader getReader(CharSequence data, boolean stripBom) {
        CharSequenceReader reader = new CharSequenceReader(data);
        if (stripBom && data.length() > 0 && data.charAt(0) == '\ufeff') {
            reader.read();
        }
        return reader;
    }

    public static Document parseDocumentSilently(CharSequence xml, boolean namespaceAware) {
        try {
            CharSequenceReader reader = CharSequences.getReader(xml, true);
            return XmlUtils.parseDocument(reader, namespaceAware);
        }
        catch (IOException | SAXException exception) {
            return null;
        }
    }

    public static InputStream getInputStream(CharSequence text) {
        return new ByteArrayInputStream(text.toString().getBytes(Charsets.UTF_8));
    }

    private static class ArrayBackedCharSequence
    implements CharSequence {
        public final char[] data;
        private final int offset;
        private final int length;

        public ArrayBackedCharSequence(char[] data) {
            this(data, 0, data.length);
        }

        public ArrayBackedCharSequence(char[] data, int offset, int length) {
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public char[] getCharArray() {
            if (this.offset == 0 && this.length == this.data.length) {
                return this.data;
            }
            return Arrays.copyOfRange(this.data, this.offset, this.offset + this.length);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.data[this.offset + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ArrayBackedCharSequence(this.data, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            return new String(this.data, this.offset, this.length);
        }
    }
}

