/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.apksig.internal.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import shadow.bundletool.com.android.apksig.internal.util.ByteBufferSink;
import shadow.bundletool.com.android.apksig.internal.util.Pair;
import shadow.bundletool.com.android.apksig.util.DataSink;
import shadow.bundletool.com.android.apksig.util.DataSource;

public class ChainedDataSource
implements DataSource {
    private final DataSource[] mSources;
    private final long mTotalSize;

    public ChainedDataSource(DataSource ... sources) {
        this.mSources = sources;
        this.mTotalSize = Arrays.stream(sources).mapToLong(src -> src.size()).sum();
    }

    @Override
    public long size() {
        return this.mTotalSize;
    }

    @Override
    public void feed(long offset, long size, DataSink sink) throws IOException {
        if (offset + size > this.mTotalSize) {
            throw new IndexOutOfBoundsException("Requested more than available");
        }
        for (DataSource src : this.mSources) {
            if (offset >= src.size()) {
                offset -= src.size();
                continue;
            }
            long remaining = src.size() - offset;
            if (remaining >= size) {
                src.feed(offset, size, sink);
                break;
            }
            src.feed(offset, remaining, sink);
            size -= remaining;
            offset = 0L;
        }
    }

    @Override
    public ByteBuffer getByteBuffer(long offset, int size) throws IOException {
        int i3;
        if (offset + (long)size > this.mTotalSize) {
            throw new IndexOutOfBoundsException("Requested more than available");
        }
        Pair<Integer, Long> firstSource = this.locateDataSource(offset);
        offset = firstSource.getSecond();
        if (offset + (long)size <= this.mSources[i3].size()) {
            return this.mSources[i3].getByteBuffer(offset, size);
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (i3 = firstSource.getFirst().intValue(); i3 < this.mSources.length && buffer.hasRemaining(); ++i3) {
            long sizeToCopy = Math.min(this.mSources[i3].size() - offset, (long)buffer.remaining());
            this.mSources[i3].copyTo(offset, Math.toIntExact(sizeToCopy), buffer);
            offset = 0L;
        }
        buffer.rewind();
        return buffer;
    }

    @Override
    public void copyTo(long offset, int size, ByteBuffer dest) throws IOException {
        this.feed(offset, size, new ByteBufferSink(dest));
    }

    @Override
    public DataSource slice(long offset, long size) {
        DataSource beginSource;
        Pair<Integer, Long> firstSource = this.locateDataSource(offset);
        int beginIndex = firstSource.getFirst();
        long beginLocalOffset = firstSource.getSecond();
        if (beginLocalOffset + size <= (beginSource = this.mSources[beginIndex]).size()) {
            return beginSource.slice(beginLocalOffset, size);
        }
        ArrayList<DataSource> sources = new ArrayList<DataSource>();
        sources.add(beginSource.slice(beginLocalOffset, beginSource.size() - beginLocalOffset));
        Pair<Integer, Long> lastSource = this.locateDataSource(offset + size);
        int endIndex = lastSource.getFirst();
        long endLocalOffset = lastSource.getSecond();
        for (int i3 = beginIndex + 1; i3 < endIndex - 1; ++i3) {
            sources.add(this.mSources[i3]);
        }
        sources.add(this.mSources[endIndex].slice(0L, endLocalOffset));
        return new ChainedDataSource(sources.toArray(new DataSource[0]));
    }

    private Pair<Integer, Long> locateDataSource(long offset) {
        long localOffset = offset;
        for (int i3 = 0; i3 < this.mSources.length; ++i3) {
            if (localOffset < this.mSources[i3].size()) {
                return Pair.of(i3, localOffset);
            }
            localOffset -= this.mSources[i3].size();
        }
        throw new IndexOutOfBoundsException("Access is out of bound, offset: " + offset + ", totalSize: " + this.mTotalSize);
    }
}

