/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ShardedSystemSplits;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.splitters.BundleSharder;
import com.android.tools.build.bundletool.splitters.BundleSharderConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Optional;

public final class ShardedApksGenerator {
    private final Path tempDir;
    private final Version bundleVersion;
    private final boolean generate64BitShards;

    public ShardedApksGenerator(Path tempDir, Version bundleVersion) {
        this(tempDir, bundleVersion, true);
    }

    public ShardedApksGenerator(Path tempDir, Version bundleVersion, boolean generate64BitShards) {
        this.tempDir = tempDir;
        this.bundleVersion = bundleVersion;
        this.generate64BitShards = generate64BitShards;
    }

    public ImmutableList<ModuleSplit> generateSplits(ImmutableList<BundleModule> modules, BundleMetadata bundleMetadata, ApkOptimizations apkOptimizations) {
        BundleSharderConfiguration configuration = BundleSharderConfiguration.builder().setGenerate64BitShard(this.generate64BitShards).build();
        BundleSharder bundleSharder = new BundleSharder(this.tempDir, this.bundleVersion, configuration);
        return ShardedApksGenerator.setVariantTargetingAndSplitType(bundleSharder.shardBundle(modules, apkOptimizations.getSplitDimensions(), bundleMetadata), ModuleSplit.SplitType.STANDALONE);
    }

    public ImmutableList<ModuleSplit> generateSystemSplits(ImmutableList<BundleModule> modules, ImmutableSet<BundleModuleName> modulesToFuse, BundleMetadata bundleMetadata, ApkOptimizations apkOptimizations, Optional<Devices.DeviceSpec> deviceSpec) {
        BundleSharderConfiguration configuration = BundleSharderConfiguration.builder().setGenerate64BitShard(this.generate64BitShards).setDeviceSpec(deviceSpec).build();
        BundleSharder bundleSharder = new BundleSharder(this.tempDir, this.bundleVersion, configuration);
        ShardedSystemSplits shardedApks = bundleSharder.shardForSystemApps(modules, modulesToFuse, apkOptimizations.getSplitDimensions(), bundleMetadata);
        ModuleSplit fusedApk = ShardedApksGenerator.setVariantTargetingAndSplitType(shardedApks.getSystemImageSplit(), ModuleSplit.SplitType.SYSTEM).toBuilder().setMasterSplit(true).build();
        ImmutableList additionalSplitApks = (ImmutableList)shardedApks.getAdditionalSplits().stream().map(split -> split.toBuilder().setVariantTargeting(fusedApk.getVariantTargeting()).setSplitType(ModuleSplit.SplitType.SYSTEM).build()).collect(ImmutableList.toImmutableList());
        return ImmutableList.builder().add((Object)fusedApk).addAll((Iterable)additionalSplitApks).build();
    }

    public ImmutableList<ModuleSplit> generateApexSplits(ImmutableList<BundleModule> modules) {
        BundleSharderConfiguration configuration = BundleSharderConfiguration.builder().setGenerate64BitShard(this.generate64BitShards).build();
        BundleSharder bundleSharder = new BundleSharder(this.tempDir, this.bundleVersion, configuration);
        ImmutableList<ModuleSplit> shardedApexApks = bundleSharder.shardApexBundle((BundleModule)Iterables.getOnlyElement(modules));
        return ShardedApksGenerator.setVariantTargetingAndSplitType(shardedApexApks, ModuleSplit.SplitType.STANDALONE);
    }

    private static ImmutableList<ModuleSplit> setVariantTargetingAndSplitType(ImmutableList<ModuleSplit> standaloneApks, ModuleSplit.SplitType splitType) {
        return (ImmutableList)standaloneApks.stream().map(moduleSplit -> ShardedApksGenerator.setVariantTargetingAndSplitType(moduleSplit, splitType)).collect(ImmutableList.toImmutableList());
    }

    private static ModuleSplit setVariantTargetingAndSplitType(ModuleSplit moduleSplit, ModuleSplit.SplitType splitType) {
        return moduleSplit.toBuilder().setVariantTargeting(ShardedApksGenerator.standaloneApkVariantTargeting(moduleSplit)).setSplitType(splitType).build();
    }

    private static Targeting.VariantTargeting standaloneApkVariantTargeting(ModuleSplit standaloneApk) {
        Targeting.ApkTargeting apkTargeting = standaloneApk.getApkTargeting();
        Targeting.VariantTargeting.Builder variantTargeting = Targeting.VariantTargeting.newBuilder();
        if (apkTargeting.hasAbiTargeting()) {
            variantTargeting.setAbiTargeting(apkTargeting.getAbiTargeting());
        }
        if (apkTargeting.hasScreenDensityTargeting()) {
            variantTargeting.setScreenDensityTargeting(apkTargeting.getScreenDensityTargeting());
        }
        if (apkTargeting.hasMultiAbiTargeting()) {
            variantTargeting.setMultiAbiTargeting(apkTargeting.getMultiAbiTargeting());
        }
        variantTargeting.setSdkVersionTargeting(ShardedApksGenerator.sdkVersionTargeting(standaloneApk));
        return variantTargeting.build();
    }

    private static Targeting.SdkVersionTargeting sdkVersionTargeting(ModuleSplit moduleSplit) {
        return Targeting.SdkVersionTargeting.newBuilder().addValue(TargetingProtoUtils.sdkVersionFrom(moduleSplit.getAndroidManifest().getEffectiveMinSdkVersion())).build();
    }
}

