/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.targeting;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Predicate;

public final class TargetingUtils {
    public static ImmutableList<TargetingDimension> getTargetingDimensions(Targeting.AssetsDirectoryTargeting targeting) {
        ImmutableList.Builder dimensions = new ImmutableList.Builder();
        if (targeting.hasAbi()) {
            dimensions.add((Object)TargetingDimension.ABI);
        }
        if (targeting.hasGraphicsApi()) {
            dimensions.add((Object)TargetingDimension.GRAPHICS_API);
        }
        if (targeting.hasTextureCompressionFormat()) {
            dimensions.add((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT);
        }
        if (targeting.hasLanguage()) {
            dimensions.add((Object)TargetingDimension.LANGUAGE);
        }
        return dimensions.build();
    }

    public static ImmutableSet<Targeting.VariantTargeting> generateAllVariantTargetings(ImmutableSet<Targeting.VariantTargeting> variantTargetings) {
        if (variantTargetings.size() <= 1) {
            return variantTargetings;
        }
        ImmutableList<Targeting.SdkVersionTargeting> sdkVersionTargetings = TargetingUtils.disjointSdkTargetings((ImmutableList<Targeting.SdkVersionTargeting>)((ImmutableList)variantTargetings.stream().map(variantTargeting -> variantTargeting.getSdkVersionTargeting()).collect(ImmutableList.toImmutableList())));
        return (ImmutableSet)sdkVersionTargetings.stream().map(sdkVersionTargeting -> Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting((Targeting.SdkVersionTargeting)sdkVersionTargeting).build()).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<Targeting.VariantTargeting> cropVariantsWithAppSdkRange(ImmutableSet<Targeting.VariantTargeting> variantTargetings, Range<Integer> sdkRange) {
        ImmutableList<Range<Integer>> ranges = TargetingUtils.calculateVariantSdkRanges(variantTargetings, sdkRange);
        return (ImmutableSet)ranges.stream().map(range -> TargetingUtils.sdkVariantTargeting((Integer)range.lowerEndpoint())).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableList<Range<Integer>> calculateVariantSdkRanges(ImmutableSet<Targeting.VariantTargeting> variantTargetings, Range<Integer> appSdkRange) {
        return (ImmutableList)TargetingUtils.disjointSdkTargetings((ImmutableList<Targeting.SdkVersionTargeting>)((ImmutableList)variantTargetings.stream().map(variantTargeting -> variantTargeting.getSdkVersionTargeting()).collect(ImmutableList.toImmutableList()))).stream().map(sdkTargeting -> Range.closedOpen((Comparable)Integer.valueOf(TargetingUtils.getMinSdk(sdkTargeting)), (Comparable)Integer.valueOf(TargetingUtils.getMaxSdk(sdkTargeting)))).filter(arg_0 -> appSdkRange.isConnected(arg_0)).map(arg_0 -> appSdkRange.intersection(arg_0)).filter((Predicate<Range>)Predicates.not(Range::isEmpty)).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<Targeting.SdkVersionTargeting> disjointSdkTargetings(ImmutableList<Targeting.SdkVersionTargeting> sdkVersionTargetings) {
        sdkVersionTargetings.forEach(sdkVersionTargeting -> Preconditions.checkState((sdkVersionTargeting.getValueList().size() == 1 ? 1 : 0) != 0));
        ImmutableList minSdkValues = (ImmutableList)sdkVersionTargetings.stream().map(sdkVersionTargeting -> sdkVersionTargeting.getValue(0).getMin().getValue()).distinct().sorted().collect(ImmutableList.toImmutableList());
        ImmutableSet sdkVersions = (ImmutableSet)minSdkValues.stream().map(TargetingProtoUtils::sdkVersionFrom).collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)sdkVersions.stream().map(sdkVersion -> TargetingProtoUtils.sdkVersionTargeting(sdkVersion, (ImmutableSet<Targeting.SdkVersion>)Sets.difference((Set)sdkVersions, (Set)ImmutableSet.of((Object)sdkVersion)).immutableCopy())).collect(ImmutableList.toImmutableList());
    }

    public static int getMinSdk(Targeting.SdkVersionTargeting sdkVersionTargeting) {
        if (sdkVersionTargeting.getValueList().isEmpty()) {
            return 1;
        }
        return ((Targeting.SdkVersion)Iterables.getOnlyElement(sdkVersionTargeting.getValueList())).getMin().getValue();
    }

    public static int getMaxSdk(Targeting.SdkVersionTargeting sdkVersionTargeting) {
        int minSdk = TargetingUtils.getMinSdk(sdkVersionTargeting);
        int alternativeMinSdk = sdkVersionTargeting.getAlternativesList().stream().mapToInt(alternativeSdk -> alternativeSdk.getMin().getValue()).filter(sdkValue -> minSdk < sdkValue).min().orElse(Integer.MAX_VALUE);
        return alternativeMinSdk;
    }

    private static Targeting.VariantTargeting sdkVariantTargeting(int minSdk) {
        return Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(TargetingProtoUtils.sdkVersionFrom(minSdk))).build();
    }
}

