/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_ModuleZipEntry;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class ModuleZipEntry
implements ModuleEntry {
    abstract ZipEntry getZipEntry();

    abstract ZipFile getZipFile();

    abstract int getPathNamesToSkip();

    @Override
    public abstract boolean shouldCompress();

    @Override
    @MustBeClosed
    public InputStream getContent() {
        try {
            return BufferedIo.inputStream(this.getZipFile(), this.getZipEntry());
        }
        catch (IOException e3) {
            throw new UncheckedIOException(String.format("Error while reading the zip entry '%s'.", this.getZipEntry().getName()), e3);
        }
    }

    @Override
    public ZipPath getPath() {
        ZipPath path = ZipPath.create(this.getZipEntry().getName());
        return path.subpath(this.getPathNamesToSkip(), path.getNameCount());
    }

    @Override
    public boolean isDirectory() {
        return this.getZipEntry().isDirectory();
    }

    @Override
    public ModuleZipEntry setCompression(boolean shouldCompress) {
        if (shouldCompress == this.shouldCompress()) {
            return this;
        }
        return ModuleZipEntry.create(this.getZipEntry(), this.getZipFile(), this.getPathNamesToSkip(), shouldCompress);
    }

    public static ModuleZipEntry fromBundleZipEntry(ZipEntry zipEntry, ZipFile zipFile) {
        return ModuleZipEntry.create(zipEntry, zipFile, 1, true);
    }

    public static ModuleZipEntry fromModuleZipEntry(ZipEntry zipEntry, ZipFile zipFile) {
        return ModuleZipEntry.create(zipEntry, zipFile, 0, true);
    }

    private static ModuleZipEntry create(ZipEntry zipEntry, ZipFile zipFile, int pathNamesToSkip, boolean shouldCompress) {
        Preconditions.checkArgument((ZipPath.create(zipEntry.getName()).getNameCount() > pathNamesToSkip ? 1 : 0) != 0);
        return new AutoValue_ModuleZipEntry(zipEntry, zipFile, pathNamesToSkip, shouldCompress);
    }
}

