/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.SdkConstants;
import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.builder.internal.aapt.v2.Aapt2InternalException;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.ILogger;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H$J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H$J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H$J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\b\b\u0002\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0006\u0010$\u001a\u00020\u0011J\b\u0010%\u001a\u00020\u0011H$J\b\u0010&\u001a\u00020\u0011H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006("}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "getDisplayName", "()Ljava/lang/String;", "getLogger", "()Lcom/android/utils/ILogger;", "<set-?>", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;", "state", "getState", "()Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;", "checkStarted", "", "compile", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "convert", "Lcom/android/builder/internal/aapt/AaptConvertConfig;", "doCompile", "doConvert", "doLink", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "handleError", "", "action", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "unexpected", "", "link", "shutDown", "startProcess", "stopProcess", "State", "builder"})
@NotThreadSafe
public abstract class Aapt2Daemon
implements Aapt2 {
    @NotNull
    private final String displayName;
    @NotNull
    private final ILogger logger;
    @NotNull
    private State state;

    public Aapt2Daemon(@NotNull String displayName, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.displayName = displayName;
        this.logger = logger;
        this.state = State.NEW;
    }

    @NotNull
    protected final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    protected final ILogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    private final void checkStarted() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                Object[] objectArray = new Object[]{this.displayName};
                this.logger.verbose("%1$s: starting", objectArray);
                try {
                    this.startProcess();
                }
                catch (TimeoutException e10) {
                    Aapt2Daemon.handleError$default(this, "Daemon startup timed out", e10, false, 4, null);
                    throw new KotlinNothingValueException();
                }
                catch (Exception e11) {
                    if (SdkConstants.currentPlatform() != 2) {
                        String string = System.getProperty("os.arch");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.arch\")");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"64", (boolean)false, (int)2, null)) {
                            this.handleError("AAPT2 is not supported on 32-bit " + SdkConstants.currentPlatformName() + ", see supported systems on https://developer.android.com/studio#system-requirements-a-namerequirementsa", new IllegalStateException("Unsupported operating system."), false);
                            throw new KotlinNothingValueException();
                        }
                    }
                    Object message = "Daemon startup failed";
                    if (SdkConstants.currentPlatform() == 2) {
                        message = (String)message + "\nPlease check if you installed the Windows Universal C Runtime.";
                    }
                    Aapt2Daemon.handleError$default(this, (String)message, e11, false, 4, null);
                    throw new KotlinNothingValueException();
                }
                this.state = State.RUNNING;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                throw new IllegalStateException((this.displayName + ": Cannot restart a shutdown process").toString());
            }
        }
    }

    protected abstract void startProcess();

    @Override
    public void compile(@NotNull CompileResourceRequest request, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.checkStarted();
        try {
            this.doCompile(request, logger);
        }
        catch (Aapt2Exception e10) {
            throw e10;
        }
        catch (TimeoutException e11) {
            Aapt2Daemon.handleError$default(this, "Compile '" + request.getInputFile() + "' timed out", e11, false, 4, null);
            throw new KotlinNothingValueException();
        }
        catch (Exception e12) {
            Aapt2Daemon.handleError$default(this, "Unexpected error during compile '" + request.getInputFile() + "'", e12, false, 4, null);
            throw new KotlinNothingValueException();
        }
    }

    protected abstract void doCompile(@NotNull CompileResourceRequest var1, @NotNull ILogger var2) throws TimeoutException, Aapt2InternalException, Aapt2Exception;

    @Override
    public void link(@NotNull AaptPackageConfig request, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.checkStarted();
        try {
            this.doLink(request, logger);
        }
        catch (Aapt2Exception e10) {
            throw e10;
        }
        catch (TimeoutException e11) {
            Aapt2Daemon.handleError$default(this, "Link timed out", e11, false, 4, null);
            throw new KotlinNothingValueException();
        }
        catch (Exception e12) {
            Aapt2Daemon.handleError$default(this, "Unexpected error during link", e12, false, 4, null);
            throw new KotlinNothingValueException();
        }
    }

    protected abstract void doLink(@NotNull AaptPackageConfig var1, @NotNull ILogger var2) throws TimeoutException, Aapt2InternalException, Aapt2Exception;

    @Override
    public void convert(@NotNull AaptConvertConfig request, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.checkStarted();
        try {
            this.doConvert(request, logger);
        }
        catch (Aapt2Exception e10) {
            throw e10;
        }
        catch (TimeoutException e11) {
            Aapt2Daemon.handleError$default(this, "Convert timed out", e11, false, 4, null);
            throw new KotlinNothingValueException();
        }
        catch (Exception e12) {
            Aapt2Daemon.handleError$default(this, "Unexpected error during convert", e12, false, 4, null);
            throw new KotlinNothingValueException();
        }
    }

    protected abstract void doConvert(@NotNull AaptConvertConfig var1, @NotNull ILogger var2) throws TimeoutException, Aapt2InternalException, Aapt2Exception;

    public final void shutDown() {
        State state;
        Aapt2Daemon aapt2Daemon = this;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                state = State.SHUTDOWN;
                break;
            }
            case 2: {
                Object[] objectArray = new Object[]{this.displayName};
                this.logger.verbose("%1$s: shutdown", objectArray);
                Aapt2Daemon aapt2Daemon2 = aapt2Daemon;
                try {
                    aapt2Daemon = aapt2Daemon2;
                    this.stopProcess();
                }
                catch (TimeoutException e10) {
                    aapt2Daemon = aapt2Daemon2;
                    this.logger.error((Throwable)e10, this.displayName + " Failed to shutdown within timeout", new Object[0]);
                }
                state = State.SHUTDOWN;
                break;
            }
            case 3: {
                throw new IllegalStateException("Cannot call shutdown multiple times".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        aapt2Daemon.state = state;
    }

    protected abstract void stopProcess() throws TimeoutException;

    private final Void handleError(String action, Exception exception, boolean unexpected) {
        Aapt2InternalException aapt2InternalException;
        Aapt2InternalException $this$handleError_u24lambda_u2d0 = aapt2InternalException = new Aapt2InternalException(this.displayName + ": " + action + (this.state == State.RUNNING ? ", attempting to stop daemon.\n" : "\n") + (unexpected ? "This should not happen under normal circumstances, please file an issue if it does." : ""), exception);
        boolean bl2 = false;
        try {
            this.shutDown();
        }
        catch (Exception suppressed) {
            ExceptionsKt.addSuppressed((Throwable)$this$handleError_u24lambda_u2d0, (Throwable)suppressed);
        }
        throw (Throwable)aapt2InternalException;
    }

    static /* synthetic */ Void handleError$default(Aapt2Daemon aapt2Daemon, String string, Exception exception, boolean bl2, int n10, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleError");
        }
        if ((n10 & 4) != 0) {
            bl2 = true;
        }
        return aapt2Daemon.handleError(string, exception, bl2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2Daemon$State;", "", "(Ljava/lang/String;I)V", "NEW", "RUNNING", "SHUTDOWN", "builder"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State NEW = new State();
        public static final /* enum */ State RUNNING = new State();
        public static final /* enum */ State SHUTDOWN = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.NEW, State.RUNNING, State.SHUTDOWN};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            nArray[State.NEW.ordinal()] = 1;
            nArray[State.RUNNING.ordinal()] = 2;
            nArray[State.SHUTDOWN.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

