/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing.r8;

import com.android.builder.dexing.D8DiagnosticsHandler;
import com.android.builder.dexing.r8.R8DiagnosticsHandler;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.diagnostic.MissingDefinitionInfo;
import com.android.tools.r8.diagnostic.MissingDefinitionsDiagnostic;
import com.android.tools.r8.errors.UnsupportedMainDexListUsageDiagnostic;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/builder/dexing/r8/R8DiagnosticsHandler;", "Lcom/android/builder/dexing/D8DiagnosticsHandler;", "missingKeepRulesFile", "Ljava/nio/file/Path;", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "tool", "", "(Ljava/nio/file/Path;Lcom/android/ide/common/blame/MessageReceiver;Ljava/lang/String;)V", "error", "", "warning", "Lcom/android/tools/r8/Diagnostic;", "generateMissingRulesFile", "Lcom/android/tools/r8/diagnostic/MissingDefinitionsDiagnostic;", "messageKind", "Lcom/android/ide/common/blame/Message$Kind;", "builder"})
public final class R8DiagnosticsHandler
extends D8DiagnosticsHandler {
    @NotNull
    private final Path missingKeepRulesFile;
    @NotNull
    private final MessageReceiver messageReceiver;

    public R8DiagnosticsHandler(@NotNull Path missingKeepRulesFile, @NotNull MessageReceiver messageReceiver, @NotNull String tool) {
        Intrinsics.checkNotNullParameter((Object)missingKeepRulesFile, (String)"missingKeepRulesFile");
        Intrinsics.checkNotNullParameter((Object)messageReceiver, (String)"messageReceiver");
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        super(messageReceiver, tool);
        this.missingKeepRulesFile = missingKeepRulesFile;
        this.messageReceiver = messageReceiver;
    }

    @Override
    public void warning(@Nullable Diagnostic warning) {
        if (warning instanceof UnsupportedMainDexListUsageDiagnostic) {
            this.messageReceiver.receiveMessage(new Message(Message.Kind.WARNING, "Using multiDexKeepFile property with R8 is deprecated and will be fully removed in AGP 8.0. Please migrate to use multiDexKeepProguard instead.", null, null, null, 28, null));
        }
        super.warning(warning);
    }

    @Override
    public void error(@Nullable Diagnostic warning) {
        if (warning instanceof MissingDefinitionsDiagnostic) {
            this.generateMissingRulesFile((MissingDefinitionsDiagnostic)warning, Message.Kind.ERROR);
        }
        super.error(warning);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateMissingRulesFile(MissingDefinitionsDiagnostic warning, Message.Kind messageKind) {
        void $this$mapNotNullTo$iv$iv;
        this.messageReceiver.receiveMessage(new Message(messageKind, StringsKt.trimIndent((String)("\n                                Missing classes detected while running R8. Please add the missing classes or apply additional keep rules that are generated in " + this.missingKeepRulesFile + ".\n                                ")), null, null, null, 28, null));
        Collection<MissingDefinitionInfo> collection = warning.getMissingDefinitions();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"warning.missingDefinitions");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            MissingDefinitionInfo it = (MissingDefinitionInfo)element$iv$iv;
            boolean bl3 = false;
            if ((it.isMissingClass() ? it.asMissingClass().getClassReference().getTypeName() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List missingClasses = (List)destination$iv$iv;
        File file = this.missingKeepRulesFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"missingKeepRulesFile.toFile()");
        Iterable iterable2 = missingClasses;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        FilesKt.writeText$default((File)file, (String)CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, (CharSequence)"# Please add these rules to your existing keep rules in order to suppress warnings.\n# This is generated automatically by the Android Gradle plugin.\n", null, (int)0, null, (Function1)generateMissingRulesFile.1.INSTANCE, (int)28, null), null, (int)2, null);
    }
}

