/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.signflinger.SignedApk;
import com.android.signflinger.SignedApkOptions;
import com.android.zipflinger.Archive;
import com.android.zipflinger.Sources;
import com.android.zipflinger.StableArchive;
import com.android.zipflinger.SynchronizedArchive;
import com.android.zipflinger.Zip64;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/builder/internal/packaging/AabFlinger;", "Ljava/io/Closeable;", "outputFile", "Ljava/io/File;", "signerName", "", "privateKey", "Ljava/security/PrivateKey;", "certificates", "", "Ljava/security/cert/X509Certificate;", "minSdkVersion", "", "(Ljava/io/File;Ljava/lang/String;Ljava/security/PrivateKey;Ljava/util/List;I)V", "archive", "Lcom/android/zipflinger/SynchronizedArchive;", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "kotlin.jvm.PlatformType", "openZipFiles", "", "Ljava/util/zip/ZipFile;", "subTasks", "Ljava/util/concurrent/ForkJoinTask;", "", "close", "writeZip", "zip", "compressionLevel", "builder"})
public final class AabFlinger
implements Closeable {
    @NotNull
    private final SynchronizedArchive archive;
    private final ForkJoinPool forkJoinPool;
    @NotNull
    private final List<ForkJoinTask<Unit>> subTasks;
    @NotNull
    private final List<ZipFile> openZipFiles;

    public AabFlinger(@NotNull File outputFile, @NotNull String signerName, @NotNull PrivateKey privateKey, @NotNull List<? extends X509Certificate> certificates, int minSdkVersion) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)signerName, (String)"signerName");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        this.archive = new SynchronizedArchive((Archive)new StableArchive((Archive)new SignedApk(outputFile, new SignedApkOptions.Builder().setName(signerName).setPrivateKey(privateKey).setCertificates(certificates).setMinSdkVersion(minSdkVersion).setV1Enabled(true).setV2Enabled(false).setV3Enabled(false).setV4Enabled(false).build(), Zip64.Policy.ALLOW)));
        this.forkJoinPool = ForkJoinPool.commonPool();
        boolean bl2 = false;
        this.subTasks = new ArrayList();
        bl2 = false;
        this.openZipFiles = new ArrayList();
    }

    public final void writeZip(@NotNull File zip, int compressionLevel) throws IOException {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Preconditions.checkArgument((boolean)zip.isFile(), (String)"!zip.isFile()", (Object[])new Object[0]);
        ZipFile zipFile = new ZipFile(zip);
        this.openZipFiles.add(zipFile);
        Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
        while (entries2.hasMoreElements()) {
            ZipEntry entry = entries2.nextElement();
            if (entry.isDirectory()) continue;
            Object object = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entry.name");
            if (StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"../", (boolean)false, (int)2, null)) {
                throw new InvalidPathException(entry.getName(), "Entry name contains invalid characters");
            }
            object = this.forkJoinPool.submit(new Callable(this, zipFile, entry, compressionLevel){
                final /* synthetic */ AabFlinger this$0;
                final /* synthetic */ ZipFile $zipFile;
                final /* synthetic */ ZipEntry $entry;
                final /* synthetic */ int $compressionLevel;
                {
                    this.this$0 = $receiver;
                    this.$zipFile = $zipFile;
                    this.$entry = $entry;
                    this.$compressionLevel = $compressionLevel;
                }

                public final void call() {
                    AabFlinger.access$getArchive$p(this.this$0).add(Sources.from((InputStream)this.$zipFile.getInputStream(this.$entry), (String)this.$entry.getName(), (int)this.$compressionLevel));
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"@Throws(IOException::cla\u2026        )\n        }\n    }");
            this.subTasks.add((ForkJoinTask<Unit>)object);
        }
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.subTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForkJoinTask it2 = (ForkJoinTask)element$iv;
            boolean bl2 = false;
            it2.join();
        }
        this.archive.close();
        $this$forEach$iv = this.openZipFiles;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Closeable p02 = (Closeable)element$iv;
            boolean bl3 = false;
            p02.close();
        }
    }

    public static final /* synthetic */ SynchronizedArchive access$getArchive$p(AabFlinger $this) {
        return $this.archive;
    }
}

