/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.desugaring;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;

public final class DesugaringData {
    private final Path path;
    private final String internalName;
    private final Set<String> dependencies;

    DesugaringData(Path path) {
        this.path = path;
        this.internalName = null;
        this.dependencies = ImmutableSet.of();
    }

    DesugaringData(Path path, String internalName, Set<String> dependencies) {
        this.path = path;
        this.internalName = internalName;
        this.dependencies = dependencies;
    }

    public Path getPath() {
        return this.path;
    }

    boolean isLive() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    String getInternalName() {
        return (String)Preconditions.checkNotNull((Object)this.internalName, (Object)"First check if isLive().");
    }

    Set<String> getDependencies() {
        return this.dependencies;
    }
}

