/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.desugaring;

import com.android.builder.desugaring.DesugaringData;
import com.android.builder.desugaring.DesugaringGraph;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.function.Supplier;

public final class DesugaringGraphs {
    static Cache<String, DesugaringGraph> graphs = CacheBuilder.newBuilder().maximumSize(4L).build();

    private DesugaringGraphs() {
    }

    public static DesugaringGraph forVariant(String projectVariant, Supplier<Collection<DesugaringData>> ifFull, Supplier<Collection<DesugaringData>> ifIncremental) {
        DesugaringGraph graph = (DesugaringGraph)graphs.getIfPresent((Object)projectVariant);
        if (graph != null) {
            graph.update(ifIncremental.get());
        } else {
            graph = new DesugaringGraph(ifFull.get());
            graphs.put((Object)projectVariant, (Object)graph);
        }
        return graph;
    }

    public static DesugaringGraph forVariant(String projectVariant, Collection<DesugaringData> fullDesugaringData) {
        DesugaringGraph graph = new DesugaringGraph(fullDesugaringData);
        graphs.put((Object)projectVariant, (Object)graph);
        return graph;
    }

    public static DesugaringGraph updateVariant(String projectVariant, Supplier<Collection<DesugaringData>> incrementalDesugaringData) {
        DesugaringGraph graph = (DesugaringGraph)graphs.getIfPresent((Object)projectVariant);
        if (graph != null) {
            graph.update(incrementalDesugaringData.get());
        }
        return graph;
    }

    public static void invalidate(String projectVariant) {
        graphs.invalidate((Object)projectVariant);
    }
}

