/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.BytecodeRClassWriterKt;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.RGeneration;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.ManifestData;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001al\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001aZ\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0001\u001a\u0016\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"processLibraryMainSymbolTable", "", "librarySymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "libraries", "", "Ljava/io/File;", "mainPackageName", "", "manifestFile", "sourceOut", "rClassOutputJar", "symbolFileOut", "platformSymbols", "namespacedRClass", "", "generateDependencyRClasses", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "", "finalPackageName", "depSymbolTables", "Ljava/nio/file/Path;", "writeSymbolListWithPackageName", "table", "writer", "Ljava/io/Writer;", "builder"})
@JvmName(name="SymbolExportUtils")
public final class SymbolExportUtils {
    public static final void processLibraryMainSymbolTable(@NotNull SymbolTable librarySymbols, @NotNull Set<? extends File> libraries, @Nullable String mainPackageName, @NotNull File manifestFile, @Nullable File sourceOut, @Nullable File rClassOutputJar, @Nullable File symbolFileOut, @NotNull SymbolTable platformSymbols, boolean namespacedRClass, boolean generateDependencyRClasses, @NotNull IdProvider idProvider) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
        Intrinsics.checkParameterIsNotNull((Object)platformSymbols, (String)"platformSymbols");
        Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
        String string = mainPackageName;
        if (string == null) {
            string = SymbolUtils.getPackageNameFromManifest((ManifestData)SymbolUtils.parseManifest((File)manifestFile));
        }
        String finalPackageName = string;
        ImmutableSet depSymbolTables = SymbolUtils.loadDependenciesSymbolTables((Iterable)libraries);
        File file = symbolFileOut;
        List<SymbolTable> tablesToWrite = SymbolExportUtils.processLibraryMainSymbolTable(finalPackageName, librarySymbols, (Set)depSymbolTables, platformSymbols, namespacedRClass, file != null ? file.toPath() : null, generateDependencyRClasses, idProvider);
        if (sourceOut != null) {
            FileUtils.cleanOutputDir((File)sourceOut);
            Iterable $this$forEach$iv = tablesToWrite;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SymbolTable it = (SymbolTable)element$iv;
                boolean bl = false;
                SymbolIo.exportToJava((SymbolTable)it, (File)sourceOut, (boolean)false);
            }
        }
        if (rClassOutputJar != null) {
            FileUtils.deleteIfExists((File)rClassOutputJar);
            Iterable iterable = tablesToWrite;
            Path path = rClassOutputJar.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"rClassOutputJar.toPath()");
            BytecodeRClassWriterKt.exportToCompiledJava$default(iterable, path, false, 4, null);
        }
    }

    @VisibleForTesting
    @NotNull
    public static final List<SymbolTable> processLibraryMainSymbolTable(@NotNull String finalPackageName, @NotNull SymbolTable librarySymbols, @NotNull Set<? extends SymbolTable> depSymbolTables, @NotNull SymbolTable platformSymbols, boolean namespacedRClass, @Nullable Path symbolFileOut, boolean generateDependencyRClasses, @NotNull IdProvider idProvider) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)finalPackageName, (String)"finalPackageName");
        Intrinsics.checkParameterIsNotNull((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkParameterIsNotNull(depSymbolTables, (String)"depSymbolTables");
        Intrinsics.checkParameterIsNotNull((Object)platformSymbols, (String)"platformSymbols");
        Intrinsics.checkParameterIsNotNull((Object)idProvider, (String)"idProvider");
        SymbolTable allSymbols = SymbolUtils.mergeAndRenumberSymbols((String)finalPackageName, (SymbolTable)librarySymbols, (Collection)depSymbolTables, (SymbolTable)platformSymbols, (IdProvider)idProvider);
        SymbolTable mainSymbolTable = namespacedRClass ? allSymbols.filter(librarySymbols) : allSymbols;
        Path path = symbolFileOut;
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            boolean bl2 = false;
            Path it = path2;
            boolean bl3 = false;
            Files.createDirectories(it.getParent(), new FileAttribute[0]);
            SymbolIo.writeForAar((SymbolTable)mainSymbolTable, (Path)it);
        }
        if (generateDependencyRClasses) {
            List list2 = RGeneration.generateAllSymbolTablesToWrite((SymbolTable)allSymbols, (SymbolTable)mainSymbolTable, (Collection)depSymbolTables);
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"RGeneration.generateAllS\u2026olTable, depSymbolTables)");
        } else {
            ImmutableList immutableList = ImmutableList.of((Object)mainSymbolTable);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(mainSymbolTable)");
            list = (List)immutableList;
        }
        return list;
    }

    public static /* synthetic */ List processLibraryMainSymbolTable$default(String string, SymbolTable symbolTable, Set set, SymbolTable symbolTable2, boolean bl, Path path, boolean bl2, IdProvider idProvider, int n4, Object object) {
        if ((n4 & 0x40) != 0) {
            bl2 = true;
        }
        if ((n4 & 0x80) != 0) {
            idProvider = IdProvider.Companion.sequential();
        }
        return SymbolExportUtils.processLibraryMainSymbolTable(string, symbolTable, set, symbolTable2, bl, path, bl2, idProvider);
    }

    public static final void writeSymbolListWithPackageName(@NotNull SymbolTable table, @NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.write(table.getTablePackage());
        writer.write(10);
        for (ResourceType resourceType : ResourceType.values()) {
            List symbols = table.getSymbolByResourceType(resourceType);
            for (Symbol symbol : symbols) {
                writer.write(resourceType.getName());
                writer.write(32);
                writer.write(symbol.getCanonicalName());
                if (symbol instanceof Symbol.StyleableSymbol) {
                    for (String child : symbol.getChildren()) {
                        writer.write(32);
                        writer.write(child);
                    }
                }
                writer.write(10);
            }
        }
    }
}

