/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.DefaultVectorDrawablesOptions;
import com.android.builder.internal.BaseConfigImpl;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultProductFlavor
extends BaseConfigImpl
implements ProductFlavor {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private String mDimension;
    private ApiVersion mMinSdkVersion;
    private ApiVersion mTargetSdkVersion;
    private Integer mMaxSdkVersion;
    private Integer mRenderscriptTargetApi;
    private Boolean mRenderscriptSupportModeEnabled;
    private Boolean mRenderscriptSupportModeBlasEnabled;
    private Boolean mRenderscriptNdkModeEnabled;
    private Integer mVersionCode;
    private String mVersionName;
    private String mApplicationId;
    private String mTestApplicationId;
    private String mTestInstrumentationRunner;
    private Map<String, String> mTestInstrumentationRunnerArguments = Maps.newHashMap();
    private Boolean mTestHandleProfiling;
    private Boolean mTestFunctionalTest;
    private SigningConfig mSigningConfig;
    private Set<String> mResourceConfiguration;
    private DefaultVectorDrawablesOptions mVectorDrawablesOptions;
    private Boolean mWearAppUnbundled;
    private Map<String, DimensionRequest> missingDimensionSelections;

    public DefaultProductFlavor(String name) {
        this.mName = name;
        this.mVectorDrawablesOptions = new DefaultVectorDrawablesOptions();
    }

    public DefaultProductFlavor(String name, DefaultVectorDrawablesOptions vectorDrawablesOptions) {
        this.mName = name;
        this.mVectorDrawablesOptions = vectorDrawablesOptions;
    }

    public String getName() {
        return this.mName;
    }

    public void setDimension(String dimension) {
        this.mDimension = dimension;
    }

    public String getDimension() {
        return this.mDimension;
    }

    public ProductFlavor setApplicationId(String applicationId) {
        this.mApplicationId = applicationId;
        return this;
    }

    public String getApplicationId() {
        return this.mApplicationId;
    }

    public ProductFlavor setVersionCode(Integer versionCode) {
        this.mVersionCode = versionCode;
        return this;
    }

    public Integer getVersionCode() {
        return this.mVersionCode;
    }

    public ProductFlavor setVersionName(String versionName) {
        this.mVersionName = versionName;
        return this;
    }

    public String getVersionName() {
        return this.mVersionName;
    }

    public ProductFlavor setMinSdkVersion(ApiVersion minSdkVersion) {
        this.mMinSdkVersion = minSdkVersion;
        return this;
    }

    public ApiVersion getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public ProductFlavor setTargetSdkVersion(ApiVersion targetSdkVersion) {
        this.mTargetSdkVersion = targetSdkVersion;
        return this;
    }

    public ApiVersion getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    public ProductFlavor setMaxSdkVersion(Integer maxSdkVersion) {
        this.mMaxSdkVersion = maxSdkVersion;
        return this;
    }

    public Integer getMaxSdkVersion() {
        return this.mMaxSdkVersion;
    }

    public Integer getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    public void setRenderscriptTargetApi(Integer renderscriptTargetApi) {
        this.mRenderscriptTargetApi = renderscriptTargetApi;
    }

    public Boolean getRenderscriptSupportModeEnabled() {
        return this.mRenderscriptSupportModeEnabled;
    }

    public Boolean getRenderscriptSupportModeBlasEnabled() {
        return this.mRenderscriptSupportModeBlasEnabled;
    }

    public ProductFlavor setRenderscriptSupportModeEnabled(Boolean renderscriptSupportMode) {
        this.mRenderscriptSupportModeEnabled = renderscriptSupportMode;
        return this;
    }

    public ProductFlavor setRenderscriptSupportModeBlasEnabled(Boolean renderscriptSupportModeBlas) {
        this.mRenderscriptSupportModeBlasEnabled = renderscriptSupportModeBlas;
        return this;
    }

    public Boolean getRenderscriptNdkModeEnabled() {
        return this.mRenderscriptNdkModeEnabled;
    }

    public ProductFlavor setRenderscriptNdkModeEnabled(Boolean renderscriptNdkMode) {
        this.mRenderscriptNdkModeEnabled = renderscriptNdkMode;
        return this;
    }

    public ProductFlavor setTestApplicationId(String applicationId) {
        this.mTestApplicationId = applicationId;
        return this;
    }

    public String getTestApplicationId() {
        return this.mTestApplicationId;
    }

    public ProductFlavor setTestInstrumentationRunner(String testInstrumentationRunner) {
        this.mTestInstrumentationRunner = testInstrumentationRunner;
        return this;
    }

    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    public ProductFlavor setTestInstrumentationRunnerArguments(Map<String, String> testInstrumentationRunnerArguments) {
        this.mTestInstrumentationRunnerArguments = (Map)Preconditions.checkNotNull(testInstrumentationRunnerArguments);
        return this;
    }

    public Map<String, String> getTestInstrumentationRunnerArguments() {
        return this.mTestInstrumentationRunnerArguments;
    }

    public Boolean getTestHandleProfiling() {
        return this.mTestHandleProfiling;
    }

    public ProductFlavor setTestHandleProfiling(boolean handleProfiling) {
        this.mTestHandleProfiling = handleProfiling;
        return this;
    }

    public Boolean getTestFunctionalTest() {
        return this.mTestFunctionalTest;
    }

    public ProductFlavor setTestFunctionalTest(boolean functionalTest) {
        this.mTestFunctionalTest = functionalTest;
        return this;
    }

    public SigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    public ProductFlavor setSigningConfig(SigningConfig signingConfig) {
        this.mSigningConfig = signingConfig;
        return this;
    }

    public DefaultVectorDrawablesOptions getVectorDrawables() {
        return this.mVectorDrawablesOptions;
    }

    public Boolean getWearAppUnbundled() {
        return this.mWearAppUnbundled;
    }

    public void setWearAppUnbundled(Boolean wearAppUnbundled) {
        this.mWearAppUnbundled = wearAppUnbundled;
    }

    public void addResourceConfiguration(String configuration) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.add(configuration);
    }

    public void addResourceConfigurations(String ... configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(Arrays.asList(configurations));
    }

    public void addResourceConfigurations(Collection<String> configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(configurations);
    }

    public Collection<String> getResourceConfigurations() {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        return this.mResourceConfiguration;
    }

    public void missingDimensionStrategy(String dimension, String requestedValue) {
        this.missingDimensionStrategy(dimension, (List<String>)ImmutableList.of((Object)requestedValue));
    }

    public void missingDimensionStrategy(String dimension, String ... requestedValues) {
        this.missingDimensionStrategy(dimension, (List<String>)ImmutableList.copyOf((Object[])requestedValues));
    }

    public void missingDimensionStrategy(String dimension, List<String> requestedValues) {
        if (requestedValues.isEmpty()) {
            throw new RuntimeException("List of requested values cannot be empty");
        }
        DimensionRequest selection = this.computeRequestedAndFallBacks(requestedValues);
        if (this.missingDimensionSelections == null) {
            this.missingDimensionSelections = Maps.newHashMap();
        }
        this.missingDimensionSelections.put(dimension, selection);
    }

    protected DimensionRequest computeRequestedAndFallBacks(List<String> requestedValues) {
        return new DimensionRequest(requestedValues.get(0), (ImmutableList<String>)ImmutableList.copyOf(requestedValues.subList(1, requestedValues.size())));
    }

    public Map<String, DimensionRequest> getMissingDimensionStrategies() {
        if (this.missingDimensionSelections == null) {
            return ImmutableMap.of();
        }
        return this.missingDimensionSelections;
    }

    protected void mergeWithHigherPriorityFlavor(ProductFlavor overlay) {
        this.mMinSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getMinSdkVersion(), this.mMinSdkVersion);
        this.mTargetSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getTargetSdkVersion(), this.mTargetSdkVersion);
        this.mMaxSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getMaxSdkVersion(), this.mMaxSdkVersion);
        this.mRenderscriptTargetApi = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptTargetApi(), this.mRenderscriptTargetApi);
        this.mRenderscriptSupportModeEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptSupportModeEnabled(), this.mRenderscriptSupportModeEnabled);
        this.mRenderscriptSupportModeBlasEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptSupportModeBlasEnabled(), this.mRenderscriptSupportModeBlasEnabled);
        this.mRenderscriptNdkModeEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptNdkModeEnabled(), this.mRenderscriptNdkModeEnabled);
        this.mVersionCode = DefaultProductFlavor.chooseNotNull(overlay.getVersionCode(), this.mVersionCode);
        this.mVersionName = DefaultProductFlavor.chooseNotNull(overlay.getVersionName(), this.mVersionName);
        this.setVersionNameSuffix(DefaultProductFlavor.mergeVersionNameSuffix(overlay.getVersionNameSuffix(), this.getVersionNameSuffix()));
        this.mApplicationId = DefaultProductFlavor.chooseNotNull(overlay.getApplicationId(), this.mApplicationId);
        this.setApplicationIdSuffix(DefaultProductFlavor.mergeApplicationIdSuffix(overlay.getApplicationIdSuffix(), this.getApplicationIdSuffix()));
        this.mTestApplicationId = DefaultProductFlavor.chooseNotNull(overlay.getTestApplicationId(), this.mTestApplicationId);
        this.mTestInstrumentationRunner = DefaultProductFlavor.chooseNotNull(overlay.getTestInstrumentationRunner(), this.mTestInstrumentationRunner);
        this.mTestInstrumentationRunnerArguments.putAll(overlay.getTestInstrumentationRunnerArguments());
        this.mTestHandleProfiling = DefaultProductFlavor.chooseNotNull(overlay.getTestHandleProfiling(), this.mTestHandleProfiling);
        this.mTestFunctionalTest = DefaultProductFlavor.chooseNotNull(overlay.getTestFunctionalTest(), this.mTestFunctionalTest);
        this.mSigningConfig = DefaultProductFlavor.chooseNotNull(overlay.getSigningConfig(), this.mSigningConfig);
        this.mWearAppUnbundled = DefaultProductFlavor.chooseNotNull(overlay.getWearAppUnbundled(), this.mWearAppUnbundled);
        this.addResourceConfigurations(overlay.getResourceConfigurations());
        this.addManifestPlaceholders(overlay.getManifestPlaceholders());
        this.addResValues(overlay.getResValues());
        this.addBuildConfigFields(overlay.getBuildConfigFields());
        this.setMultiDexEnabled(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexEnabled(), this.getMultiDexEnabled()));
        this.setMultiDexKeepFile(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexKeepFile(), this.getMultiDexKeepFile()));
        this.setMultiDexKeepProguard(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexKeepProguard(), this.getMultiDexKeepProguard()));
        this.getVectorDrawables().setGeneratedDensities((Iterable<String>)DefaultProductFlavor.chooseNotNull(overlay.getVectorDrawables().getGeneratedDensities(), this.getVectorDrawables().getGeneratedDensities()));
        this.getVectorDrawables().setUseSupportLibrary(DefaultProductFlavor.chooseNotNull(overlay.getVectorDrawables().getUseSupportLibrary(), this.getVectorDrawables().getUseSupportLibrary()));
        if (overlay instanceof DefaultProductFlavor) {
            if (this.missingDimensionSelections == null) {
                this.missingDimensionSelections = Maps.newHashMap();
            }
            this.missingDimensionSelections.putAll(((DefaultProductFlavor)overlay).getMissingDimensionStrategies());
        }
    }

    protected void cloneFrom(ProductFlavor flavor) {
    }

    @Override
    protected void _initWith(BaseConfig that) {
        super._initWith(that);
        if (that instanceof ProductFlavor) {
            ProductFlavor thatProductFlavor = (ProductFlavor)that;
            this.mDimension = thatProductFlavor.getDimension();
            this.mMinSdkVersion = thatProductFlavor.getMinSdkVersion();
            this.mTargetSdkVersion = thatProductFlavor.getTargetSdkVersion();
            this.mMaxSdkVersion = thatProductFlavor.getMaxSdkVersion();
            this.mRenderscriptTargetApi = thatProductFlavor.getRenderscriptTargetApi();
            this.mRenderscriptSupportModeEnabled = thatProductFlavor.getRenderscriptSupportModeEnabled();
            this.mRenderscriptSupportModeBlasEnabled = thatProductFlavor.getRenderscriptSupportModeBlasEnabled();
            this.mRenderscriptNdkModeEnabled = thatProductFlavor.getRenderscriptNdkModeEnabled();
            this.mVersionCode = thatProductFlavor.getVersionCode();
            this.mVersionName = thatProductFlavor.getVersionName();
            this.setVersionNameSuffix(thatProductFlavor.getVersionNameSuffix());
            this.mApplicationId = thatProductFlavor.getApplicationId();
            this.mTestApplicationId = thatProductFlavor.getTestApplicationId();
            this.mTestInstrumentationRunner = thatProductFlavor.getTestInstrumentationRunner();
            this.mTestInstrumentationRunnerArguments = Maps.newHashMap((Map)thatProductFlavor.getTestInstrumentationRunnerArguments());
            this.mTestHandleProfiling = thatProductFlavor.getTestHandleProfiling();
            this.mTestFunctionalTest = thatProductFlavor.getTestFunctionalTest();
            this.mSigningConfig = thatProductFlavor.getSigningConfig();
            this.mVectorDrawablesOptions = DefaultVectorDrawablesOptions.copyOf(thatProductFlavor.getVectorDrawables());
            this.mWearAppUnbundled = thatProductFlavor.getWearAppUnbundled();
            this.addResourceConfigurations(thatProductFlavor.getResourceConfigurations());
            this.addManifestPlaceholders(thatProductFlavor.getManifestPlaceholders());
            this.addResValues(thatProductFlavor.getResValues());
            this.addBuildConfigFields(thatProductFlavor.getBuildConfigFields());
            this.setMultiDexEnabled(thatProductFlavor.getMultiDexEnabled());
            this.setMultiDexKeepFile(thatProductFlavor.getMultiDexKeepFile());
            this.setMultiDexKeepProguard(thatProductFlavor.getMultiDexKeepProguard());
        }
        if (that instanceof DefaultProductFlavor) {
            DefaultProductFlavor thatDefaultProductFlavor = (DefaultProductFlavor)that;
            this.missingDimensionSelections = Maps.newHashMap(thatDefaultProductFlavor.getMissingDimensionStrategies());
        }
    }

    protected static <T> T chooseNotNull(T overlay, T base) {
        return overlay != null ? overlay : base;
    }

    public static String mergeApplicationIdSuffix(String overlay, String base) {
        return Strings.nullToEmpty((String)DefaultProductFlavor.joinWithSeparator(overlay, base, Character.valueOf('.')));
    }

    public static String mergeVersionNameSuffix(String overlay, String base) {
        return Strings.nullToEmpty((String)DefaultProductFlavor.joinWithSeparator(overlay, base, null));
    }

    private static String joinWithSeparator(String overlay, String base, Character separator) {
        if (!Strings.isNullOrEmpty((String)overlay)) {
            String baseSuffix = DefaultProductFlavor.chooseNotNull(base, "");
            if (separator == null || overlay.charAt(0) == separator.charValue()) {
                return baseSuffix + overlay;
            }
            return baseSuffix + separator + overlay;
        }
        return base;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.mName).add("dimension", (Object)this.mDimension).add("minSdkVersion", (Object)this.mMinSdkVersion).add("targetSdkVersion", (Object)this.mTargetSdkVersion).add("renderscriptTargetApi", (Object)this.mRenderscriptTargetApi).add("renderscriptSupportModeEnabled", (Object)this.mRenderscriptSupportModeEnabled).add("renderscriptSupportModeBlasEnabled", (Object)this.mRenderscriptSupportModeBlasEnabled).add("renderscriptNdkModeEnabled", (Object)this.mRenderscriptNdkModeEnabled).add("versionCode", (Object)this.mVersionCode).add("versionName", (Object)this.mVersionName).add("applicationId", (Object)this.mApplicationId).add("testApplicationId", (Object)this.mTestApplicationId).add("testInstrumentationRunner", (Object)this.mTestInstrumentationRunner).add("testInstrumentationRunnerArguments", this.mTestInstrumentationRunnerArguments).add("testHandleProfiling", (Object)this.mTestHandleProfiling).add("testFunctionalTest", (Object)this.mTestFunctionalTest).add("signingConfig", (Object)this.mSigningConfig).add("resConfig", this.mResourceConfiguration).add("mBuildConfigFields", this.getBuildConfigFields()).add("mResValues", this.getResValues()).add("mProguardFiles", (Object)this.getProguardFiles()).add("mConsumerProguardFiles", (Object)this.getConsumerProguardFiles()).add("mManifestPlaceholders", this.getManifestPlaceholders()).add("mWearAppUnbundled", (Object)this.mWearAppUnbundled).toString();
    }

    public static class DimensionRequest {
        private final String requested;
        private final ImmutableList<String> fallbacks;

        public DimensionRequest(String requested, ImmutableList<String> fallbacks) {
            this.requested = requested;
            this.fallbacks = fallbacks;
        }

        public String getRequested() {
            return this.requested;
        }

        public List<String> getFallbacks() {
            return this.fallbacks;
        }
    }
}

