/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveBuilder;
import com.android.builder.dexing.DexArchiveBuilderConfig;
import com.android.builder.dexing.DexArchiveBuilderException;
import com.android.builder.dexing.DexArchives;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.util.ByteArray;
import com.android.dx.util.ByteArrayAnnotatedOutput;
import com.android.ide.common.blame.parser.DexParser;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

class DxDexArchiveBuilder
extends DexArchiveBuilder {
    private static final Logger LOGGER = Logger.getLogger(DxDexArchiveBuilder.class.getName());
    private final DexArchiveBuilderConfig config;
    private byte[] inStorage;
    private DexFile.Storage outStorage;

    public DxDexArchiveBuilder(DexArchiveBuilderConfig config) {
        this.config = config;
    }

    @Override
    public void convert(Stream<ClassFileEntry> input, Path output2, boolean isIncremental) throws DexArchiveBuilderException {
        Iterator iterator = input.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        this.outStorage = this.config.getOutBufferSize() > 0 ? new DexFile.Storage(new byte[this.config.getOutBufferSize()]) : null;
        this.inStorage = this.config.getInBufferSize() > 0 ? new byte[this.config.getInBufferSize()] : null;
        ClassFileEntry classFileEntry = null;
        try (DexArchive outputDexArchive = DexArchives.fromInput(output2);){
            while (iterator.hasNext()) {
                ByteArray byteArray;
                classFileEntry = (ClassFileEntry)iterator.next();
                if (this.inStorage == null) {
                    byteArray = new ByteArray(classFileEntry.readAllBytes());
                } else {
                    if (classFileEntry.getSize() > (long)this.inStorage.length) {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.log(Level.FINER, "File too big " + classFileEntry.getSize() + " : " + classFileEntry.getRelativePath() + " vs " + this.inStorage.length);
                        }
                        this.inStorage = new byte[(int)classFileEntry.getSize()];
                    }
                    int readBytes = classFileEntry.readAllBytes(this.inStorage);
                    byteArray = new ByteArray(this.inStorage, 0, readBytes);
                }
                this.dex(classFileEntry.getRelativePath(), byteArray, outputDexArchive);
            }
        }
        catch (IOException | RuntimeException e4) {
            throw this.getExceptionToRethrow(e4, classFileEntry);
        }
    }

    public void dex(String relativePath, ByteArray classBytes, DexArchive output2) throws IOException {
        DirectClassFile cf = new DirectClassFile(classBytes, relativePath, true);
        cf.setAttributeFactory(StdAttributeFactory.THE_ONE);
        cf.getMagic();
        DexFile dexFile = new DexFile(this.config.getDexOptions());
        ClassDefItem classDefItem = CfTranslator.translate(this.config.getDxContext(), cf, null, this.config.getCfOptions(), this.config.getDexOptions(), dexFile);
        dexFile.add(classDefItem);
        if (this.outStorage != null) {
            ByteArrayAnnotatedOutput byteArrayAnnotatedOutput = dexFile.writeTo(this.outStorage);
            output2.addFile(ClassFileEntry.withDexExtension(relativePath), byteArrayAnnotatedOutput.getArray(), 0, byteArrayAnnotatedOutput.getCursor());
        } else {
            byte[] bytes = dexFile.toDex(null, false);
            output2.addFile(ClassFileEntry.withDexExtension(relativePath), bytes, 0, bytes.length);
        }
    }

    private DexArchiveBuilderException getExceptionToRethrow(Throwable t4, ClassFileEntry entry) {
        StringBuilder msg = new StringBuilder();
        msg.append("Error while dexing ");
        if (entry != null) {
            msg.append(entry.getRelativePath());
        }
        msg.append(System.lineSeparator());
        if (t4 instanceof SimException && t4.getMessage().startsWith("invalid opcode ba - invokedynamic requires --min-sdk-version >= 26")) {
            msg.append(DexParser.getEnableDesugaringHint((int)26));
        }
        return new DexArchiveBuilderException(msg.toString(), t4);
    }
}

