/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.KeyedDexItem;
import com.android.tools.r8.graph.Presorted;
import com.android.tools.r8.naming.NamingLens;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public interface PresortedComparable<T>
extends Presorted,
Comparable<T> {
    public static <T extends PresortedComparable<T>> boolean isSorted(List<? extends KeyedDexItem<T>> items) {
        return PresortedComparable.isSorted(items, KeyedDexItem::getKey);
    }

    public static <S, T extends Comparable<T>> boolean isSorted(S[] items, Function<S, T> getter) {
        return PresortedComparable.isSorted(Arrays.asList(items), getter);
    }

    public static <S, T extends Comparable<T>> boolean isSorted(List<? extends S> items, Function<S, T> getter) {
        Comparable current = null;
        for (S item : items) {
            Comparable next = (Comparable)getter.apply(item);
            if (current != null && current.compareTo(next) >= 0) {
                return false;
            }
            current = next;
        }
        return true;
    }

    public int slowCompareTo(T var1);

    public int slowCompareTo(T var1, NamingLens var2);

    public int layeredCompareTo(T var1, NamingLens var2);

    public static <T extends PresortedComparable<T>> int slowCompare(T a, T b) {
        return a.slowCompareTo(b);
    }
}

