/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.naming.NamingLens;
import java.util.Map;

public class DexMethod
extends Descriptor<DexEncodedMethod, DexMethod>
implements PresortedComparable<DexMethod> {
    public final DexType holder;
    public final DexProto proto;
    public final DexString name;
    private Map<DexType, DexEncodedMethod> singleTargetCache;

    DexMethod(DexType holder, DexProto proto, DexString name, boolean skipNameValidationForTesting) {
        this.holder = holder;
        this.proto = proto;
        this.name = name;
        if (!skipNameValidationForTesting && !name.isValidMethodName()) {
            throw new CompilationError("Method name '" + name.toASCIIString() + "' in class '" + holder.toSourceString() + "' cannot be represented in dex format.");
        }
    }

    public String toString() {
        return "Method " + this.holder + "." + this.name + " " + this.proto.toString();
    }

    public int getArity() {
        return this.proto.parameters.size();
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        if (this.collectIndexedItemsExceptName(indexedItems, method, instructionOffset)) {
            this.collectIndexedItemsName(indexedItems, method, instructionOffset);
        }
    }

    public boolean collectIndexedItemsExceptName(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        if (indexedItems.addMethod(this)) {
            this.holder.collectIndexedItems(indexedItems, method, instructionOffset);
            this.proto.collectIndexedItems(indexedItems, method, instructionOffset);
            return true;
        }
        return false;
    }

    public void collectIndexedItemsName(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        indexedItems.getRenamedName(this).collectIndexedItems(indexedItems, method, instructionOffset);
    }

    @Override
    public int getOffset(ObjectToOffsetMapping mapping) {
        return mapping.getOffsetFor(this);
    }

    @Override
    public boolean isDexMethod() {
        return true;
    }

    @Override
    public DexMethod asDexMethod() {
        return this;
    }

    @Override
    public int computeHashCode() {
        return this.holder.hashCode() + this.proto.hashCode() * 7 + this.name.hashCode() * 31;
    }

    @Override
    public boolean computeEquals(Object other) {
        if (other instanceof DexMethod) {
            DexMethod o = (DexMethod)other;
            return this.holder.equals(o.holder) && this.name.equals(o.name) && this.proto.equals(o.proto);
        }
        return false;
    }

    public boolean hasSameProtoAndName(DexMethod other) {
        return this.name == other.name && this.proto == other.proto;
    }

    @Override
    public int compareTo(DexMethod other) {
        return this.sortedCompareTo(other.getSortedIndex());
    }

    @Override
    public int slowCompareTo(DexMethod other) {
        int result = this.holder.slowCompareTo(other.holder);
        if (result != 0) {
            return result;
        }
        result = this.name.slowCompareTo(other.name);
        if (result != 0) {
            return result;
        }
        return this.proto.slowCompareTo(other.proto);
    }

    @Override
    public int slowCompareTo(DexMethod other, NamingLens namingLens) {
        int result = this.holder.slowCompareTo(other.holder, namingLens);
        if (result != 0) {
            return result;
        }
        result = namingLens.lookupName(this).slowCompareTo(namingLens.lookupName(other));
        if (result != 0) {
            return result;
        }
        return this.proto.slowCompareTo(other.proto, namingLens);
    }

    @Override
    public int layeredCompareTo(DexMethod other, NamingLens namingLens) {
        int result = this.holder.compareTo(other.holder);
        if (result != 0) {
            return result;
        }
        result = namingLens.lookupName(this).compareTo(namingLens.lookupName(other));
        if (result != 0) {
            return result;
        }
        return this.proto.compareTo(other.proto);
    }

    @Override
    public boolean match(DexEncodedMethod entry) {
        return entry.method.name == this.name && entry.method.proto == this.proto;
    }

    @Override
    public DexType getHolder() {
        return this.holder;
    }

    public String qualifiedName() {
        return this.holder + "." + this.name;
    }

    @Override
    public String toSmaliString() {
        return this.holder.toSmaliString() + "->" + this.name + this.proto.toSmaliString();
    }

    @Override
    public String toSourceString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.proto.returnType.toSourceString());
        builder.append(" ");
        builder.append(this.holder.toSourceString());
        builder.append(".");
        builder.append(this.name);
        builder.append("(");
        for (int i = 0; i < this.getArity(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(this.proto.parameters.values[i].toSourceString());
        }
        builder.append(")");
        return builder.toString();
    }

    public boolean isLambdaDeserializeMethod(DexItemFactory dexItemFactory) {
        return this.name == dexItemFactory.deserializeLambdaMethodName && this.proto == dexItemFactory.deserializeLambdaMethodProto;
    }

    public synchronized void setSingleVirtualMethodCache(DexType receiverType, DexEncodedMethod method) {
        if (this.singleTargetCache == null) {
            this.singleTargetCache = Maps.newIdentityHashMap();
        }
        this.singleTargetCache.put(receiverType, method);
    }

    public synchronized boolean isSingleVirtualMethodCached(DexType receiverType) {
        return this.singleTargetCache != null && this.singleTargetCache.containsKey(receiverType);
    }

    public synchronized DexEncodedMethod getSingleVirtualMethodCache(DexType receiverType) {
        assert (this.isSingleVirtualMethodCached(receiverType));
        return this.singleTargetCache.get(receiverType);
    }
}

