/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.BytecodeRClassWriterKt;
import com.android.ide.common.symbols.RGeneration;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.ManifestData;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001an\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011\u001aD\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0015H\u0000\u00a8\u0006\u0016"}, d2={"processLibraryMainSymbolTable", "", "librarySymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "libraries", "", "Ljava/io/File;", "mainPackageName", "", "manifestFile", "sourceOut", "rClassOutputJar", "symbolFileOut", "proguardOut", "mergedResources", "platformSymbols", "namespacedRClass", "", "", "finalPackageName", "depSymbolTables", "Ljava/nio/file/Path;", "builder"})
@JvmName(name="SymbolExportUtils")
public final class SymbolExportUtils {
    public static final void processLibraryMainSymbolTable(@NotNull SymbolTable librarySymbols, @NotNull Set<? extends File> libraries, @Nullable String mainPackageName, @NotNull File manifestFile, @Nullable File sourceOut, @Nullable File rClassOutputJar, @NotNull File symbolFileOut, @Nullable File proguardOut, @Nullable File mergedResources, @NotNull SymbolTable platformSymbols, boolean namespacedRClass) throws IOException {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
        Intrinsics.checkParameterIsNotNull((Object)symbolFileOut, (String)"symbolFileOut");
        Intrinsics.checkParameterIsNotNull((Object)platformSymbols, (String)"platformSymbols");
        if (mainPackageName == null || proguardOut != null) {
            ManifestData manifestData = SymbolUtils.parseManifest((File)manifestFile);
            if (proguardOut != null) {
                Files.write(proguardOut.toPath(), (Iterable<? extends CharSequence>)SymbolUtils.generateMinifyKeepRules((ManifestData)manifestData, (File)mergedResources), new OpenOption[0]);
            }
            if ((string = mainPackageName) == null) {
                string = SymbolUtils.getPackageNameFromManifest((ManifestData)manifestData);
            }
        } else {
            string = mainPackageName;
        }
        String finalPackageName = string;
        ImmutableSet depSymbolTables = SymbolUtils.loadDependenciesSymbolTables((Iterable)libraries);
        Set set = (Set)depSymbolTables;
        Path path = symbolFileOut.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"symbolFileOut.toPath()");
        List<SymbolTable> tablesToWrite = SymbolExportUtils.processLibraryMainSymbolTable(finalPackageName, librarySymbols, set, platformSymbols, namespacedRClass, path);
        if (sourceOut != null) {
            FileUtils.cleanOutputDir((File)sourceOut);
            Iterable $receiver$iv = tablesToWrite;
            for (Object element$iv : $receiver$iv) {
                SymbolTable it = (SymbolTable)element$iv;
                SymbolIo.exportToJava((SymbolTable)it, (File)sourceOut, (boolean)false);
            }
        }
        if (rClassOutputJar != null) {
            FileUtils.deleteIfExists((File)rClassOutputJar);
            Iterable iterable = tablesToWrite;
            Path path2 = rClassOutputJar.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"rClassOutputJar.toPath()");
            BytecodeRClassWriterKt.exportToCompiledJava(iterable, path2);
        }
    }

    @NotNull
    public static final List<SymbolTable> processLibraryMainSymbolTable(@NotNull String finalPackageName, @NotNull SymbolTable librarySymbols, @NotNull Set<? extends SymbolTable> depSymbolTables, @NotNull SymbolTable platformSymbols, boolean namespacedRClass, @NotNull Path symbolFileOut) {
        List tablesToWrite;
        Intrinsics.checkParameterIsNotNull((Object)finalPackageName, (String)"finalPackageName");
        Intrinsics.checkParameterIsNotNull((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkParameterIsNotNull(depSymbolTables, (String)"depSymbolTables");
        Intrinsics.checkParameterIsNotNull((Object)platformSymbols, (String)"platformSymbols");
        Intrinsics.checkParameterIsNotNull((Object)symbolFileOut, (String)"symbolFileOut");
        SymbolTable allSymbols = SymbolUtils.mergeAndRenumberSymbols((String)finalPackageName, (SymbolTable)librarySymbols, (Collection)depSymbolTables, (SymbolTable)platformSymbols);
        SymbolTable mainSymbolTable = namespacedRClass ? allSymbols.filter(librarySymbols) : allSymbols;
        Files.createDirectories(symbolFileOut.getParent(), new FileAttribute[0]);
        SymbolIo.writeForAar((SymbolTable)mainSymbolTable, (Path)symbolFileOut);
        List list = tablesToWrite = RGeneration.generateAllSymbolTablesToWrite((SymbolTable)allSymbols, (SymbolTable)mainSymbolTable, (Collection)depSymbolTables);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"tablesToWrite");
        return list;
    }
}

