/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda.kotlin;

import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.optimize.lambda.CaptureSignature;
import com.android.tools.r8.ir.optimize.lambda.CodeProcessor;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupId;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroupCodeStrategy;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroupId;

abstract class KotlinLambdaGroup
extends LambdaGroup {
    private final CodeProcessor.Strategy strategy = new KotlinLambdaGroupCodeStrategy(this);

    KotlinLambdaGroup(LambdaGroupId id) {
        super(id);
    }

    final KotlinLambdaGroupId id() {
        return (KotlinLambdaGroupId)this.id;
    }

    final boolean isStateless() {
        return this.id().capture.isEmpty();
    }

    final boolean hasAnySingletons() {
        assert (this.isStateless());
        return this.anyLambda(info -> this.isSingletonLambda(info.clazz.type));
    }

    final boolean isSingletonLambda(DexType lambda2) {
        assert (this.isStateless());
        return this.lambdaSingletonField(lambda2) != null;
    }

    final DexField getSingletonInstanceField(DexItemFactory factory, int id) {
        return factory.createField(this.getGroupClassType(), this.getGroupClassType(), factory.createString("INSTANCE$" + id));
    }

    @Override
    protected String getTypePackage() {
        String pkg = this.id().pkg;
        return pkg.isEmpty() ? "" : pkg + "/";
    }

    final DexProto createConstructorProto(DexItemFactory factory) {
        String capture = this.id().capture;
        DexType[] newParameters = new DexType[capture.length() + 1];
        newParameters[0] = factory.intType;
        for (int i = 0; i < capture.length(); ++i) {
            newParameters[i + 1] = CaptureSignature.fieldType(factory, capture, i);
        }
        return factory.createProto(factory.voidType, newParameters);
    }

    final DexField getLambdaIdField(DexItemFactory factory) {
        return factory.createField(this.getGroupClassType(), factory.intType, "$id$");
    }

    final int mapFieldIntoCaptureIndex(DexType lambda2, DexField field) {
        return CaptureSignature.mapFieldIntoCaptureIndex(this.id().capture, this.lambdaCaptureFields(lambda2), field);
    }

    final DexField getCaptureField(DexItemFactory factory, int index) {
        assert (index >= 0 && index < this.id().capture.length());
        return factory.createField(this.getGroupClassType(), CaptureSignature.fieldType(factory, this.id().capture, index), "$capture$" + index);
    }

    @Override
    public CodeProcessor.Strategy getCodeStrategy() {
        return this.strategy;
    }
}

