/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda;

import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class LambdaTypeVisitor {
    private final DexItemFactory factory;
    private final Predicate<DexType> isLambdaType;
    private final Consumer<DexType> onLambdaType;

    LambdaTypeVisitor(DexItemFactory factory, Predicate<DexType> isLambdaType, Consumer<DexType> onLambdaType) {
        this.factory = factory;
        this.isLambdaType = isLambdaType;
        this.onLambdaType = onLambdaType;
    }

    void accept(DexCallSite callSite) {
        this.accept(callSite.methodProto);
        this.accept(callSite.bootstrapMethod);
        for (DexValue value : callSite.bootstrapArgs) {
            this.accept(value);
        }
    }

    private void accept(DexValue value) {
        if (value instanceof DexValue.DexValueType) {
            this.accept((DexType)((DexValue.DexValueType)value).value);
            return;
        }
        if (value instanceof DexValue.DexValueArray) {
            for (DexValue subValue : ((DexValue.DexValueArray)value).getValues()) {
                this.accept(subValue);
            }
            return;
        }
        if (value instanceof DexValue.DexValueMethod) {
            this.accept((DexMethod)((DexValue.DexValueMethod)value).value, null);
            return;
        }
        if (value instanceof DexValue.DexValueMethodHandle) {
            this.accept((DexMethodHandle)((DexValue.DexValueMethodHandle)value).value);
            return;
        }
        if (value instanceof DexValue.DexValueMethodType) {
            this.accept((DexProto)((DexValue.DexValueMethodType)value).value);
            return;
        }
        if (value instanceof DexValue.DexValueField) {
            this.accept((DexField)((DexValue.DexValueField)value).value, null);
        }
    }

    void accept(DexMethodHandle handle) {
        if (handle.isFieldHandle()) {
            this.accept(handle.asField(), null);
        } else {
            assert (handle.isMethodHandle());
            this.accept(handle.asMethod(), null);
        }
    }

    void accept(DexField field, DexType holderToIgnore) {
        this.accept(field.type);
        if (holderToIgnore != field.clazz) {
            this.accept(field.clazz);
        }
    }

    void accept(DexMethod method, DexType holderToIgnore) {
        if (holderToIgnore != method.holder) {
            this.accept(method.holder);
        }
        this.accept(method.proto);
    }

    void accept(DexProto proto) {
        this.accept(proto.returnType);
        this.accept(proto.parameters);
    }

    void accept(DexTypeList types) {
        for (DexType type : types.values) {
            this.accept(type);
        }
    }

    void accept(DexAnnotationSet annotationSet) {
        for (DexAnnotation annotation : annotationSet.annotations) {
            this.accept(annotation);
        }
    }

    void accept(ParameterAnnotationsList parameterAnnotationsList) {
        parameterAnnotationsList.forEachAnnotation(this::accept);
    }

    private void accept(DexAnnotation annotation) {
        this.accept(annotation.annotation);
    }

    private void accept(DexEncodedAnnotation annotation) {
        this.accept(annotation.type);
        for (DexAnnotationElement element : annotation.elements) {
            this.accept(element);
        }
    }

    private void accept(DexAnnotationElement element) {
        this.accept(element.value);
    }

    void accept(DexType type) {
        if (type == null) {
            return;
        }
        if (type.isPrimitiveType() || type.isVoidType() || type.isPrimitiveArrayType()) {
            return;
        }
        if (type.isArrayType()) {
            this.accept(type.toArrayElementType(this.factory));
            return;
        }
        if (this.isLambdaType.test(type)) {
            this.onLambdaType.accept(type);
        }
    }
}

