/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfSourceCode;
import com.android.tools.r8.ir.conversion.CfState;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfStackInstruction
extends CfInstruction {
    private final Opcode opcode;

    public static CfStackInstruction fromAsm(int opcode) {
        switch (opcode) {
            case 87: {
                return new CfStackInstruction(Opcode.Pop);
            }
            case 88: {
                return new CfStackInstruction(Opcode.Pop2);
            }
            case 89: {
                return new CfStackInstruction(Opcode.Dup);
            }
            case 90: {
                return new CfStackInstruction(Opcode.DupX1);
            }
            case 91: {
                return new CfStackInstruction(Opcode.DupX2);
            }
            case 92: {
                return new CfStackInstruction(Opcode.Dup2);
            }
            case 93: {
                return new CfStackInstruction(Opcode.Dup2X1);
            }
            case 94: {
                return new CfStackInstruction(Opcode.Dup2X2);
            }
            case 95: {
                return new CfStackInstruction(Opcode.Swap);
            }
        }
        throw new Unreachable("Invalid opcode for CfStackInstruction");
    }

    public static CfStackInstruction popType(ValueType type) {
        return new CfStackInstruction(type.isWide() ? Opcode.Pop2 : Opcode.Pop);
    }

    public CfStackInstruction(Opcode opcode) {
        this.opcode = opcode;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitInsn(this.opcode.opcode);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        switch (this.opcode) {
            case Pop: {
                CfState.Slot pop = state.pop();
                assert (!pop.type.isWide());
                break;
            }
            case Pop2: {
                CfState.Slot value = state.pop();
                if (value.type.isWide()) break;
                state.pop();
                throw new Unimplemented("Building IR for Pop2 of narrow value not supported");
            }
            case Dup: {
                CfState.Slot dupValue = state.peek();
                assert (!dupValue.type.isWide());
                builder.addMove(dupValue.type, state.push((CfState.Slot)dupValue).register, dupValue.register);
                break;
            }
            case DupX1: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                assert (!value1.type.isWide());
                assert (!value2.type.isWide());
                this.dupX1(builder, state, value1, value2);
                break;
            }
            case DupX2: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                assert (!value1.type.isWide());
                if (value2.type.isWide()) {
                    this.dupX1(builder, state, value1, value2);
                    throw new Unimplemented("Building IR for DupX2 of wide value not supported");
                }
                CfState.Slot value3 = state.pop();
                assert (!value3.type.isWide());
                CfState.Slot outValue1 = state.push(value1);
                CfState.Slot outValue3 = state.push(value3);
                CfState.Slot outValue2 = state.push(value2);
                CfState.Slot outValue1Copy = state.push(value1);
                builder.addMove(value1.type, outValue1Copy.register, value1.register);
                builder.addMove(value2.type, outValue2.register, value2.register);
                builder.addMove(value3.type, outValue3.register, value3.register);
                builder.addMove(value1.type, outValue1.register, outValue1Copy.register);
                break;
            }
            case Dup2: {
                CfState.Slot value1 = state.peek();
                if (value1.type.isWide()) {
                    builder.addMove(value1.type, state.push((CfState.Slot)value1).register, value1.register);
                    break;
                }
                CfState.Slot value2 = state.peek(1);
                builder.addMove(value2.type, state.push((CfState.Slot)value2).register, value2.register);
                builder.addMove(value1.type, state.push((CfState.Slot)value1).register, value1.register);
                break;
            }
            case Dup2X1: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                assert (!value2.type.isWide());
                if (value1.type.isWide()) {
                    this.dupX1(builder, state, value1, value2);
                    break;
                }
                CfState.Slot value3 = state.pop();
                assert (!value3.type.isWide());
                CfState.Slot outValue2 = state.push(value2);
                CfState.Slot outValue1 = state.push(value1);
                CfState.Slot outValue3 = state.push(value3);
                CfState.Slot outValue2Copy = state.push(value2);
                CfState.Slot outValue1Copy = state.push(value1);
                builder.addMove(value1.type, outValue1Copy.register, value1.register);
                builder.addMove(value2.type, outValue2Copy.register, value2.register);
                builder.addMove(value3.type, outValue3.register, value3.register);
                builder.addMove(value1.type, outValue1.register, outValue1Copy.register);
                builder.addMove(value2.type, outValue2.register, outValue2Copy.register);
                throw new Unimplemented("Building IR for Dup2X1 narrow not supported");
            }
            case Dup2X2: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                assert (!value2.type.isWide());
                if (value1.type.isWide()) {
                    this.dupX1(builder, state, value1, value2);
                    throw new Unimplemented("Building IR for Dup2X2 wide not supported");
                }
                throw new Unimplemented("Building IR for Dup2X2 narrow not supported");
            }
            case Swap: {
                CfState.Slot value1 = state.pop();
                CfState.Slot value2 = state.pop();
                assert (!value1.type.isWide());
                assert (!value2.type.isWide());
                this.dupX1(builder, state, value1, value2);
                state.pop();
                break;
            }
        }
    }

    private void dupX1(IRBuilder builder, CfState state, CfState.Slot inValue1, CfState.Slot inValue2) {
        CfState.Slot outValue1 = state.push(inValue1);
        CfState.Slot outValue2 = state.push(inValue2);
        CfState.Slot outValue1Copy = state.push(inValue1);
        builder.addMove(inValue1.type, outValue1Copy.register, inValue1.register);
        builder.addMove(inValue2.type, outValue2.register, inValue2.register);
        builder.addMove(outValue1Copy.type, outValue1.register, outValue1Copy.register);
    }

    @Override
    public boolean emitsIR() {
        return false;
    }

    public static enum Opcode {
        Pop(87),
        Pop2(88),
        Dup(89),
        DupX1(90),
        DupX2(91),
        Dup2(92),
        Dup2X1(93),
        Dup2X2(94),
        Swap(95);

        private final int opcode;

        private Opcode(int opcode) {
            this.opcode = opcode;
        }
    }
}

