/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.builder.internal.testing.ShardedTestCallable;
import com.android.builder.testing.BaseTestRunner;
import com.android.builder.testing.TestData;
import com.android.builder.testing.api.DeviceConnector;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class ShardedTestRunner
extends BaseTestRunner {
    private final Integer numShards;

    public ShardedTestRunner(File splitSelectExec, ProcessExecutor processExecutor, Integer numShards) {
        super(splitSelectExec, processExecutor);
        this.numShards = numShards;
    }

    @Override
    protected WaitableExecutor scheduleTests(String projectName, String variantName, TestData testData, Map<DeviceConnector, ImmutableList<File>> apksForDevice, Set<File> helperApks, int timeoutInMs, Collection<String> installOptions, File resultsDir, File coverageDir, ILogger logger) {
        WaitableExecutor executor = WaitableExecutor.useNewFixedSizeThreadPool((int)apksForDevice.keySet().size());
        final int numShards = this.numShards == null ? apksForDevice.size() : this.numShards.intValue();
        final AtomicInteger currentShard = new AtomicInteger(-1);
        ShardedTestCallable.ProgressListener progressListener = new ShardedTestCallable.ProgressListener(numShards, logger);
        ShardedTestCallable.ShardProvider shardProvider = new ShardedTestCallable.ShardProvider(){

            @Override
            public Integer getNextShard() {
                int shard = currentShard.incrementAndGet();
                return shard < numShards ? Integer.valueOf(shard) : null;
            }

            @Override
            public int getTotalShards() {
                return numShards;
            }
        };
        logger.lifecycle("will shard tests into %d shards", new Object[]{numShards});
        for (Map.Entry<DeviceConnector, ImmutableList<File>> runners : apksForDevice.entrySet()) {
            ShardedTestCallable shardedTestCallable = new ShardedTestCallable(runners.getKey(), projectName, variantName, (List)runners.getValue(), testData, resultsDir, coverageDir, timeoutInMs, logger, shardProvider);
            shardedTestCallable.setProgressListener(progressListener);
            executor.execute((Callable)shardedTestCallable);
        }
        return executor;
    }
}

