/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.internal.compiler.DexKey;
import com.android.builder.internal.compiler.PreProcessCache;
import com.android.repository.Revision;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

final class DxDexKey
extends DexKey {
    private static final char ADDITIONAL_PARAMETERS_SEPARATOR = ',';
    private static final String ATTR_ADDITIONAL_PARAMETERS = "custom-flags";
    private static final String ATTR_IS_MULTIDEX = "is-multidex";
    private static final String ATTR_MIN_SDK_VERSION = "min-sdk-version";
    private final ImmutableSortedSet<String> additionalParameters;
    private Integer minSdkVersion;
    private Boolean isMultiDex;
    static final PreProcessCache.KeyFactory<DxDexKey> FACTORY = (sourceFile, revision, attrMap) -> {
        boolean jumboMode = Boolean.parseBoolean(attrMap.getNamedItem("jumboMode").getNodeValue());
        Node optimizeAttribute = attrMap.getNamedItem("optimize");
        boolean optimize = optimizeAttribute != null ? Boolean.parseBoolean(optimizeAttribute.getNodeValue()) : true;
        Object additionalParameters = ImmutableList.of();
        Node additionalParametersAttribute = attrMap.getNamedItem(ATTR_ADDITIONAL_PARAMETERS);
        if (additionalParametersAttribute != null) {
            additionalParameters = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)additionalParametersAttribute.getNodeValue());
        }
        Boolean isMultiDex = null;
        Node multiDexAttr = attrMap.getNamedItem(ATTR_IS_MULTIDEX);
        if (multiDexAttr != null) {
            isMultiDex = Boolean.parseBoolean(multiDexAttr.getNodeValue());
        }
        Integer minSdkVersion = null;
        Node minSdkVersionAttr = attrMap.getNamedItem(ATTR_MIN_SDK_VERSION);
        if (minSdkVersionAttr != null) {
            minSdkVersion = Integer.parseInt(minSdkVersionAttr.getNodeValue());
        }
        return DxDexKey.of(sourceFile, revision, jumboMode, optimize, (Iterable<String>)additionalParameters, isMultiDex, minSdkVersion);
    };

    private DxDexKey(File sourceFile, Revision buildToolsRevision, boolean jumboMode, boolean optimize, Iterable<String> additionalParameters, Boolean isMultiDex, Integer minSdkVersion) {
        super(sourceFile, buildToolsRevision, jumboMode, optimize);
        this.additionalParameters = ImmutableSortedSet.copyOf(additionalParameters);
        this.minSdkVersion = minSdkVersion;
        this.isMultiDex = isMultiDex;
    }

    static DxDexKey of(File sourceFile, Revision buildToolsRevision, boolean jumboMode, boolean optimize, Iterable<String> additionalParameters, Boolean isMultiDex, Integer minSdkVersion) {
        return new DxDexKey(sourceFile, buildToolsRevision, jumboMode, optimize, additionalParameters, isMultiDex, minSdkVersion);
    }

    @Override
    protected void writeFieldsToXml(Node itemNode) {
        super.writeFieldsToXml(itemNode);
        Document document = itemNode.getOwnerDocument();
        if (!this.additionalParameters.isEmpty()) {
            Attr additionalParameters = document.createAttribute(ATTR_ADDITIONAL_PARAMETERS);
            additionalParameters.setValue(Joiner.on((char)',').join(this.additionalParameters));
            itemNode.getAttributes().setNamedItem(additionalParameters);
        }
        if (this.isMultiDex != null) {
            Attr multiDexAttr = document.createAttribute(ATTR_IS_MULTIDEX);
            multiDexAttr.setValue(Boolean.toString(this.isMultiDex));
            itemNode.getAttributes().setNamedItem(multiDexAttr);
        }
        if (this.minSdkVersion != null) {
            Attr minSdkVersionAttr = document.createAttribute(ATTR_MIN_SDK_VERSION);
            minSdkVersionAttr.setValue(Integer.toString(this.minSdkVersion));
            itemNode.getAttributes().setNamedItem(minSdkVersionAttr);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DxDexKey dxDexKey = (DxDexKey)o;
        return this.additionalParameters.equals(dxDexKey.additionalParameters) && Objects.equal((Object)this.isMultiDex, (Object)dxDexKey.isMultiDex) && Objects.equal((Object)this.minSdkVersion, (Object)dxDexKey.minSdkVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.additionalParameters, this.isMultiDex, this.minSdkVersion});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("dexKey", (Object)super.toString()).add("additionalParameters", this.additionalParameters).add("isMultiDex", (Object)this.isMultiDex).add("minSdkVersion", (Object)this.minSdkVersion).toString();
    }
}

