/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.FileCacheByPath;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.StoredEntryType;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class IncrementalRelativeFileSets {
    private IncrementalRelativeFileSets() {
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromDirectory(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"!directory.isDirectory()");
        return ImmutableMap.copyOf((Map)Maps.asMap(RelativeFiles.fromDirectory(directory), (Function)Functions.constant((Object)FileStatus.NEW)));
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip) throws IOException {
        return IncrementalRelativeFileSets.fromZip(zip, FileStatus.NEW);
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip, FileStatus status) throws IOException {
        Preconditions.checkArgument((boolean)zip.isFile(), (Object)"!zip.isFile()");
        return ImmutableMap.builder().putAll(Maps.asMap(RelativeFiles.fromZip(zip), f -> status)).build();
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip, FileCacheByPath cache, Set<Runnable> cacheUpdates) throws IOException {
        File oldFile = cache.get(zip);
        if (oldFile == null) {
            if (!zip.isFile()) {
                return ImmutableMap.of();
            }
            cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> cache.add(zip)));
            return IncrementalRelativeFileSets.fromZip(zip, FileStatus.NEW);
        }
        if (!zip.isFile()) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            try (ZFile zipReader = new ZFile(oldFile);){
                for (StoredEntry entry : zipReader.entries()) {
                    if (entry.getType() != StoredEntryType.FILE) continue;
                    builder.put((Object)new RelativeFile(zip, entry.getCentralDirectoryHeader().getName()), (Object)FileStatus.REMOVED);
                }
            }
            cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> cache.remove(zip)));
            return builder.build();
        }
        HashMap result = Maps.newHashMap();
        try (Closer closer = Closer.create();){
            String path;
            ZFile newZipReader = (ZFile)closer.register((Closeable)new ZFile(zip));
            ZFile oldZipReader = (ZFile)closer.register((Closeable)new ZFile(oldFile));
            for (StoredEntry entry : newZipReader.entries()) {
                path = entry.getCentralDirectoryHeader().getName();
                if (entry.getType() != StoredEntryType.FILE) continue;
                RelativeFile newRelative = new RelativeFile(zip, path);
                StoredEntry oldEntry = oldZipReader.get(path);
                if (oldEntry == null || oldEntry.getType() != StoredEntryType.FILE) {
                    result.put(newRelative, FileStatus.NEW);
                    continue;
                }
                if (oldEntry.getCentralDirectoryHeader().getCrc32() == entry.getCentralDirectoryHeader().getCrc32() && oldEntry.getCentralDirectoryHeader().getUncompressedSize() == entry.getCentralDirectoryHeader().getUncompressedSize()) continue;
                result.put(newRelative, FileStatus.CHANGED);
            }
            for (StoredEntry entry : oldZipReader.entries()) {
                path = entry.getCentralDirectoryHeader().getName();
                if (entry.getType() != StoredEntryType.FILE) continue;
                RelativeFile oldRelative = new RelativeFile(zip, path);
                StoredEntry newEntry = newZipReader.get(path);
                if (newEntry != null && newEntry.getType() == StoredEntryType.FILE) continue;
                result.put(oldRelative, FileStatus.REMOVED);
            }
        }
        cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> cache.add(zip)));
        return ImmutableMap.copyOf((Map)result);
    }

    public static ImmutableMap<RelativeFile, FileStatus> union(Iterable<ImmutableMap<RelativeFile, FileStatus>> sets) {
        HashMap map = Maps.newHashMap();
        for (ImmutableMap<RelativeFile, FileStatus> set : sets) {
            map.putAll(set);
        }
        return ImmutableMap.copyOf((Map)map);
    }

    public static int getBaseDirectoryCount(ImmutableMap<RelativeFile, FileStatus> set) {
        return set.keySet().stream().map(RelativeFile::getBase).filter((Predicate<File>)Files.isDirectory()).collect(Collectors.toSet()).size();
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZipsAndDirectories(Iterable<File> files) throws IOException {
        HashSet sets = Sets.newHashSet();
        for (File f : files) {
            if (f.isFile()) {
                sets.add(IncrementalRelativeFileSets.fromZip(f));
                continue;
            }
            sets.add(IncrementalRelativeFileSets.fromDirectory(f));
        }
        return IncrementalRelativeFileSets.union(sets);
    }

    public static ImmutableMap<RelativeFile, FileStatus> makeFromBaseFiles(Collection<File> baseFiles, Map<File, FileStatus> updates, FileCacheByPath cache, Set<Runnable> cacheUpdates, FileDeletionPolicy fileDeletionPolicy) throws IOException {
        for (File f : baseFiles) {
            Preconditions.checkArgument((boolean)f.exists(), (Object)"!f.exists()");
        }
        HashMap relativeUpdates = Maps.newHashMap();
        block1: for (Map.Entry<File, FileStatus> fileUpdate : updates.entrySet()) {
            File file = fileUpdate.getKey();
            FileStatus status = fileUpdate.getValue();
            if (fileDeletionPolicy == FileDeletionPolicy.DISALLOW_FILE_DELETIONS) {
                Preconditions.checkState((status != FileStatus.REMOVED ? 1 : 0) != 0, (Object)String.format("Changes include a deleted file ('%s'), which is not allowed.", file.getAbsolutePath()));
            }
            if (baseFiles.contains(file)) {
                relativeUpdates.putAll(IncrementalRelativeFileSets.fromZip(file, cache, cacheUpdates));
                continue;
            }
            if (file.isDirectory()) continue;
            for (File possibleBaseDirectory = file.getParentFile(); possibleBaseDirectory != null; possibleBaseDirectory = possibleBaseDirectory.getParentFile()) {
                if (!baseFiles.contains(possibleBaseDirectory)) continue;
                relativeUpdates.put(new RelativeFile(possibleBaseDirectory, file), status);
                continue block1;
            }
        }
        return ImmutableMap.copyOf((Map)relativeUpdates);
    }

    public static enum FileDeletionPolicy {
        ASSUME_NO_DELETED_DIRECTORIES,
        DISALLOW_FILE_DELETIONS;

    }
}

