/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.code.MoveType;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.FixedRegisterValue;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Move;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.RegisterMove;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RegisterMoveScheduler {
    private final Set<RegisterMove> moveSet = new TreeSet<RegisterMove>();
    private final Map<Integer, Integer> valueMap = new HashMap<Integer, Integer>();
    private int usedTempRegisters = 0;
    private final InstructionListIterator insertAt;
    private final Position position;
    private final int tempRegister;

    public RegisterMoveScheduler(InstructionListIterator insertAt, int tempRegister, Position position) {
        this.insertAt = insertAt;
        this.tempRegister = tempRegister;
        this.position = position;
    }

    public RegisterMoveScheduler(InstructionListIterator insertAt, int tempRegister) {
        this(insertAt, tempRegister, Position.none());
    }

    public void addMove(RegisterMove move) {
        this.moveSet.add(move);
        if (move.src != Integer.MIN_VALUE) {
            this.valueMap.put(move.src, move.src);
        }
        this.valueMap.put(move.dst, move.dst);
    }

    public void schedule() {
        RegisterMove move;
        LinkedList<RegisterMove> worklist = new LinkedList<RegisterMove>();
        Iterator<RegisterMove> iterator = this.moveSet.iterator();
        while (iterator.hasNext()) {
            move = iterator.next();
            if (move.isBlocked(this.moveSet, this.valueMap)) continue;
            worklist.addLast(move);
            iterator.remove();
        }
        while (!worklist.isEmpty() || !this.moveSet.isEmpty()) {
            while (!worklist.isEmpty()) {
                move = (RegisterMove)worklist.removeFirst();
                assert (!move.isBlocked(this.moveSet, this.valueMap));
                Integer generatedDest = this.createMove(move);
                if (move.src != Integer.MIN_VALUE) {
                    this.valueMap.put(move.src, generatedDest);
                }
                iterator = this.moveSet.iterator();
                while (iterator.hasNext()) {
                    RegisterMove other = iterator.next();
                    if (other.isBlocked(this.moveSet, this.valueMap)) continue;
                    worklist.addLast(other);
                    iterator.remove();
                }
            }
            if (this.moveSet.isEmpty()) continue;
            move = this.pickMoveToUnblock();
            this.createMoveDestToTemp(move);
            worklist.addLast(move);
        }
    }

    public int getUsedTempRegisters() {
        return this.usedTempRegisters;
    }

    private List<RegisterMove> findMovesWithSrc(int src, MoveType type) {
        ArrayList<RegisterMove> result = new ArrayList<RegisterMove>();
        assert (src != Integer.MIN_VALUE);
        for (RegisterMove move : this.moveSet) {
            if (move.src == Integer.MIN_VALUE) continue;
            int moveSrc = this.valueMap.get(move.src);
            if (moveSrc == src) {
                result.add(move);
                continue;
            }
            if (move.type == MoveType.WIDE && moveSrc + 1 == src) {
                result.add(move);
                continue;
            }
            if (type != MoveType.WIDE || moveSrc - 1 != src) continue;
            result.add(move);
        }
        return result;
    }

    private Integer createMove(RegisterMove move) {
        Instruction instruction;
        if (move.definition != null) {
            if (move.definition.isArgument()) {
                Argument argument = move.definition.asArgument();
                int argumentRegister = argument.outValue().getLiveIntervals().getRegister();
                FixedRegisterValue to = new FixedRegisterValue(argument.outType(), move.dst);
                FixedRegisterValue from = new FixedRegisterValue(argument.outType(), argumentRegister);
                instruction = new Move((Value)to, from);
            } else {
                ConstNumber number = move.definition.asConstNumber();
                FixedRegisterValue to = new FixedRegisterValue(number.outType(), move.dst);
                instruction = new ConstNumber((Value)to, number.getRawValue());
            }
        } else {
            FixedRegisterValue to = new FixedRegisterValue(move.type.toValueType(), move.dst);
            FixedRegisterValue from = new FixedRegisterValue(move.type.toValueType(), this.valueMap.get(move.src));
            instruction = new Move((Value)to, from);
        }
        instruction.setPosition(this.position);
        this.insertAt.add(instruction);
        return move.dst;
    }

    private void createMoveDestToTemp(RegisterMove move) {
        List<RegisterMove> movesWithSrc = this.findMovesWithSrc(move.dst, move.type);
        assert (movesWithSrc.size() > 0);
        for (RegisterMove moveWithSrc : movesWithSrc) {
            FixedRegisterValue to = new FixedRegisterValue(moveWithSrc.type.toValueType(), this.tempRegister + this.usedTempRegisters);
            FixedRegisterValue from = new FixedRegisterValue(moveWithSrc.type.toValueType(), this.valueMap.get(moveWithSrc.src));
            Move instruction = new Move((Value)to, from);
            instruction.setPosition(this.position);
            this.insertAt.add(instruction);
            this.valueMap.put(moveWithSrc.src, this.tempRegister + this.usedTempRegisters);
            this.usedTempRegisters += moveWithSrc.type == MoveType.WIDE ? 2 : 1;
        }
    }

    private RegisterMove pickMoveToUnblock() {
        Iterator<RegisterMove> iterator = this.moveSet.iterator();
        RegisterMove move = null;
        while (iterator.hasNext()) {
            move = iterator.next();
            if (move.type == MoveType.WIDE) continue;
        }
        iterator.remove();
        return move;
    }
}

