/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexByteCodeWriter;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.InternalOptions;
import java.io.PrintStream;

public class AssemblyWriter
extends DexByteCodeWriter {
    public AssemblyWriter(DexApplication application, InternalOptions options) {
        super(application, options);
    }

    @Override
    String getFileEnding() {
        return ".dump";
    }

    @Override
    void writeClassHeader(DexProgramClass clazz, PrintStream ps) {
        String clazzName = this.application.getProguardMap() != null ? this.application.getProguardMap().originalNameOf(clazz.type) : clazz.type.toSourceString();
        ps.println("# Bytecode for");
        ps.println("# Class: '" + clazzName + "'");
        ps.println();
    }

    @Override
    void writeField(DexEncodedField field, PrintStream ps) {
    }

    @Override
    void writeMethod(DexEncodedMethod method, PrintStream ps) {
        ClassNameMapper naming = this.application.getProguardMap();
        String methodName = naming != null ? naming.originalSignatureOf(method.method).toString() : method.method.name.toString();
        ps.println("#");
        ps.println("# Method: '" + methodName + "':");
        ps.println("#");
        ps.println();
        Code code = method.getCode();
        if (code != null) {
            ps.println(code.toString(method, naming));
        }
    }

    @Override
    void writeClassFooter(DexProgramClass clazz, PrintStream ps) {
    }
}

