/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.packaging;

import com.android.builder.packaging.ZipAbortException;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;

public final class DuplicateFileException
extends ZipAbortException {
    private static final long serialVersionUID = 1L;
    private final String mArchivePath;
    private final List<File> mSourceFiles;

    public DuplicateFileException(String archivePath, File ... sourceFiles) {
        this.mArchivePath = archivePath;
        this.mSourceFiles = ImmutableList.copyOf((Object[])sourceFiles);
    }

    public DuplicateFileException(String archivePath, List<File> sourceFiles) {
        this.mArchivePath = archivePath;
        this.mSourceFiles = ImmutableList.copyOf(sourceFiles);
    }

    public String getArchivePath() {
        return this.mArchivePath;
    }

    public List<File> getSourceFiles() {
        return this.mSourceFiles;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("APK File '").append(this.mArchivePath).append("' found in multiple sources:\n");
        int index = 1;
        for (File file : this.mSourceFiles) {
            sb.append("\tFile").append(index++).append(": ").append(file).append('\n');
        }
        return sb.toString();
    }
}

