/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.signing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.signing.SigningException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class SignedJarBuilder {
    private static final String DIGEST_ALGORITHM = "SHA1";
    private static final String DIGEST_ATTR = "SHA1-Digest";
    private static final String DIGEST_MANIFEST_ATTR = "SHA1-Digest-Manifest";
    private JarOutputStream mOutputJar;
    private PrivateKey mKey;
    private X509Certificate mCertificate;
    private Manifest mManifest;
    private MessageDigest mMessageDigest;
    private byte[] mBuffer = new byte[4096];

    public SignedJarBuilder(@NonNull OutputStream out, @Nullable PrivateKey key, @Nullable X509Certificate certificate, @Nullable String builtBy, @Nullable String createdBy) throws IOException, NoSuchAlgorithmException {
        this.mOutputJar = new JarOutputStream(new BufferedOutputStream(out));
        this.mOutputJar.setLevel(9);
        this.mKey = key;
        this.mCertificate = certificate;
        if (this.mKey != null && this.mCertificate != null) {
            this.mManifest = new Manifest();
            Attributes main = this.mManifest.getMainAttributes();
            main.putValue("Manifest-Version", "1.0");
            if (builtBy != null) {
                main.putValue("Built-By", builtBy);
            }
            if (createdBy != null) {
                main.putValue("Created-By", createdBy);
            }
            this.mMessageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File inputFile, String jarPath) throws IOException {
        FileInputStream fis = new FileInputStream(inputFile);
        try {
            JarEntry entry = new JarEntry(jarPath);
            entry.setTime(inputFile.lastModified());
            this.writeEntry(fis, entry);
        }
        finally {
            fis.close();
        }
    }

    public void writeZip(InputStream input) throws IOException, IZipEntryFilter.ZipAbortException {
        this.writeZip(input, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZip(InputStream input, IZipEntryFilter filter, ZipEntryExtractor extractor) throws IOException, IZipEntryFilter.ZipAbortException {
        ZipInputStream zis = new ZipInputStream(input);
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int index;
                String subName;
                String name = entry.getName();
                if (entry.isDirectory() || name.startsWith("META-INF/") && ("MANIFEST.MF".equals(subName = name.substring(9)) || name.startsWith("META-INF/maven/") || (index = subName.indexOf(47)) == -1 && (subName.endsWith(".SF") || name.endsWith(".RSA") || name.endsWith(".DSA")))) continue;
                if (extractor != null && extractor.checkEntry(name)) {
                    extractor.extract(name, zis);
                    continue;
                }
                if (filter != null && !filter.checkEntry(name)) continue;
                JarEntry newEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(name);
                this.writeEntry(zis, newEntry);
                zis.closeEntry();
            }
        }
        finally {
            zis.close();
        }
    }

    public void close() throws IOException, SigningException {
        if (this.mManifest != null) {
            this.mOutputJar.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
            this.mManifest.write(this.mOutputJar);
            try {
                Signature signature = Signature.getInstance("SHA1with" + this.mKey.getAlgorithm());
                signature.initSign(this.mKey);
                this.mOutputJar.putNextEntry(new JarEntry("META-INF/CERT.SF"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.writeSignatureFile(baos);
                byte[] signedData = baos.toByteArray();
                this.mOutputJar.write(signedData);
                this.mOutputJar.putNextEntry(new JarEntry("META-INF/CERT." + this.mKey.getAlgorithm()));
                this.writeSignatureBlock((CMSTypedData)new CMSProcessableByteArray(signedData), this.mCertificate, this.mKey);
            }
            catch (Exception e) {
                throw new SigningException(e);
            }
        }
        this.mOutputJar.close();
        this.mOutputJar = null;
    }

    public void cleanUp() {
        if (this.mOutputJar != null) {
            try {
                this.mOutputJar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeEntry(InputStream input, JarEntry entry) throws IOException {
        int count;
        this.mOutputJar.putNextEntry(entry);
        while ((count = input.read(this.mBuffer)) != -1) {
            this.mOutputJar.write(this.mBuffer, 0, count);
            if (this.mMessageDigest == null) continue;
            this.mMessageDigest.update(this.mBuffer, 0, count);
        }
        this.mOutputJar.closeEntry();
        if (this.mManifest != null) {
            Attributes attr = this.mManifest.getAttributes(entry.getName());
            if (attr == null) {
                attr = new Attributes();
                this.mManifest.getEntries().put(entry.getName(), attr);
            }
            attr.putValue(DIGEST_ATTR, new String(Base64.encode((byte[])this.mMessageDigest.digest()), "ASCII"));
        }
    }

    private void writeSignatureFile(OutputStream out) throws IOException, GeneralSecurityException {
        Manifest sf = new Manifest();
        Attributes main = sf.getMainAttributes();
        main.putValue("Signature-Version", "1.0");
        main.putValue("Created-By", "1.0 (Android)");
        MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
        PrintStream print = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), md), true, "UTF-8");
        this.mManifest.write(print);
        print.flush();
        main.putValue(DIGEST_MANIFEST_ATTR, new String(Base64.encode((byte[])md.digest()), "ASCII"));
        Map<String, Attributes> entries = this.mManifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            print.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> att : entry.getValue().entrySet()) {
                print.print(att.getKey() + ": " + att.getValue() + "\r\n");
            }
            print.print("\r\n");
            print.flush();
            Attributes sfAttr = new Attributes();
            sfAttr.putValue(DIGEST_ATTR, new String(Base64.encode((byte[])md.digest()), "ASCII"));
            sf.getEntries().put(entry.getKey(), sfAttr);
        }
        CountOutputStream cout = new CountOutputStream(out);
        sf.write(cout);
        if (cout.size() % 1024 == 0) {
            cout.write(13);
            cout.write(10);
        }
    }

    private void writeSignatureBlock(CMSTypedData data, X509Certificate publicKey, PrivateKey privateKey) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(publicKey);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1with" + privateKey.getAlgorithm()).build(privateKey);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).setDirectSignature(true).build(sha1Signer, publicKey));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate(data, false);
        ASN1InputStream asn1 = new ASN1InputStream(sigData.getEncoded());
        DEROutputStream dos = new DEROutputStream((OutputStream)this.mOutputJar);
        dos.writeObject((ASN1Encodable)asn1.readObject());
        dos.flush();
        dos.close();
        asn1.close();
    }

    public static interface ZipEntryExtractor {
        public boolean checkEntry(String var1);

        public void extract(String var1, InputStream var2) throws IOException;
    }

    public static interface IZipEntryFilter {
        public boolean checkEntry(String var1) throws ZipAbortException;

        public static class ZipAbortException
        extends Exception {
            private static final long serialVersionUID = 1L;

            public ZipAbortException() {
            }

            public ZipAbortException(String format, Object ... args) {
                super(String.format(format, args));
            }

            public ZipAbortException(Throwable cause, String format, Object ... args) {
                super(String.format(format, args), cause);
            }

            public ZipAbortException(Throwable cause) {
                super(cause);
            }
        }
    }

    private static class CountOutputStream
    extends FilterOutputStream {
        private int mCount = 0;

        public CountOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            ++this.mCount;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.mCount += len;
        }

        public int size() {
            return this.mCount;
        }
    }
}

