/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.bytestorage;

import com.google.common.base.Preconditions;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class TemporaryFile
implements Closeable {
    private boolean deleted = false;
    private final File file;

    public TemporaryFile(File file) {
        this.file = file;
    }

    public File getFile() {
        Preconditions.checkState((!this.deleted ? 1 : 0) != 0, (Object)"File already deleted");
        return this.file;
    }

    @Override
    public void close() throws IOException {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        this.deleteFile(this.file);
    }

    private void deleteFile(File file) throws IOException {
        if (file.exists()) {
            MoreFiles.deleteRecursively((Path)file.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

