/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.AaptResourceType;
import com.android.aaptcompiler.BlameLogger;
import com.android.aaptcompiler.BlameLoggerKt;
import com.android.aaptcompiler.ExtractedPackage;
import com.android.aaptcompiler.NamespaceContext;
import com.android.aaptcompiler.Reference;
import com.android.aaptcompiler.ReferenceInfo;
import com.android.aaptcompiler.ResourceFile;
import com.android.aaptcompiler.ResourceName;
import com.android.aaptcompiler.ResourceUtilsKt;
import com.android.aaptcompiler.Source;
import com.android.aaptcompiler.SourcedResourceName;
import com.android.aaptcompiler.UnicodeUtilKt;
import com.android.aaptcompiler.XmlProcessorKt;
import com.android.aaptcompiler.XmlResource;
import com.android.aaptcompiler.XmlResourceBuilder;
import com.android.aaptcompiler.XmlUtilKt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002JH\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0\u001aH\u0002J\u0016\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/JH\u00100\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0\u001a2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020'H\u0002JT\u00105\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020'0\u001a2\u0006\u00106\u001a\u00020'2\n\b\u0002\u00107\u001a\u0004\u0018\u000102H\u0002J\u0018\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020:2\u0006\u00104\u001a\u00020'H\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006;"}, d2={"Lcom/android/aaptcompiler/XmlProcessor;", "", "source", "Lcom/android/aaptcompiler/Source;", "logger", "Lcom/android/aaptcompiler/BlameLogger;", "(Lcom/android/aaptcompiler/Source;Lcom/android/aaptcompiler/BlameLogger;)V", "getLogger", "()Lcom/android/aaptcompiler/BlameLogger;", "<set-?>", "Lcom/android/aaptcompiler/ResourceFile;", "primaryFile", "getPrimaryFile", "()Lcom/android/aaptcompiler/ResourceFile;", "getSource", "()Lcom/android/aaptcompiler/Source;", "", "Lcom/android/aaptcompiler/XmlResource;", "xmlResources", "getXmlResources", "()Ljava/util/List;", "gatherIds", "", "startElement", "Ljavax/xml/stream/events/StartElement;", "collectedIds", "", "Lcom/android/aaptcompiler/ResourceName;", "Lcom/android/aaptcompiler/SourcedResourceName;", "getNextAttrResourceFile", "suffix", "", "element", "isAaptAttribute", "", "elName", "Ljavax/xml/namespace/QName;", "outlineAttribute", "parentBuilder", "Lcom/android/aaptcompiler/XmlResourceBuilder;", "attrElement", "eventReader", "Ljavax/xml/stream/XMLEventReader;", "resourceBuilders", "process", "file", "inputFile", "Ljava/io/InputStream;", "processAaptAttr", "namespaceContext", "Lcom/android/aaptcompiler/NamespaceContext;", "processComment", "builder", "processElement", "currentBuilder", "inheritedNamespaceContext", "processText", "characters", "Ljavax/xml/stream/events/Characters;", "aaptcompiler"})
@SourceDebugExtension(value={"SMAP\nXmlProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlProcessor.kt\ncom/android/aaptcompiler/XmlProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,536:1\n1045#2:537\n1549#2:538\n1620#2,3:539\n1855#2:542\n288#2,2:543\n1856#2:545\n*S KotlinDebug\n*F\n+ 1 XmlProcessor.kt\ncom/android/aaptcompiler/XmlProcessor\n*L\n135#1:537\n137#1:538\n137#1:539,3\n235#1:542\n236#1:543,2\n235#1:545\n*E\n"})
public final class XmlProcessor {
    @NotNull
    private final Source source;
    @Nullable
    private final BlameLogger logger;
    private ResourceFile primaryFile;
    @NotNull
    private List<XmlResource> xmlResources;

    public XmlProcessor(@NotNull Source source, @Nullable BlameLogger logger) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.logger = logger;
        this.xmlResources = CollectionsKt.emptyList();
    }

    @NotNull
    public final Source getSource() {
        return this.source;
    }

    @Nullable
    public final BlameLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final ResourceFile getPrimaryFile() {
        ResourceFile resourceFile = this.primaryFile;
        if (resourceFile != null) {
            return resourceFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"primaryFile");
        return null;
    }

    @NotNull
    public final List<XmlResource> getXmlResources() {
        return this.xmlResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void process(@NotNull ResourceFile file, @NotNull InputStream inputFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        this.primaryFile = file;
        XMLEventReader eventReader = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            eventReader = XmlUtilKt.getXmlInputFactory().createXMLEventReader(inputFile);
            Map collectedIds = new LinkedHashMap();
            Map protoBuilders = new LinkedHashMap();
            XMLEvent documentStart = eventReader.nextEvent();
            if (!documentStart.isStartDocument()) {
                throw new IllegalStateException(("Failed to find start of XML from " + BlameLoggerKt.blameSource$default(this.source, null, null, 6, null)).toString());
            }
            XMLEvent rootStart = null;
            while (eventReader.hasNext() && !(rootStart = eventReader.nextEvent()).isStartElement()) {
            }
            if (rootStart == null) {
                return;
            }
            XmlResourceBuilder builder = new XmlResourceBuilder(this.getPrimaryFile(), false, 2, null);
            protoBuilders.put(file, builder);
            StartElement startElement = rootStart.asStartElement();
            Intrinsics.checkNotNullExpressionValue((Object)startElement, (String)"rootStart.asStartElement()");
            XmlProcessor.processElement$default(this, startElement, eventReader, collectedIds, protoBuilders, builder, null, 32, null);
            Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)collectedIds.values());
            boolean $i$f$sortedBy = false;
            this.getPrimaryFile().getExportedSymbols().addAll(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SourcedResourceName it = (SourcedResourceName)a;
                    boolean bl = false;
                    Comparable comparable = it.getName();
                    it = (SourcedResourceName)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getName());
                }
            }));
            $this$sortedBy$iv = protoBuilders.values();
            XmlProcessor xmlProcessor = this;
            boolean $i$f$map = false;
            void var11_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                XmlResourceBuilder xmlResourceBuilder = (XmlResourceBuilder)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.build());
            }
            xmlProcessor.xmlResources = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator(this){
                final /* synthetic */ XmlProcessor this$0;
                {
                    this.this$0 = $receiver;
                }

                public final int compare(XmlResource left, XmlResource right) {
                    return left == right ? 0 : (left.getFile().getName() == this.this$0.getPrimaryFile().getName() ? -1 : (right.getFile().getName() == this.this$0.getPrimaryFile().getName() ? 1 : left.getFile().getName().compareTo(right.getFile().getName())));
                }
            });
        }
        catch (XMLStreamException xmlException) {
            String message;
            String string = xmlException.getMessage();
            if (string == null) {
                string = "";
            }
            if (!StringsKt.contains((CharSequence)(message = string), (CharSequence)"Premature end of file", (boolean)true)) {
                throw xmlException;
            }
        }
        finally {
            XMLEventReader xMLEventReader = eventReader;
            if (xMLEventReader != null) {
                xMLEventReader.close();
            }
        }
    }

    private final void processElement(StartElement startElement, XMLEventReader eventReader, Map<ResourceName, SourcedResourceName> collectedIds, Map<ResourceFile, XmlResourceBuilder> resourceBuilders, XmlResourceBuilder currentBuilder, NamespaceContext inheritedNamespaceContext) {
        XMLEvent nextEvent;
        QName qName = startElement.getName();
        Intrinsics.checkNotNullExpressionValue((Object)qName, (String)"startElement.name");
        if (this.isAaptAttribute(qName)) {
            Location location = startElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"startElement.location");
            RuntimeException exception = new RuntimeException(BlameLoggerKt.blameSource(this.source, location) + ": <aapt:attr> blocks are not allowed as the root of documents, or as a child element under another <aapt:attr>.");
            XmlUtilKt.walkToEndOfElement(startElement, eventReader);
            throw exception;
        }
        this.gatherIds(startElement, collectedIds);
        QName elementName = startElement.getName();
        Location elementLocation = startElement.getLocation();
        String string = elementName.getLocalPart();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"elementName.localPart");
        String string2 = elementName.getNamespaceURI();
        if (string2 == null) {
            string2 = "";
        }
        currentBuilder.startElement(string, string2, elementLocation.getLineNumber(), elementLocation.getColumnNumber());
        Iterator<Namespace> namespaceDeclarations = startElement.getNamespaces();
        List namespaces = new ArrayList();
        while (namespaceDeclarations.hasNext()) {
            Namespace namespace = namespaceDeclarations.next();
            Intrinsics.checkNotNull((Object)namespace, (String)"null cannot be cast to non-null type javax.xml.stream.events.Namespace");
            namespaces.add(namespace);
        }
        Object object = inheritedNamespaceContext;
        if (object != null && (object = ((NamespaceContext)object).namespacePrefixes()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object v6;
                String prefix;
                block12: {
                    prefix = (String)element$iv;
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = namespaces;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Namespace ns = (Namespace)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)ns.getPrefix(), (Object)prefix)) continue;
                        v6 = element$iv2;
                        break block12;
                    }
                    v6 = null;
                }
                if (v6 != null) continue;
                String string3 = inheritedNamespaceContext.uriForPrefix(prefix);
                Intrinsics.checkNotNull((Object)string3);
                XmlResourceBuilder.addNamespaceDeclaration$default(currentBuilder, string3, prefix, 0, 0, 12, null);
            }
        }
        for (Namespace namespace : namespaces) {
            String string4 = namespace.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"namespace.namespaceURI");
            String string5 = namespace.getPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"namespace.prefix");
            currentBuilder.addNamespaceDeclaration(string4, string5, elementLocation.getLineNumber(), elementLocation.getColumnNumber());
        }
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute;
            Intrinsics.checkNotNull((Object)attributes.next(), (String)"null cannot be cast to non-null type javax.xml.stream.events.Attribute");
            QName attrName = attribute.getName();
            String string6 = attrName.getLocalPart();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"attrName.localPart");
            String string7 = attrName.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"attrName.namespaceURI");
            String string8 = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"attribute.value");
            currentBuilder.addAttribute(string6, string7, string8, elementLocation.getLineNumber(), elementLocation.getColumnNumber());
        }
        while (eventReader.hasNext() && !(nextEvent = eventReader.nextEvent()).isEndElement()) {
            if (nextEvent.isStartElement()) {
                QName elName = nextEvent.asStartElement().getName();
                Intrinsics.checkNotNullExpressionValue((Object)elName, (String)"elName");
                if (this.isAaptAttribute(elName)) {
                    StartElement startElement2 = nextEvent.asStartElement();
                    Intrinsics.checkNotNullExpressionValue((Object)startElement2, (String)"nextEvent.asStartElement()");
                    this.outlineAttribute(currentBuilder, startElement2, eventReader, collectedIds, resourceBuilders);
                    continue;
                }
                StartElement startElement3 = nextEvent.asStartElement();
                Intrinsics.checkNotNullExpressionValue((Object)startElement3, (String)"nextEvent.asStartElement()");
                XmlProcessor.processElement$default(this, startElement3, eventReader, collectedIds, resourceBuilders, currentBuilder, null, 32, null);
                continue;
            }
            if (nextEvent.isCharacters()) {
                Characters characters = nextEvent.asCharacters();
                Intrinsics.checkNotNullExpressionValue((Object)characters, (String)"nextEvent.asCharacters()");
                this.processText(characters, currentBuilder);
            }
            if (nextEvent.getEventType() != 5) continue;
            this.processComment(currentBuilder);
        }
        currentBuilder.endElement();
    }

    static /* synthetic */ void processElement$default(XmlProcessor xmlProcessor, StartElement startElement, XMLEventReader xMLEventReader, Map map, Map map2, XmlResourceBuilder xmlResourceBuilder, NamespaceContext namespaceContext, int n, Object object) {
        if ((n & 0x20) != 0) {
            namespaceContext = null;
        }
        xmlProcessor.processElement(startElement, xMLEventReader, map, map2, xmlResourceBuilder, namespaceContext);
    }

    private final void outlineAttribute(XmlResourceBuilder parentBuilder, StartElement attrElement, XMLEventReader eventReader, Map<ResourceName, SourcedResourceName> collectedIds, Map<ResourceFile, XmlResourceBuilder> resourceBuilders) {
        Attribute nameAttribute = attrElement.getAttributeByName(new QName("name"));
        if (nameAttribute == null) {
            Location location = attrElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"attrElement.location");
            RuntimeException exception = new RuntimeException(BlameLoggerKt.blameSource(this.source, location) + ":<" + attrElement.getName() + "> tag requires the 'name' attribute.");
            XmlUtilKt.walkToEndOfElement(attrElement, eventReader);
            throw exception;
        }
        String string = nameAttribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameAttribute.value");
        Reference reference = ResourceUtilsKt.parseXmlAttributeName(string);
        ResourceName nameValue = reference.getName();
        String string2 = nameValue.getPck();
        Intrinsics.checkNotNull((Object)string2);
        ExtractedPackage extractedPackage = XmlUtilKt.transformPackageAlias(attrElement, string2);
        if (extractedPackage == null) {
            Location location = attrElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"attrElement.location");
            RuntimeException exception = new RuntimeException(BlameLoggerKt.blameSource(this.source, location) + "Invalid namespace prefix '" + nameValue.getPck() + "' for value of 'name' attribute '" + nameValue + "'.");
            XmlUtilKt.walkToEndOfElement(attrElement, eventReader);
            throw exception;
        }
        boolean isPrivateNs = extractedPackage.isPrivate() || reference.isPrivate();
        CharSequence charSequence = nameValue.getPck();
        String attrUri = charSequence == null || charSequence.length() == 0 ? "" : (((CharSequence)extractedPackage.getPackageName()).length() == 0 ? "http://schemas.android.com/apk/res-auto" : XmlUtilKt.constructPackageUri(extractedPackage.getPackageName(), isPrivateNs));
        ResourceFile resource = this.processAaptAttr(attrElement, eventReader, collectedIds, resourceBuilders, parentBuilder.getNamespaceContext());
        String string3 = nameValue.getEntry();
        Intrinsics.checkNotNull((Object)string3);
        if (parentBuilder.findAttribute(string3, attrUri) != null) {
            throw new IllegalStateException(("Cannot find attribute " + nameValue.getEntry()).toString());
        }
        parentBuilder.addAttribute(nameValue.getEntry(), attrUri, "@" + resource.getName(), attrElement.getLocation().getLineNumber(), attrElement.getLocation().getColumnNumber());
    }

    private final boolean isAaptAttribute(QName elName) {
        return Intrinsics.areEqual((Object)elName.getNamespaceURI(), (Object)"http://schemas.android.com/aapt") && Intrinsics.areEqual((Object)elName.getLocalPart(), (Object)"attr");
    }

    private final ResourceFile processAaptAttr(StartElement startElement, XMLEventReader eventReader, Map<ResourceName, SourcedResourceName> collectedIds, Map<ResourceFile, XmlResourceBuilder> resourceBuilders, NamespaceContext namespaceContext) {
        XMLEvent event;
        ResourceFile outputFile = this.getNextAttrResourceFile(resourceBuilders.size() - 1, startElement);
        XmlResourceBuilder outputBuilder = new XmlResourceBuilder(outputFile, false, 2, null);
        resourceBuilders.put(outputFile, outputBuilder);
        List errors = new ArrayList();
        boolean foundChild = false;
        while (eventReader.hasNext() && !(event = eventReader.nextEvent()).isEndElement()) {
            Collection collection;
            if (event.isCharacters()) {
                if (event.asCharacters().isWhiteSpace()) continue;
                collection = errors;
                Location location = event.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"event.location");
                collection.add(BlameLoggerKt.blameSource(this.source, location) + ": Can't extract text into its own resource.");
                continue;
            }
            if (!event.isStartElement()) continue;
            if (foundChild) {
                collection = errors;
                Location location = event.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"event.location");
                collection.add(BlameLoggerKt.blameSource(this.source, location) + ": Inline XML resources must have a single root.");
                StartElement startElement2 = event.asStartElement();
                Intrinsics.checkNotNullExpressionValue((Object)startElement2, (String)"event.asStartElement()");
                XmlUtilKt.walkToEndOfElement(startElement2, eventReader);
                continue;
            }
            foundChild = true;
            StartElement startElement3 = event.asStartElement();
            Intrinsics.checkNotNullExpressionValue((Object)startElement3, (String)"event.asStartElement()");
            this.processElement(startElement3, eventReader, collectedIds, resourceBuilders, outputBuilder, namespaceContext);
        }
        if (!foundChild) {
            Location location = startElement.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"startElement.location");
            String string = BlameLoggerKt.blameSource(this.source, location) + ": No resource to outline. <" + startElement.getName() + "> block is empty.";
            throw new IllegalStateException(string.toString());
        }
        if (CollectionsKt.any((Iterable)errors)) {
            throw new IllegalStateException(CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)",", null, null, (int)0, null, null, (int)62, null).toString());
        }
        return outputFile;
    }

    private final XmlResourceBuilder processText(Characters characters, XmlResourceBuilder builder) {
        String string = characters.getData();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"characters.data");
        return XmlResourceBuilder.addText$default(builder, string, 0, 0, 6, null);
    }

    private final XmlResourceBuilder processComment(XmlResourceBuilder builder) {
        return builder.addComment();
    }

    private final void gatherIds(StartElement startElement, Map<ResourceName, SourcedResourceName> collectedIds) {
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute;
            Intrinsics.checkNotNull((Object)iterator.next(), (String)"null cannot be cast to non-null type javax.xml.stream.events.Attribute");
            String string = attribute.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.value");
            ReferenceInfo parsedRef = ResourceUtilsKt.parseReference(string);
            if (parsedRef == null) continue;
            ResourceName resourceName = parsedRef.getReference().getName();
            if (!parsedRef.getCreateNew() || resourceName.getType() != AaptResourceType.ID) continue;
            String string2 = resourceName.getEntry();
            Intrinsics.checkNotNull((Object)string2);
            if (!UnicodeUtilKt.isValidResourceEntryName(string2)) {
                Location location = startElement.getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"startElement.location");
                String string3 = BlameLoggerKt.blameSource(this.source, location) + " Id '" + resourceName + "' has an invalid entry name '" + resourceName.getEntry() + "'.";
                throw new IllegalStateException(string3.toString());
            }
            collectedIds.putIfAbsent(resourceName, new SourcedResourceName(resourceName, startElement.getLocation().getLineNumber()));
        }
    }

    private final ResourceFile getNextAttrResourceFile(int suffix, StartElement element) {
        String newEntryName = XmlProcessorKt.access$mangleEntry("", this.getPrimaryFile().getName().getEntry() + "__" + suffix);
        return new ResourceFile(ResourceName.copy$default(this.getPrimaryFile().getName(), null, null, newEntryName, 3, null), this.getPrimaryFile().getConfiguration(), this.getPrimaryFile().getSource().withLine(element.getLocation().getLineNumber()), ResourceFile.Type.ProtoXml, null, 16, null);
    }
}

