/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.AllowNew;
import com.android.aaptcompiler.AttributeResource;
import com.android.aaptcompiler.BlameLogger;
import com.android.aaptcompiler.BlameLoggerKt;
import com.android.aaptcompiler.ConfigDescription;
import com.android.aaptcompiler.FileReference;
import com.android.aaptcompiler.OverlayableItem;
import com.android.aaptcompiler.ResourceConfigValue;
import com.android.aaptcompiler.ResourceEntry;
import com.android.aaptcompiler.ResourceFileKt;
import com.android.aaptcompiler.ResourceGroup;
import com.android.aaptcompiler.ResourceName;
import com.android.aaptcompiler.ResourceTable;
import com.android.aaptcompiler.ResourceTablePackage;
import com.android.aaptcompiler.Source;
import com.android.aaptcompiler.StringPool;
import com.android.aaptcompiler.UnicodeUtilKt;
import com.android.aaptcompiler.Value;
import com.android.aaptcompiler.Visibility;
import com.android.resources.ResourceVisibility;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 R2\u00020\u0001:\u0003QRSB\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\nJF\u0010 \u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$H\u0002J.\u0010%\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"J&\u0010&\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)J^\u0010*\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$2\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020.0-H\u0002J&\u0010/\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)J.\u00100\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)J.\u00101\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)J\u001a\u00102\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\n2\b\b\u0002\u0010+\u001a\u000203J\u0016\u00104\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010+\u001a\u000203J\u0010\u00105\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0010\u00106\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\nJ\u0010\u00107\u001a\u0004\u0018\u00010\u000f2\u0006\u0010+\u001a\u000203J\u0010\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010:\u001a\u00020;2\b\u0010\u001d\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020\nH\u0002J\u0016\u0010>\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020@J,\u0010A\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020@2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$H\u0002J\u0016\u0010B\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010?\u001a\u00020@J\u0016\u0010C\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020EJ,\u0010F\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020E2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$H\u0002J\u0016\u0010G\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020EJ\u0016\u0010H\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020JJ4\u0010K\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020J2\u0006\u0010+\u001a\u00020\t2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$H\u0002J\u0016\u0010L\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020JJ\u001e\u0010M\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020J2\u0006\u0010+\u001a\u00020\tJ\u001e\u0010N\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010I\u001a\u00020J2\u0006\u0010+\u001a\u00020\tJ\u0006\u0010O\u001a\u00020;J,\u0010P\u001a\u00020\u00032\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006T"}, d2={"Lcom/android/aaptcompiler/ResourceTable;", "", "validateResources", "", "logger", "Lcom/android/aaptcompiler/BlameLogger;", "(ZLcom/android/aaptcompiler/BlameLogger;)V", "includedPackages", "", "", "", "getLogger", "()Lcom/android/aaptcompiler/BlameLogger;", "packages", "", "Lcom/android/aaptcompiler/ResourceTablePackage;", "getPackages$aaptcompiler", "()Ljava/util/List;", "stringPool", "Lcom/android/aaptcompiler/StringPool;", "getStringPool", "()Lcom/android/aaptcompiler/StringPool;", "getValidateResources", "()Z", "addFileReference", "name", "Lcom/android/aaptcompiler/ResourceName;", "config", "Lcom/android/aaptcompiler/ConfigDescription;", "source", "Lcom/android/aaptcompiler/Source;", "path", "addFileReferenceImpl", "file", "Ljava/io/File;", "nameValidator", "Lkotlin/Function1;", "addFileReferenceMangled", "addResource", "product", "value", "Lcom/android/aaptcompiler/Value;", "addResourceImpl", "id", "conflictResolver", "Lkotlin/Function2;", "Lcom/android/aaptcompiler/ResourceTable$CollisionResult;", "addResourceMangled", "addResourceWithId", "addResourceWithIdMangled", "createPackage", "", "createPackageAllowingDuplicateNames", "findOrCreatePackage", "findPackage", "findPackageById", "findResource", "Lcom/android/aaptcompiler/ResourceTable$SearchResult;", "logError", "", "Lcom/android/aaptcompiler/BlameLogger$Source;", "message", "setAllowNew", "allowNew", "Lcom/android/aaptcompiler/AllowNew;", "setAllowNewImpl", "setAllowNewMangled", "setOverlayable", "overlayable", "Lcom/android/aaptcompiler/OverlayableItem;", "setOverlayableImpl", "setOverlayableMangled", "setVisibility", "visibility", "Lcom/android/aaptcompiler/Visibility;", "setVisibilityImpl", "setVisibilityMangled", "setVisibilityWithId", "setVisibilityWithIdMangled", "sort", "validateName", "CollisionResult", "Companion", "SearchResult", "aaptcompiler"})
public final class ResourceTable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean validateResources;
    @Nullable
    private final BlameLogger logger;
    @NotNull
    private final StringPool stringPool;
    @NotNull
    private final List<ResourceTablePackage> packages;
    @NotNull
    private final Map<Integer, String> includedPackages;

    public ResourceTable(boolean validateResources, @Nullable BlameLogger logger) {
        this.validateResources = validateResources;
        this.logger = logger;
        this.stringPool = new StringPool();
        this.packages = new ArrayList();
        this.includedPackages = new LinkedHashMap();
    }

    public /* synthetic */ ResourceTable(boolean bl, BlameLogger blameLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            blameLogger = null;
        }
        this(bl, blameLogger);
    }

    public final boolean getValidateResources() {
        return this.validateResources;
    }

    @Nullable
    public final BlameLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final StringPool getStringPool() {
        return this.stringPool;
    }

    @NotNull
    public final List<ResourceTablePackage> getPackages$aaptcompiler() {
        return this.packages;
    }

    public final boolean addResource(@NotNull ResourceName name, @NotNull ConfigDescription config, @NotNull String product, @NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.addResourceImpl(name, 0, config, product, value, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).resourceNameValidator(p0);
            }
        }), (Function2<? super Value, ? super Value, ? extends CollisionResult>)((Function2)new Function2<Value, Value, CollisionResult>((Object)Companion){

            @NotNull
            public final CollisionResult invoke(@NotNull Value p0, @NotNull Value p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Companion)this.receiver).resolveValueCollision(p0, p1);
            }
        }));
    }

    public final boolean addResourceWithId(@NotNull ResourceName name, int id, @NotNull ConfigDescription config, @NotNull String product, @NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.addResourceImpl(name, id, config, product, value, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).resourceNameValidator(p0);
            }
        }), (Function2<? super Value, ? super Value, ? extends CollisionResult>)((Function2)new Function2<Value, Value, CollisionResult>((Object)Companion){

            @NotNull
            public final CollisionResult invoke(@NotNull Value p0, @NotNull Value p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Companion)this.receiver).resolveValueCollision(p0, p1);
            }
        }));
    }

    public final boolean addFileReference(@NotNull ResourceName name, @NotNull ConfigDescription config, @NotNull Source source, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.addFileReferenceImpl(name, config, source, path, null, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).resourceNameValidator(p0);
            }
        }));
    }

    public final boolean addFileReferenceMangled(@NotNull ResourceName name, @NotNull ConfigDescription config, @NotNull Source source, @NotNull String path, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.addFileReferenceImpl(name, config, source, path, file, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).skipNameValidator(p0);
            }
        }));
    }

    public final boolean addResourceMangled(@NotNull ResourceName name, @NotNull ConfigDescription config, @NotNull String product, @NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.addResourceImpl(name, 0, config, product, value, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).skipNameValidator(p0);
            }
        }), (Function2<? super Value, ? super Value, ? extends CollisionResult>)((Function2)new Function2<Value, Value, CollisionResult>((Object)Companion){

            @NotNull
            public final CollisionResult invoke(@NotNull Value p0, @NotNull Value p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Companion)this.receiver).resolveValueCollision(p0, p1);
            }
        }));
    }

    public final boolean addResourceWithIdMangled(@NotNull ResourceName name, int id, @NotNull ConfigDescription config, @NotNull String product, @NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)product, (String)"product");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.addResourceImpl(name, id, config, product, value, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).skipNameValidator(p0);
            }
        }), (Function2<? super Value, ? super Value, ? extends CollisionResult>)((Function2)new Function2<Value, Value, CollisionResult>((Object)Companion){

            @NotNull
            public final CollisionResult invoke(@NotNull Value p0, @NotNull Value p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Companion)this.receiver).resolveValueCollision(p0, p1);
            }
        }));
    }

    public final boolean setVisibility(@NotNull ResourceName name, @NotNull Visibility visibility) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        return this.setVisibilityImpl(name, visibility, 0, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).resourceNameValidator(p0);
            }
        }));
    }

    public final boolean setVisibilityWithId(@NotNull ResourceName name, @NotNull Visibility visibility, int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        return this.setVisibilityImpl(name, visibility, id, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).resourceNameValidator(p0);
            }
        }));
    }

    public final boolean setVisibilityMangled(@NotNull ResourceName name, @NotNull Visibility visibility) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        return this.setVisibilityImpl(name, visibility, 0, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).skipNameValidator(p0);
            }
        }));
    }

    public final boolean setVisibilityWithIdMangled(@NotNull ResourceName name, @NotNull Visibility visibility, int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        return this.setVisibilityImpl(name, visibility, id, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).skipNameValidator(p0);
            }
        }));
    }

    public final boolean setAllowNew(@NotNull ResourceName name, @NotNull AllowNew allowNew) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)allowNew, (String)"allowNew");
        return this.setAllowNewImpl(name, allowNew, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).resourceNameValidator(p0);
            }
        }));
    }

    public final boolean setAllowNewMangled(@NotNull ResourceName name, @NotNull AllowNew allowNew) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)allowNew, (String)"allowNew");
        return this.setAllowNewImpl(name, allowNew, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).skipNameValidator(p0);
            }
        }));
    }

    public final boolean setOverlayable(@NotNull ResourceName name, @NotNull OverlayableItem overlayable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)overlayable, (String)"overlayable");
        return this.setOverlayableImpl(name, overlayable, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).resourceNameValidator(p0);
            }
        }));
    }

    public final boolean setOverlayableMangled(@NotNull ResourceName name, @NotNull OverlayableItem overlayable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)overlayable, (String)"overlayable");
        return this.setOverlayableImpl(name, overlayable, (Function1<? super String, String>)((Function1)new Function1<String, String>((Object)Companion){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((Companion)this.receiver).skipNameValidator(p0);
            }
        }));
    }

    @Nullable
    public final SearchResult findResource(@NotNull ResourceName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.getPck();
        Intrinsics.checkNotNull((Object)string);
        ResourceTablePackage tablePackage = this.findPackage(string);
        if (tablePackage == null) {
            return null;
        }
        ResourceGroup group = ResourceTablePackage.findGroup$default(tablePackage, name.getType(), null, 2, null);
        if (group == null) {
            return null;
        }
        String string2 = name.getEntry();
        Intrinsics.checkNotNull((Object)string2);
        ResourceEntry entry = ResourceGroup.findEntry$default(group, string2, null, 2, null);
        if (entry == null) {
            return null;
        }
        return new SearchResult(tablePackage, group, entry);
    }

    @Nullable
    public final ResourceTablePackage findPackage(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.packages;
            for (Object t : iterable) {
                ResourceTablePackage it = (ResourceTablePackage)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final ResourceTablePackage findPackageById(byte id) {
        Object v2;
        block1: {
            Iterable iterable = this.packages;
            for (Object t : iterable) {
                ResourceTablePackage it = (ResourceTablePackage)t;
                boolean bl = false;
                Byte by = it.getId();
                boolean bl2 = by != null ? by == id : false;
                if (!bl2) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    public final ResourceTablePackage createPackage(@NotNull String name, byte id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ResourceTablePackage tablePackage = this.findOrCreatePackage(name);
        if (id != 0) {
            if (tablePackage.getId() == null) {
                tablePackage.setId(id);
                return tablePackage;
            }
            Byte by = tablePackage.getId();
            if (!(by != null ? by == id : false)) {
                return null;
            }
        }
        return tablePackage;
    }

    public static /* synthetic */ ResourceTablePackage createPackage$default(ResourceTable resourceTable, String string, byte by, int n, Object object) {
        if ((n & 2) != 0) {
            by = 0;
        }
        return resourceTable.createPackage(string, by);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ResourceTablePackage createPackageAllowingDuplicateNames(@NotNull String name, byte id) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            var5_3 = this.packages;
            for (T var7_5 : var5_3) {
                it = (ResourceTablePackage)var7_5;
                $i$a$-find-ResourceTable$createPackageAllowingDuplicateNames$match$1 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) ** GOTO lbl-1000
                v0 = it.getId();
                v1 = v0 != null ? v0 == id : false;
                if (v1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = var7_5;
                break block4;
            }
            v3 = null;
        }
        match = v3;
        if (match != null) {
            return match;
        }
        newPackage = new ResourceTablePackage(name, id);
        this.packages.add(newPackage);
        return newPackage;
    }

    /*
     * WARNING - void declaration
     */
    private final ResourceTablePackage findOrCreatePackage(String name) {
        ResourceTablePackage resourceTablePackage;
        ResourceTablePackage tablePackage = this.findPackage(name);
        if (tablePackage == null) {
            void var3_3;
            ResourceTablePackage newPackage = new ResourceTablePackage(null, null, 3, null);
            newPackage.setName(name);
            this.packages.add(newPackage);
            resourceTablePackage = var3_3;
        } else {
            resourceTablePackage = tablePackage;
        }
        return resourceTablePackage;
    }

    public final void sort() {
        Function1[] function1Array = new Function1[]{sort.1.INSTANCE, sort.2.INSTANCE};
        CollectionsKt.sortWith(this.packages, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        for (ResourceTablePackage pkg : this.packages) {
            Function1[] function1Array2 = new Function1[]{sort.3.INSTANCE, sort.4.INSTANCE};
            CollectionsKt.sortWith(pkg.getGroups$aaptcompiler(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array2));
            for (ResourceGroup group : pkg.getGroups$aaptcompiler()) {
                for (SortedMap<Short, ResourceEntry> entryByName : group.getEntries$aaptcompiler().values()) {
                    for (ResourceEntry entry : entryByName.values()) {
                        Function1[] function1Array3 = new Function1[]{sort.5.INSTANCE, sort.6.INSTANCE};
                        CollectionsKt.sortWith(entry.getValues$aaptcompiler(), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array3));
                    }
                }
            }
        }
    }

    private final void logError(BlameLogger.Source source, String message) {
        block0: {
            BlameLogger blameLogger = this.logger;
            if (blameLogger == null) break block0;
            BlameLogger.error$default(blameLogger, message, source, null, 4, null);
        }
    }

    private final boolean validateName(Function1<? super String, String> nameValidator, ResourceName name, Source source) {
        String string = name.getEntry();
        Intrinsics.checkNotNull((Object)string);
        String badCodePoint = (String)nameValidator.invoke((Object)string);
        if (((CharSequence)badCodePoint).length() > 0) {
            this.logError(BlameLoggerKt.blameSource$default(source, null, null, 6, null), "Resource '" + name + "' has invalid entry name '" + name.getEntry() + "'. Invalid character '" + badCodePoint + "'.");
            return false;
        }
        return true;
    }

    private final boolean addResourceImpl(ResourceName name, int id, ConfigDescription config, String product, Value value, Function1<? super String, String> nameValidator, Function2<? super Value, ? super Value, ? extends CollisionResult> conflictResolver) {
        Source source = value.getSource();
        if (!this.validateName(nameValidator, name, source)) {
            return false;
        }
        String string = name.getPck();
        Intrinsics.checkNotNull((Object)string);
        ResourceTablePackage tablePackage = this.findOrCreatePackage(string);
        Byte packageId = tablePackage.getId();
        if (ResourceFileKt.isValidDynamicId(id) && packageId != null && !(ResourceFileKt.getPackageId(id) == packageId)) {
            BlameLogger.Source source2 = BlameLoggerKt.blameSource$default(value.getSource(), null, null, 6, null);
            String string2 = Integer.toString(id, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
            String string3 = tablePackage.getName();
            String string4 = Integer.toString(packageId.byteValue(), CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this, checkRadix(radix))");
            this.logError(source2, "Failed to add resource '" + name + "' with ID " + string2 + " because package '" + string3 + "' already has ID " + string4 + ".");
            return false;
        }
        boolean checkId = this.validateResources && ResourceFileKt.isValidDynamicId(id);
        boolean useId = !this.validateResources && ResourceFileKt.isValidDynamicId(id);
        ResourceGroup resourceGroup = tablePackage.findOrCreateGroup(name.getType(), useId ? Byte.valueOf(ResourceFileKt.getTypeId(id)) : null);
        Byte groupId = resourceGroup.getId();
        if (checkId && groupId != null && !(groupId == ResourceFileKt.getTypeId(id))) {
            BlameLogger.Source source3 = BlameLoggerKt.blameSource$default(value.getSource(), null, null, 6, null);
            String string5 = Integer.toString(id, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
            String string6 = resourceGroup.getType().getTagName();
            String string7 = Integer.toString(groupId.byteValue(), CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(this, checkRadix(radix))");
            this.logError(source3, "Failed to add resource '" + name + "' with ID " + string5 + " because type '" + string6 + "' already has ID " + string7 + ".");
            return false;
        }
        String string8 = name.getEntry();
        Intrinsics.checkNotNull((Object)string8);
        ResourceEntry resourceEntry = resourceGroup.findOrCreateEntry(string8, useId ? Short.valueOf(ResourceFileKt.getEntryId(id)) : null);
        Short entryId = resourceEntry.getId();
        if (checkId && entryId != null && !(ResourceFileKt.getEntryId(id) == entryId)) {
            BlameLogger.Source source4 = BlameLoggerKt.blameSource$default(value.getSource(), null, null, 6, null);
            String string9 = Integer.toString(id, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(this, checkRadix(radix))");
            Byte by = packageId;
            Intrinsics.checkNotNull((Object)by);
            byte by2 = by;
            Byte by3 = groupId;
            Intrinsics.checkNotNull((Object)by3);
            String string10 = Integer.toString(ResourceFileKt.resourceIdFromParts(by2, by3, entryId), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(this, checkRadix(radix))");
            this.logError(source4, "Failed to add resource '" + name + "' with ID " + string9 + ", because resource already has ID " + string10 + ".");
            return false;
        }
        ResourceConfigValue configValue = resourceEntry.findOrCreateValue(config, product);
        Value oldValue = configValue.getValue();
        if (oldValue == null) {
            configValue.setValue(value);
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[((CollisionResult)((Object)conflictResolver.invoke((Object)oldValue, (Object)value))).ordinal()]) {
                case 1: {
                    configValue.setValue(value);
                    break;
                }
                case 2: {
                    Object object = this.logger;
                    if (object == null || (object = ((BlameLogger)object).getOriginalSource(BlameLoggerKt.blameSource$default(oldValue.getSource(), null, null, 6, null))) == null) {
                        object = BlameLoggerKt.blameSource$default(oldValue.getSource(), null, null, 6, null);
                    }
                    Object previousSource = object;
                    this.logError(BlameLoggerKt.blameSource$default(value.getSource(), null, null, 6, null), "Duplicate value for resource '" + name + "' with config '" + config + "' and product '" + product + "'. Resource was previously defined here: " + (BlameLogger.Source)previousSource + ".");
                    return false;
                }
            }
        }
        if (ResourceFileKt.isValidDynamicId(id)) {
            tablePackage.setId(ResourceFileKt.getPackageId(id));
            resourceGroup.setId(ResourceFileKt.getTypeId(id));
            resourceEntry.setId(ResourceFileKt.getEntryId(id));
        }
        return true;
    }

    private final boolean addFileReferenceImpl(ResourceName name, ConfigDescription config, Source source, String path, File file, Function1<? super String, String> nameValidator) {
        FileReference fileReference = new FileReference(StringPool.makeRef$default(this.stringPool, path, null, 2, null));
        fileReference.setSource(source);
        fileReference.setFile(file);
        return this.addResourceImpl(name, 0, config, "", fileReference, nameValidator, (Function2<? super Value, ? super Value, ? extends CollisionResult>)((Function2)new Function2<Value, Value, CollisionResult>((Object)Companion){

            @NotNull
            public final CollisionResult invoke(@NotNull Value p0, @NotNull Value p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((Companion)this.receiver).resolveValueCollision(p0, p1);
            }
        }));
    }

    private final boolean setVisibilityImpl(ResourceName name, Visibility visibility, int id, Function1<? super String, String> nameValidator) {
        Source source = visibility.getSource();
        if (!this.validateName(nameValidator, name, source)) {
            return false;
        }
        String string = name.getPck();
        Intrinsics.checkNotNull((Object)string);
        ResourceTablePackage tablePackage = this.findOrCreatePackage(string);
        Byte packageId = tablePackage.getId();
        if (ResourceFileKt.isValidDynamicId(id) && packageId != null && !(ResourceFileKt.getPackageId(id) == packageId)) {
            BlameLogger.Source source2 = BlameLoggerKt.blameSource$default(source, null, null, 6, null);
            String string2 = Integer.toString(id, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
            String string3 = tablePackage.getName();
            String string4 = Integer.toString(packageId.byteValue(), CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(this, checkRadix(radix))");
            this.logError(source2, "Failed to add resource '" + name + "' with ID " + string2 + " because package '" + string3 + "' already has ID " + string4 + ".");
            return false;
        }
        boolean checkId = this.validateResources && ResourceFileKt.isValidDynamicId(id);
        boolean useId = !this.validateResources && ResourceFileKt.isValidDynamicId(id);
        ResourceGroup resourceGroup = tablePackage.findOrCreateGroup(name.getType(), useId ? Byte.valueOf(ResourceFileKt.getTypeId(id)) : null);
        Byte groupId = resourceGroup.getId();
        if (checkId && groupId != null && !(groupId == ResourceFileKt.getTypeId(id))) {
            BlameLogger.Source source3 = BlameLoggerKt.blameSource$default(source, null, null, 6, null);
            String string5 = Integer.toString(id, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(this, checkRadix(radix))");
            String string6 = resourceGroup.getType().getTagName();
            String string7 = Integer.toString(groupId.byteValue(), CharsKt.checkRadix((int)CharsKt.checkRadix((int)16)));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(this, checkRadix(radix))");
            this.logError(source3, "Failed to add resource '" + name + "' with ID " + string5 + " because type '" + string6 + "' already has ID " + string7 + ".");
            return false;
        }
        String string8 = name.getEntry();
        Intrinsics.checkNotNull((Object)string8);
        ResourceEntry resourceEntry = resourceGroup.findOrCreateEntry(string8, useId ? Short.valueOf(ResourceFileKt.getEntryId(id)) : null);
        Short entryId = resourceEntry.getId();
        if (checkId && entryId != null && !(ResourceFileKt.getEntryId(id) == entryId)) {
            BlameLogger.Source source4 = BlameLoggerKt.blameSource$default(source, null, null, 6, null);
            String string9 = Integer.toString(id, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(this, checkRadix(radix))");
            Byte by = packageId;
            Intrinsics.checkNotNull((Object)by);
            byte by2 = by;
            Byte by3 = groupId;
            Intrinsics.checkNotNull((Object)by3);
            String string10 = Integer.toString(ResourceFileKt.resourceIdFromParts(by2, by3, entryId), CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(this, checkRadix(radix))");
            this.logError(source4, "Failed to add resource '" + name + "' with ID " + string9 + ", because resource already has ID " + string10 + ".");
            return false;
        }
        if (ResourceFileKt.isValidDynamicId(id)) {
            tablePackage.setId(ResourceFileKt.getPackageId(id));
            resourceGroup.setId(ResourceFileKt.getTypeId(id));
            resourceEntry.setId(ResourceFileKt.getEntryId(id));
        }
        if (visibility.getLevel() == ResourceVisibility.PUBLIC) {
            resourceGroup.setVisibility(ResourceVisibility.PUBLIC);
        }
        if (visibility.getLevel() != ResourceVisibility.UNDEFINED || resourceEntry.getVisibility().getLevel() == ResourceVisibility.UNDEFINED) {
            if (visibility.getLevel() == ResourceVisibility.PRIVATE && resourceEntry.getVisibility().getLevel() == ResourceVisibility.PUBLIC) {
                this.logError(BlameLoggerKt.blameSource$default(source, null, null, 6, null), "Failed to add resource '" + name + "' as private (java-symbol) because it was previously defined as public.");
                return false;
            }
            if (visibility.getLevel() == ResourceVisibility.PUBLIC && resourceEntry.getVisibility().getLevel() == ResourceVisibility.PRIVATE) {
                this.logError(BlameLoggerKt.blameSource$default(source, null, null, 6, null), "Failed to add resource '" + name + "' as public because it was previously defined as private (java-symbol).");
                return false;
            }
            resourceEntry.setVisibility(visibility);
        }
        return true;
    }

    private final boolean setAllowNewImpl(ResourceName name, AllowNew allowNew, Function1<? super String, String> nameValidator) {
        if (!this.validateName(nameValidator, name, allowNew.getSource())) {
            return false;
        }
        String string = name.getPck();
        Intrinsics.checkNotNull((Object)string);
        ResourceTablePackage tablePackage = this.findOrCreatePackage(string);
        ResourceGroup group = ResourceTablePackage.findOrCreateGroup$default(tablePackage, name.getType(), null, 2, null);
        String string2 = name.getEntry();
        Intrinsics.checkNotNull((Object)string2);
        ResourceEntry entry = ResourceGroup.findOrCreateEntry$default(group, string2, null, 2, null);
        entry.setAllowNew(allowNew);
        return true;
    }

    private final boolean setOverlayableImpl(ResourceName name, OverlayableItem overlayable, Function1<? super String, String> nameValidator) {
        if (!this.validateName(nameValidator, name, overlayable.getSource())) {
            return false;
        }
        String string = name.getPck();
        Intrinsics.checkNotNull((Object)string);
        ResourceTablePackage tablePackage = this.findOrCreatePackage(string);
        ResourceGroup group = ResourceTablePackage.findOrCreateGroup$default(tablePackage, name.getType(), null, 2, null);
        String string2 = name.getEntry();
        Intrinsics.checkNotNull((Object)string2);
        ResourceEntry entry = ResourceGroup.findOrCreateEntry$default(group, string2, null, 2, null);
        OverlayableItem oldEntry = entry.getOverlayable();
        if (oldEntry != null) {
            Object object = this.logger;
            if (object == null || (object = ((BlameLogger)object).getOriginalSource(BlameLoggerKt.blameSource$default(oldEntry.getSource(), null, null, 6, null))) == null) {
                object = BlameLoggerKt.blameSource$default(oldEntry.getSource(), null, null, 6, null);
            }
            Object previousSource = object;
            this.logError(BlameLoggerKt.blameSource$default(overlayable.getSource(), null, null, 6, null), "Failed to add overlayable declaration for resource '" + name + "', because resource already has an overlayable defined here: " + (BlameLogger.Source)previousSource + ".");
            return false;
        }
        entry.setOverlayable(overlayable);
        return true;
    }

    public ResourceTable() {
        this(false, null, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/aaptcompiler/ResourceTable$CollisionResult;", "", "(Ljava/lang/String;I)V", "KEEP_ORIGINAL", "CONFLICT", "TAKE_NEW", "aaptcompiler"})
    public static final class CollisionResult
    extends Enum<CollisionResult> {
        public static final /* enum */ CollisionResult KEEP_ORIGINAL = new CollisionResult();
        public static final /* enum */ CollisionResult CONFLICT = new CollisionResult();
        public static final /* enum */ CollisionResult TAKE_NEW = new CollisionResult();
        private static final /* synthetic */ CollisionResult[] $VALUES;

        public static CollisionResult[] values() {
            return (CollisionResult[])$VALUES.clone();
        }

        public static CollisionResult valueOf(String value) {
            return Enum.valueOf(CollisionResult.class, value);
        }

        static {
            $VALUES = collisionResultArray = new CollisionResult[]{CollisionResult.KEEP_ORIGINAL, CollisionResult.CONFLICT, CollisionResult.TAKE_NEW};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/android/aaptcompiler/ResourceTable$SearchResult;", "", "tablePackage", "Lcom/android/aaptcompiler/ResourceTablePackage;", "group", "Lcom/android/aaptcompiler/ResourceGroup;", "entry", "Lcom/android/aaptcompiler/ResourceEntry;", "(Lcom/android/aaptcompiler/ResourceTablePackage;Lcom/android/aaptcompiler/ResourceGroup;Lcom/android/aaptcompiler/ResourceEntry;)V", "getEntry", "()Lcom/android/aaptcompiler/ResourceEntry;", "getGroup", "()Lcom/android/aaptcompiler/ResourceGroup;", "getTablePackage", "()Lcom/android/aaptcompiler/ResourceTablePackage;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "aaptcompiler"})
    public static final class SearchResult {
        @NotNull
        private final ResourceTablePackage tablePackage;
        @NotNull
        private final ResourceGroup group;
        @NotNull
        private final ResourceEntry entry;

        public SearchResult(@NotNull ResourceTablePackage tablePackage, @NotNull ResourceGroup group, @NotNull ResourceEntry entry) {
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.tablePackage = tablePackage;
            this.group = group;
            this.entry = entry;
        }

        @NotNull
        public final ResourceTablePackage getTablePackage() {
            return this.tablePackage;
        }

        @NotNull
        public final ResourceGroup getGroup() {
            return this.group;
        }

        @NotNull
        public final ResourceEntry getEntry() {
            return this.entry;
        }

        @NotNull
        public final ResourceTablePackage component1() {
            return this.tablePackage;
        }

        @NotNull
        public final ResourceGroup component2() {
            return this.group;
        }

        @NotNull
        public final ResourceEntry component3() {
            return this.entry;
        }

        @NotNull
        public final SearchResult copy(@NotNull ResourceTablePackage tablePackage, @NotNull ResourceGroup group, @NotNull ResourceEntry entry) {
            Intrinsics.checkNotNullParameter((Object)tablePackage, (String)"tablePackage");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            return new SearchResult(tablePackage, group, entry);
        }

        public static /* synthetic */ SearchResult copy$default(SearchResult searchResult, ResourceTablePackage resourceTablePackage, ResourceGroup resourceGroup, ResourceEntry resourceEntry, int n, Object object) {
            if ((n & 1) != 0) {
                resourceTablePackage = searchResult.tablePackage;
            }
            if ((n & 2) != 0) {
                resourceGroup = searchResult.group;
            }
            if ((n & 4) != 0) {
                resourceEntry = searchResult.entry;
            }
            return searchResult.copy(resourceTablePackage, resourceGroup, resourceEntry);
        }

        @NotNull
        public String toString() {
            return "SearchResult(tablePackage=" + this.tablePackage + ", group=" + this.group + ", entry=" + this.entry + ")";
        }

        public int hashCode() {
            int result = this.tablePackage.hashCode();
            result = result * 31 + this.group.hashCode();
            result = result * 31 + this.entry.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SearchResult)) {
                return false;
            }
            SearchResult searchResult = (SearchResult)other;
            if (!Intrinsics.areEqual((Object)this.tablePackage, (Object)searchResult.tablePackage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.group, (Object)searchResult.group)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.entry, (Object)searchResult.entry);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcom/android/aaptcompiler/ResourceTable$Companion;", "", "()V", "resolveValueCollision", "Lcom/android/aaptcompiler/ResourceTable$CollisionResult;", "existing", "Lcom/android/aaptcompiler/Value;", "incoming", "resourceNameValidator", "", "name", "skipNameValidator", "aaptcompiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CollisionResult resolveValueCollision(@NotNull Value existing, @NotNull Value incoming) {
            Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
            Intrinsics.checkNotNullParameter((Object)incoming, (String)"incoming");
            AttributeResource existingAttr = existing instanceof AttributeResource ? (AttributeResource)existing : null;
            AttributeResource incomingAttr = incoming instanceof AttributeResource ? (AttributeResource)incoming : null;
            if (incomingAttr == null) {
                return incoming.getWeak() ? CollisionResult.KEEP_ORIGINAL : (existing.getWeak() ? CollisionResult.TAKE_NEW : CollisionResult.CONFLICT);
            }
            if (existingAttr == null) {
                return existing.getWeak() ? CollisionResult.TAKE_NEW : CollisionResult.CONFLICT;
            }
            if (existingAttr.isCompatibleWith(incomingAttr)) {
                return existingAttr.getWeak() ? CollisionResult.TAKE_NEW : CollisionResult.KEEP_ORIGINAL;
            }
            if (existingAttr.getWeak() && existingAttr.getTypeMask() == 65535) {
                return CollisionResult.TAKE_NEW;
            }
            if (incomingAttr.getWeak() && incomingAttr.getTypeMask() == 65535) {
                return CollisionResult.KEEP_ORIGINAL;
            }
            return CollisionResult.CONFLICT;
        }

        @NotNull
        public final String resourceNameValidator(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return UnicodeUtilKt.isValidResourceEntryName(name) ? "" : name;
        }

        @NotNull
        public final String skipNameValidator(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return "";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CollisionResult.values().length];
            nArray[CollisionResult.TAKE_NEW.ordinal()] = 1;
            nArray[CollisionResult.CONFLICT.ordinal()] = 2;
            nArray[CollisionResult.KEEP_ORIGINAL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

