/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import java.util.Iterator;
import javax.xml.namespace.QName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"XLIFF_NS_URI", "", "parseFormatAttribute", "", "value", "parseFormatNoEnumsOrFlags", "name", "parseFormatType", "shouldIgnoreElement", "", "elementName", "Ljavax/xml/namespace/QName;", "aaptcompiler"})
public final class TableExtractorKt {
    @NotNull
    private static final String XLIFF_NS_URI = "urn:oasis:names:tc:xliff:document:1.2";

    public static final boolean shouldIgnoreElement(@NotNull QName elementName) {
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        CharSequence charSequence = elementName.getNamespaceURI();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"elementName.namespaceURI");
        charSequence = charSequence;
        boolean bl = false;
        return charSequence.length() == 0 && (Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"skip") || Intrinsics.areEqual((Object)elementName.getLocalPart(), (Object)"eat-comment"));
    }

    public static final int parseFormatNoEnumsOrFlags(@NotNull String name) {
        int n;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        switch (name) {
            case "reference": {
                n = 1;
                break;
            }
            case "string": {
                n = 2;
                break;
            }
            case "integer": {
                n = 4;
                break;
            }
            case "boolean": {
                n = 8;
                break;
            }
            case "color": {
                n = 16;
                break;
            }
            case "float": {
                n = 32;
                break;
            }
            case "dimension": {
                n = 64;
                break;
            }
            case "fraction": {
                n = 128;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static final int parseFormatType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        return Intrinsics.areEqual((Object)string, (Object)"enum") ? 65536 : (Intrinsics.areEqual((Object)string, (Object)"flags") ? 131072 : TableExtractorKt.parseFormatNoEnumsOrFlags(name));
    }

    public static final int parseFormatAttribute(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int mask = 0;
        char[] cArray = new char[]{'|'};
        Iterator iterator = StringsKt.split$default((CharSequence)value, (char[])cArray, (boolean)false, (int)0, (int)6, null).iterator();
        while (iterator.hasNext()) {
            String part;
            String string = part = (String)iterator.next();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            int type = TableExtractorKt.parseFormatType(((Object)StringsKt.trim((CharSequence)string2)).toString());
            if (type == 0) {
                return 0;
            }
            mask |= type;
        }
        return mask;
    }
}

