/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.Instrumentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.UserHandle;
import android.support.annotation.Nullable;
import android.support.test.InstrumentationRegistry;
import android.support.test.internal.runner.InstrumentationConnection;
import android.support.test.internal.runner.RunnerArgs;
import android.support.test.internal.runner.hidden.ExposedInstrumentationApi;
import android.support.test.internal.runner.intent.IntentMonitorImpl;
import android.support.test.internal.runner.intercepting.DefaultInterceptingActivityFactory;
import android.support.test.internal.runner.lifecycle.ActivityLifecycleMonitorImpl;
import android.support.test.internal.runner.lifecycle.ApplicationLifecycleMonitorImpl;
import android.support.test.internal.util.Checks;
import android.support.test.internal.util.ProcessUtil;
import android.support.test.runner.intent.IntentMonitorRegistry;
import android.support.test.runner.intent.IntentStubberRegistry;
import android.support.test.runner.intercepting.InterceptingActivityFactory;
import android.support.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import android.support.test.runner.lifecycle.ApplicationLifecycleMonitorRegistry;
import android.support.test.runner.lifecycle.ApplicationStage;
import android.support.test.runner.lifecycle.Stage;
import android.util.Log;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MonitoringInstrumentation
extends ExposedInstrumentationApi {
    private static final String TAG = "MonitoringInstr";
    private static final long MILLIS_TO_WAIT_FOR_ACTIVITY_TO_STOP = TimeUnit.SECONDS.toMillis(2L);
    private static final long MILLIS_TO_POLL_FOR_ACTIVITY_STOP = MILLIS_TO_WAIT_FOR_ACTIVITY_TO_STOP / 40L;
    private static final int START_ACTIVITY_TIMEOUT_SECONDS = 45;
    private ActivityLifecycleMonitorImpl mLifecycleMonitor = new ActivityLifecycleMonitorImpl();
    private ApplicationLifecycleMonitorImpl mApplicationMonitor = new ApplicationLifecycleMonitorImpl();
    private IntentMonitorImpl mIntentMonitor = new IntentMonitorImpl();
    private ExecutorService mExecutorService;
    private Handler mHandlerForMainLooper;
    private AtomicBoolean mAnActivityHasBeenLaunched = new AtomicBoolean(false);
    private AtomicLong mLastIdleTime = new AtomicLong(0L);
    private AtomicInteger mStartedActivityCounter = new AtomicInteger(0);
    private String mJsBridgeClassName;
    private AtomicBoolean mIsJsBridgeLoaded = new AtomicBoolean(false);
    private ThreadLocal<Boolean> mIsDexmakerClassLoaderInitialized = new ThreadLocal();
    private MessageQueue.IdleHandler mIdleHandler = new MessageQueue.IdleHandler(){

        public boolean queueIdle() {
            MonitoringInstrumentation.this.mLastIdleTime.set(System.currentTimeMillis());
            return true;
        }
    };
    private volatile boolean mFinished = false;
    private volatile InterceptingActivityFactory mInterceptingActivityFactory;

    public void onCreate(Bundle arguments) {
        String currentProcessName = ProcessUtil.getCurrentProcessName(this.getTargetContext());
        String string = String.valueOf(currentProcessName);
        Log.i((String)TAG, (String)(string.length() != 0 ? "Instrumentation started on process ".concat(string) : new String("Instrumentation started on process ")));
        this.logUncaughtExceptions();
        this.installMultidex();
        InstrumentationRegistry.registerInstance(this, arguments);
        ActivityLifecycleMonitorRegistry.registerInstance(this.mLifecycleMonitor);
        ApplicationLifecycleMonitorRegistry.registerInstance(this.mApplicationMonitor);
        IntentMonitorRegistry.registerInstance(this.mIntentMonitor);
        this.mHandlerForMainLooper = new Handler(Looper.getMainLooper());
        boolean corePoolSize = false;
        long keepAliveTime = 0L;
        this.mExecutorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(this){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setName(MonitoringInstrumentation.class.getSimpleName());
                return thread;
            }
        });
        Looper.myQueue().addIdleHandler(this.mIdleHandler);
        super.onCreate(arguments);
        this.specifyDexMakerCacheProperty();
        this.setupDexmakerClassloader();
        this.useDefaultInterceptingActivityFactory();
    }

    protected void installMultidex() {
        if (Build.VERSION.SDK_INT < 21) {
            try {
                Class<?> multidex = Class.forName("android.support.multidex.MultiDex");
                try {
                    Method installInstrumentation = multidex.getDeclaredMethod("installInstrumentation", Context.class, Context.class);
                    installInstrumentation.invoke(null, this.getContext(), this.getTargetContext());
                }
                catch (NoSuchMethodException nsme) {
                    this.installOldMultiDex(multidex);
                }
            }
            catch (ClassNotFoundException ignored) {
                Log.i((String)TAG, (String)"No multidex.");
            }
            catch (NoSuchMethodException nsme) {
                Log.i((String)TAG, (String)"No multidex.", (Throwable)nsme);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException("multidex is available at runtime, but calling it failed.", ite);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("multidex is available at runtime, but calling it failed.", iae);
            }
        }
    }

    protected void installOldMultiDex(Class<?> multidexClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method install = multidexClass.getDeclaredMethod("install", Context.class);
        install.invoke(null, this.getTargetContext());
    }

    protected final void specifyDexMakerCacheProperty() {
        File dexCache = this.getTargetContext().getDir("dxmaker_cache", 0);
        System.getProperties().put("dexmaker.dexcache", dexCache.getAbsolutePath());
    }

    protected final void setJsBridgeClassName(String className) {
        if (null == className) {
            throw new NullPointerException("JsBridge class name cannot be null!");
        }
        if (this.mIsJsBridgeLoaded.get()) {
            throw new IllegalStateException("JsBridge is already loaded!");
        }
        this.mJsBridgeClassName = className;
    }

    private void setupDexmakerClassloader() {
        if (Boolean.TRUE.equals(this.mIsDexmakerClassLoaderInitialized.get())) {
            return;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newClassLoader = this.getTargetContext().getClassLoader();
        Log.i((String)TAG, (String)String.format("Setting context classloader to '%s', Original: '%s'", newClassLoader.toString(), originalClassLoader.toString()));
        Thread.currentThread().setContextClassLoader(newClassLoader);
        this.mIsDexmakerClassLoaderInitialized.set(Boolean.TRUE);
    }

    private void logUncaughtExceptions() {
        final Thread.UncaughtExceptionHandler standardHandler = Thread.currentThread().getUncaughtExceptionHandler();
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                MonitoringInstrumentation.this.onException(t, e);
                if (null != standardHandler) {
                    standardHandler.uncaughtException(t, e);
                }
            }
        });
    }

    public void onStart() {
        super.onStart();
        if (this.mJsBridgeClassName != null) {
            this.tryLoadingJsBridge(this.mJsBridgeClassName);
        }
        this.waitForIdleSync();
        this.setupDexmakerClassloader();
        InstrumentationConnection.getInstance().init(this, new ActivityFinisher());
    }

    public void finish(int resultCode, Bundle results) {
        if (this.mFinished) {
            Log.w((String)TAG, (String)"finish called 2x!");
            return;
        }
        this.mFinished = true;
        this.mHandlerForMainLooper.post((Runnable)new ActivityFinisher());
        long startTime = System.currentTimeMillis();
        this.waitForActivitiesToComplete();
        long endTime = System.currentTimeMillis();
        Log.i((String)TAG, (String)String.format("waitForActivitiesToComplete() took: %sms", endTime - startTime));
        ActivityLifecycleMonitorRegistry.registerInstance(null);
        super.finish(resultCode, results);
    }

    protected void waitForActivitiesToComplete() {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            throw new IllegalStateException("Cannot be called from main thread!");
        }
        long endTime = System.currentTimeMillis() + MILLIS_TO_WAIT_FOR_ACTIVITY_TO_STOP;
        int currentActivityCount = this.mStartedActivityCounter.get();
        while (currentActivityCount > 0 && System.currentTimeMillis() < endTime) {
            try {
                int n = currentActivityCount;
                Log.i((String)TAG, (String)new StringBuilder(37).append("Unstopped activity count: ").append(n).toString());
                Thread.sleep(MILLIS_TO_POLL_FOR_ACTIVITY_STOP);
                currentActivityCount = this.mStartedActivityCounter.get();
            }
            catch (InterruptedException ie) {
                Log.i((String)TAG, (String)"Abandoning activity wait due to interruption.", (Throwable)ie);
                break;
            }
        }
        if (currentActivityCount > 0) {
            this.dumpThreadStateToOutputs("ThreadState-unstopped.txt");
            Log.w((String)TAG, (String)String.format("Still %s activities active after waiting %s ms.", currentActivityCount, MILLIS_TO_WAIT_FOR_ACTIVITY_TO_STOP));
        }
    }

    public void onDestroy() {
        Log.i((String)TAG, (String)"Instrumentation Finished!");
        Looper.myQueue().removeIdleHandler(this.mIdleHandler);
        InstrumentationConnection.getInstance().terminate();
        super.onDestroy();
    }

    public void callApplicationOnCreate(Application app) {
        this.mApplicationMonitor.signalLifecycleChange(app, ApplicationStage.PRE_ON_CREATE);
        super.callApplicationOnCreate(app);
        this.mApplicationMonitor.signalLifecycleChange(app, ApplicationStage.CREATED);
    }

    public Activity startActivitySync(final Intent intent) {
        Checks.checkNotMainThread();
        long lastIdleTimeBeforeLaunch = this.mLastIdleTime.get();
        if (this.mAnActivityHasBeenLaunched.compareAndSet(false, true)) {
            intent.addFlags(0x4000000);
        }
        Future<Activity> startedActivity = this.mExecutorService.submit(new Callable<Activity>(){

            @Override
            public Activity call() {
                return MonitoringInstrumentation.super.startActivitySync(intent);
            }
        });
        try {
            return startedActivity.get(45L, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            this.dumpThreadStateToOutputs("ThreadState-startActivityTimeout.txt");
            startedActivity.cancel(true);
            throw new RuntimeException(String.format("Could not launch intent %s within %s seconds. Perhaps the main thread has not gone idle within a reasonable amount of time? There could be an animation or something constantly repainting the screen. Or the activity is doing network calls on creation? See the threaddump logs. For your reference the last time the event queue was idle before your activity launch request was %s and now the last time the queue went idle was: %s. If these numbers are the same your activity might be hogging the event queue.", intent, 45, lastIdleTimeBeforeLaunch, this.mLastIdleTime.get()));
        }
        catch (ExecutionException ee) {
            throw new RuntimeException("Could not launch activity", ee.getCause());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", ie);
        }
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode) {
        Log.d((String)TAG, (String)"execStartActivity(context, ibinder, ibinder, activity, intent, int)");
        this.mIntentMonitor.signalIntent(intent);
        Instrumentation.ActivityResult ar = this.stubResultFor(intent);
        if (ar != null) {
            Log.i((String)TAG, (String)String.format("Stubbing intent %s", intent));
            return ar;
        }
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options) {
        Log.d((String)TAG, (String)"execStartActivity(context, ibinder, ibinder, activity, intent, int, bundle");
        this.mIntentMonitor.signalIntent(intent);
        Instrumentation.ActivityResult ar = this.stubResultFor(intent);
        if (ar != null) {
            Log.i((String)TAG, (String)String.format("Stubbing intent %s", intent));
            return ar;
        }
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, String target, Intent intent, int requestCode, Bundle options) {
        Log.d((String)TAG, (String)"execStartActivities(context, ibinder, ibinder, fragmentTarget, intent,requestCode, bundle)");
        this.mIntentMonitor.signalIntent(intent);
        Instrumentation.ActivityResult ar = this.stubResultFor(intent);
        if (ar != null) {
            Log.i((String)TAG, (String)String.format("Stubbing intent %s", intent));
            return ar;
        }
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Activity target, Intent intent, int requestCode, Bundle options, UserHandle user) {
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode, options, user);
    }

    public void execStartActivities(Context who, IBinder contextThread, IBinder token, Activity target, Intent[] intents, Bundle options) {
        Log.d((String)TAG, (String)"execStartActivities(context, ibinder, ibinder, activity, intent[], bundle)");
        int requestCode = -1;
        for (Intent intent : intents) {
            this.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
        }
    }

    public Instrumentation.ActivityResult execStartActivity(Context who, IBinder contextThread, IBinder token, Fragment target, Intent intent, int requestCode, Bundle options) {
        Log.d((String)TAG, (String)"execStartActivity(context, IBinder, IBinder, Fragment, Intent, int, Bundle)");
        this.mIntentMonitor.signalIntent(intent);
        Instrumentation.ActivityResult ar = this.stubResultFor(intent);
        if (ar != null) {
            Log.i((String)TAG, (String)String.format("Stubbing intent %s", intent));
            return ar;
        }
        return super.execStartActivity(who, contextThread, token, target, intent, requestCode, options);
    }

    private Instrumentation.ActivityResult stubResultFor(Intent intent) {
        if (IntentStubberRegistry.isLoaded()) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                FutureTask<Instrumentation.ActivityResult> task = new FutureTask<Instrumentation.ActivityResult>(new StubResultCallable(intent));
                this.runOnMainSync(task);
                try {
                    return task.get();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(String.format("Could not retrieve stub result for intent %s", intent), e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            return IntentStubberRegistry.getInstance().getActivityResultForIntent(intent);
        }
        return null;
    }

    public boolean onException(Object obj, Throwable e) {
        String error = String.format("Exception encountered by: %s. Dumping thread state to outputs and pining for the fjords.", obj);
        Log.e((String)TAG, (String)error, (Throwable)e);
        this.dumpThreadStateToOutputs("ThreadState-onException.txt");
        Log.e((String)TAG, (String)"Dying now...");
        return super.onException(obj, e);
    }

    protected void dumpThreadStateToOutputs(String outputFileName) {
        String threadState = this.getThreadState();
        Log.e((String)"THREAD_STATE", (String)threadState);
    }

    protected String getThreadState() {
        Set<Map.Entry<Thread, StackTraceElement[]>> threads = Thread.getAllStackTraces().entrySet();
        StringBuilder threadState = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> threadAndStack : threads) {
            StringBuilder threadMessage = new StringBuilder("  ").append(threadAndStack.getKey());
            threadMessage.append("\n");
            for (StackTraceElement ste : threadAndStack.getValue()) {
                threadMessage.append("    ");
                threadMessage.append(ste.toString());
                threadMessage.append("\n");
            }
            threadMessage.append("\n");
            threadState.append(threadMessage.toString());
        }
        return threadState.toString();
    }

    public void callActivityOnDestroy(Activity activity) {
        super.callActivityOnDestroy(activity);
        this.mLifecycleMonitor.signalLifecycleChange(Stage.DESTROYED, activity);
    }

    public void callActivityOnRestart(Activity activity) {
        super.callActivityOnRestart(activity);
        this.mLifecycleMonitor.signalLifecycleChange(Stage.RESTARTED, activity);
    }

    public void callActivityOnCreate(Activity activity, Bundle bundle) {
        this.mLifecycleMonitor.signalLifecycleChange(Stage.PRE_ON_CREATE, activity);
        super.callActivityOnCreate(activity, bundle);
        this.mLifecycleMonitor.signalLifecycleChange(Stage.CREATED, activity);
    }

    public void callActivityOnStart(Activity activity) {
        this.mStartedActivityCounter.incrementAndGet();
        try {
            super.callActivityOnStart(activity);
            this.mLifecycleMonitor.signalLifecycleChange(Stage.STARTED, activity);
        }
        catch (RuntimeException re) {
            this.mStartedActivityCounter.decrementAndGet();
            throw re;
        }
    }

    public void callActivityOnStop(Activity activity) {
        try {
            super.callActivityOnStop(activity);
            this.mLifecycleMonitor.signalLifecycleChange(Stage.STOPPED, activity);
        }
        finally {
            this.mStartedActivityCounter.decrementAndGet();
        }
    }

    public void callActivityOnResume(Activity activity) {
        super.callActivityOnResume(activity);
        this.mLifecycleMonitor.signalLifecycleChange(Stage.RESUMED, activity);
    }

    public void callActivityOnPause(Activity activity) {
        super.callActivityOnPause(activity);
        this.mLifecycleMonitor.signalLifecycleChange(Stage.PAUSED, activity);
    }

    public Activity newActivity(Class<?> clazz, Context context, IBinder token, Application application, Intent intent, ActivityInfo info, CharSequence title, Activity parent, String id, Object lastNonConfigurationInstance) throws InstantiationException, IllegalAccessException {
        ComponentName intentComponentName;
        String activityClassPackageName = clazz.getPackage().getName();
        String contextPackageName = context.getPackageName();
        if (!contextPackageName.equals((intentComponentName = intent.getComponent()).getPackageName()) && activityClassPackageName.equals(intentComponentName.getPackageName())) {
            intent.setComponent(new ComponentName(contextPackageName, intentComponentName.getClassName()));
        }
        return super.newActivity(clazz, context, token, application, intent, info, title, parent, id, lastNonConfigurationInstance);
    }

    public Activity newActivity(ClassLoader cl, String className, Intent intent) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return this.mInterceptingActivityFactory.shouldIntercept(cl, className, intent) ? this.mInterceptingActivityFactory.create(cl, className, intent) : super.newActivity(cl, className, intent);
    }

    public void interceptActivityUsing(InterceptingActivityFactory interceptingActivityFactory) {
        Checks.checkNotNull(interceptingActivityFactory);
        this.mInterceptingActivityFactory = interceptingActivityFactory;
    }

    public void useDefaultInterceptingActivityFactory() {
        this.mInterceptingActivityFactory = new DefaultInterceptingActivityFactory();
    }

    private void tryLoadingJsBridge(final String className) {
        if (null == className) {
            throw new NullPointerException("JsBridge class name cannot be null!");
        }
        this.runOnMainSync(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> jsBridge = Class.forName(className);
                    Method install = jsBridge.getDeclaredMethod("installBridge", new Class[0]);
                    install.invoke(null, new Object[0]);
                    MonitoringInstrumentation.this.mIsJsBridgeLoaded.set(true);
                }
                catch (ClassNotFoundException | NoSuchMethodException ignored) {
                    Log.i((String)MonitoringInstrumentation.TAG, (String)"No JSBridge.");
                }
                catch (IllegalAccessException | InvocationTargetException ite) {
                    throw new RuntimeException("JSbridge is available at runtime, but calling it failed.", ite);
                }
            }
        });
    }

    protected static void reflectivelyInvokeRemoteMethod(RunnerArgs.TestArg methodName) {
        if (null == methodName) {
            throw new NullPointerException("Method name cannot be null!");
        }
        String string = String.valueOf(methodName);
        Log.i((String)TAG, (String)new StringBuilder(33 + String.valueOf(string).length()).append("Attempting to reflectively call: ").append(string).toString());
        try {
            Class<?> c = Class.forName(methodName.testClassName);
            Method m = c.getDeclaredMethod(methodName.methodName, new Class[0]);
            m.setAccessible(true);
            m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Log.e((String)TAG, (String)"Reflective call failed: ", (Throwable)e);
        }
    }

    protected boolean isPrimaryInstrProcess(@Nullable String argsProcessName) {
        String currentProcessName = ProcessUtil.getCurrentProcessName(this.getTargetContext());
        if (argsProcessName != null) {
            return argsProcessName.equals(currentProcessName);
        }
        return currentProcessName.equals(this.getTargetContext().getApplicationInfo().processName);
    }

    public class ActivityFinisher
    implements Runnable {
        @Override
        public void run() {
            ArrayList<Activity> activities = new ArrayList<Activity>();
            for (Stage s : EnumSet.range(Stage.CREATED, Stage.STOPPED)) {
                activities.addAll(MonitoringInstrumentation.this.mLifecycleMonitor.getActivitiesInStage(s));
            }
            int n = activities.size();
            Log.i((String)MonitoringInstrumentation.TAG, (String)new StringBuilder(60).append("Activities that are still in CREATED to STOPPED: ").append(n).toString());
            for (Activity activity : activities) {
                if (activity.isFinishing()) continue;
                try {
                    String string = String.valueOf(activity);
                    Log.i((String)MonitoringInstrumentation.TAG, (String)new StringBuilder(20 + String.valueOf(string).length()).append("Finishing activity: ").append(string).toString());
                    activity.finish();
                }
                catch (RuntimeException e) {
                    Log.e((String)MonitoringInstrumentation.TAG, (String)"Failed to finish activity.", (Throwable)e);
                }
            }
        }
    }

    private static class StubResultCallable
    implements Callable<Instrumentation.ActivityResult> {
        private final Intent mIntent;

        StubResultCallable(Intent intent) {
            this.mIntent = intent;
        }

        @Override
        public Instrumentation.ActivityResult call() {
            return IntentStubberRegistry.getInstance().getActivityResultForIntent(this.mIntent);
        }
    }
}

